/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.PerDocConsumer;
import org.apache.lucene.codecs.PerDocProducerBase;
import org.apache.lucene.codecs.lucene40.values.Writer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.PerDocWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;

public abstract class DocValuesWriterBase
extends PerDocConsumer {
    protected final String segmentName;
    private final Counter bytesUsed;
    protected final IOContext context;
    private final float acceptableOverheadRatio;
    public static final String INDEX_EXTENSION = "idx";
    public static final String DATA_EXTENSION = "dat";

    protected DocValuesWriterBase(PerDocWriteState state) {
        this(state, 0.5f);
    }

    protected DocValuesWriterBase(PerDocWriteState state, float acceptableOverheadRatio) {
        this.segmentName = state.segmentInfo.name;
        this.bytesUsed = state.bytesUsed;
        this.context = state.context;
        this.acceptableOverheadRatio = acceptableOverheadRatio;
    }

    protected abstract Directory getDirectory() throws IOException;

    @Override
    public void close() throws IOException {
    }

    @Override
    public DocValuesConsumer addValuesField(DocValues.Type valueType, FieldInfo field) throws IOException {
        return Writer.create(valueType, PerDocProducerBase.docValuesId(this.segmentName, field.number), this.getDirectory(), this.getComparator(), this.bytesUsed, this.context, this.acceptableOverheadRatio);
    }

    public Comparator<BytesRef> getComparator() throws IOException {
        return BytesRef.getUTF8SortedAsUnicodeComparator();
    }
}

