/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesArraySource;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.IOUtils;

public class SimpleTextDocValuesConsumer
extends DocValuesConsumer {
    static final BytesRef ZERO_DOUBLE = new BytesRef(Double.toString(0.0));
    static final BytesRef ZERO_INT = new BytesRef(Integer.toString(0));
    static final BytesRef HEADER = new BytesRef("SimpleTextDocValues");
    static final BytesRef END = new BytesRef("END");
    static final BytesRef VALUE_SIZE = new BytesRef("valuesize ");
    static final BytesRef DOC = new BytesRef("  doc ");
    static final BytesRef VALUE = new BytesRef("    value ");
    protected BytesRef scratch = new BytesRef();
    protected int maxDocId = -1;
    protected final String segment;
    protected final Directory dir;
    protected final IOContext ctx;
    protected final DocValues.Type type;
    protected final BytesRefHash hash;
    private int[] ords;
    private int valueSize = Integer.MIN_VALUE;
    private BytesRef zeroBytes;
    private final String segmentSuffix;

    public SimpleTextDocValuesConsumer(String segment, Directory dir, IOContext ctx, DocValues.Type type, String segmentSuffix) {
        this.ctx = ctx;
        this.dir = dir;
        this.segment = segment;
        this.type = type;
        this.hash = new BytesRefHash();
        this.ords = new int[0];
        this.segmentSuffix = segmentSuffix;
    }

    @Override
    public void add(int docID, IndexableField value) throws IOException {
        int ord;
        int vSize;
        assert (docID >= 0);
        switch (this.type) {
            case BYTES_FIXED_DEREF: 
            case BYTES_FIXED_SORTED: 
            case BYTES_FIXED_STRAIGHT: {
                vSize = value.binaryValue().length;
                ord = this.hash.add(value.binaryValue());
                break;
            }
            case BYTES_VAR_DEREF: 
            case BYTES_VAR_SORTED: 
            case BYTES_VAR_STRAIGHT: {
                vSize = -1;
                ord = this.hash.add(value.binaryValue());
                break;
            }
            case FIXED_INTS_16: {
                vSize = 2;
                this.scratch.grow(2);
                DocValuesArraySource.copyShort(this.scratch, value.numericValue().shortValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case FIXED_INTS_32: {
                vSize = 4;
                this.scratch.grow(4);
                DocValuesArraySource.copyInt(this.scratch, value.numericValue().intValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case FIXED_INTS_8: {
                vSize = 1;
                this.scratch.grow(1);
                this.scratch.bytes[this.scratch.offset] = value.numericValue().byteValue();
                this.scratch.length = 1;
                ord = this.hash.add(this.scratch);
                break;
            }
            case FIXED_INTS_64: {
                vSize = 8;
                this.scratch.grow(8);
                DocValuesArraySource.copyLong(this.scratch, value.numericValue().longValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case VAR_INTS: {
                vSize = -1;
                this.scratch.grow(8);
                DocValuesArraySource.copyLong(this.scratch, value.numericValue().longValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case FLOAT_32: {
                vSize = 4;
                this.scratch.grow(4);
                DocValuesArraySource.copyInt(this.scratch, Float.floatToRawIntBits(value.numericValue().floatValue()));
                ord = this.hash.add(this.scratch);
                break;
            }
            case FLOAT_64: {
                vSize = 8;
                this.scratch.grow(8);
                DocValuesArraySource.copyLong(this.scratch, Double.doubleToRawLongBits(value.numericValue().doubleValue()));
                ord = this.hash.add(this.scratch);
                break;
            }
            default: {
                throw new RuntimeException("should not reach this line");
            }
        }
        if (this.valueSize == Integer.MIN_VALUE) {
            assert (this.maxDocId == -1);
            this.valueSize = vSize;
        } else if (this.valueSize != vSize) {
            throw new IllegalArgumentException("value size must be " + this.valueSize + " but was: " + vSize);
        }
        this.maxDocId = Math.max(docID, this.maxDocId);
        this.ords = this.grow(this.ords, docID);
        this.ords[docID] = (ord < 0 ? -ord - 1 : ord) + 1;
    }

    protected BytesRef getHeader() {
        return HEADER;
    }

    private int[] grow(int[] array, int upto) {
        if (array.length <= upto) {
            return ArrayUtil.grow(array, 1 + upto);
        }
        return array;
    }

    private void prepareFlush(int docCount) {
        assert (this.ords != null);
        this.ords = this.grow(this.ords, docCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(int docCount) throws IOException {
        block6: {
            IndexOutput output;
            block5: {
                String fileName = IndexFileNames.segmentFileName(this.segment, "", this.segmentSuffix);
                output = this.dir.createOutput(fileName, this.ctx);
                boolean success = false;
                BytesRef spare = new BytesRef();
                try {
                    SimpleTextUtil.write(output, this.getHeader());
                    SimpleTextUtil.writeNewline(output);
                    SimpleTextUtil.write(output, VALUE_SIZE);
                    SimpleTextUtil.write(output, Integer.toString(this.valueSize), this.scratch);
                    SimpleTextUtil.writeNewline(output);
                    this.prepareFlush(docCount);
                    for (int i = 0; i < docCount; ++i) {
                        SimpleTextUtil.write(output, DOC);
                        SimpleTextUtil.write(output, Integer.toString(i), this.scratch);
                        SimpleTextUtil.writeNewline(output);
                        SimpleTextUtil.write(output, VALUE);
                        this.writeDoc(output, i, spare);
                        SimpleTextUtil.writeNewline(output);
                    }
                    SimpleTextUtil.write(output, END);
                    SimpleTextUtil.writeNewline(output);
                    success = true;
                    this.hash.close();
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    this.hash.close();
                    if (success) {
                        IOUtils.close(output);
                    } else {
                        IOUtils.closeWhileHandlingException(output);
                    }
                    throw throwable;
                }
                IOUtils.close(output);
                break block6;
            }
            IOUtils.closeWhileHandlingException(output);
        }
    }

    protected void writeDoc(IndexOutput output, int docId, BytesRef spare) throws IOException {
        int ord = this.ords[docId] - 1;
        if (ord != -1) {
            assert (ord >= 0);
            this.hash.get(ord, spare);
            switch (this.type) {
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    SimpleTextUtil.write(output, spare);
                    break;
                }
                case FIXED_INTS_16: {
                    SimpleTextUtil.write(output, Short.toString(DocValuesArraySource.asShort(spare)), this.scratch);
                    break;
                }
                case FIXED_INTS_32: {
                    SimpleTextUtil.write(output, Integer.toString(DocValuesArraySource.asInt(spare)), this.scratch);
                    break;
                }
                case FIXED_INTS_64: 
                case VAR_INTS: {
                    SimpleTextUtil.write(output, Long.toString(DocValuesArraySource.asLong(spare)), this.scratch);
                    break;
                }
                case FIXED_INTS_8: {
                    assert (spare.length == 1) : spare.length;
                    SimpleTextUtil.write(output, Integer.toString(spare.bytes[spare.offset]), this.scratch);
                    break;
                }
                case FLOAT_32: {
                    float valueFloat = Float.intBitsToFloat(DocValuesArraySource.asInt(spare));
                    SimpleTextUtil.write(output, Float.toString(valueFloat), this.scratch);
                    break;
                }
                case FLOAT_64: {
                    double valueDouble = Double.longBitsToDouble(DocValuesArraySource.asLong(spare));
                    SimpleTextUtil.write(output, Double.toString(valueDouble), this.scratch);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported type: " + (Object)((Object)this.type));
                }
            }
        } else {
            switch (this.type) {
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: {
                    if (this.zeroBytes == null) {
                        assert (this.valueSize > 0);
                        this.zeroBytes = new BytesRef(new byte[this.valueSize]);
                    }
                    SimpleTextUtil.write(output, this.zeroBytes);
                    break;
                }
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    this.scratch.length = 0;
                    SimpleTextUtil.write(output, this.scratch);
                    break;
                }
                case FIXED_INTS_16: 
                case FIXED_INTS_32: 
                case FIXED_INTS_8: 
                case FIXED_INTS_64: 
                case VAR_INTS: {
                    SimpleTextUtil.write(output, ZERO_INT);
                    break;
                }
                case FLOAT_32: 
                case FLOAT_64: {
                    SimpleTextUtil.write(output, ZERO_DOUBLE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported type: " + (Object)((Object)this.type));
                }
            }
        }
    }

    @Override
    protected DocValues.Type getType() {
        return this.type;
    }

    @Override
    public int getValueSize() {
        return this.valueSize;
    }
}

