/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextTermVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

public class SimpleTextTermVectorsReader
extends TermVectorsReader {
    private ArrayList<Long> offsets;
    private IndexInput in;
    private BytesRef scratch = new BytesRef();
    private CharsRef scratchUTF16 = new CharsRef();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextTermVectorsReader(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        boolean success = false;
        try {
            this.in = directory.openInput(IndexFileNames.segmentFileName(si.name, "", "vec"), context);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
        this.readIndex();
    }

    SimpleTextTermVectorsReader(ArrayList<Long> offsets, IndexInput in) {
        this.offsets = offsets;
        this.in = in;
    }

    private void readIndex() throws IOException {
        this.offsets = new ArrayList();
        while (!this.scratch.equals(SimpleTextTermVectorsWriter.END)) {
            this.readLine();
            if (!StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.DOC)) continue;
            this.offsets.add(this.in.getFilePointer());
        }
    }

    @Override
    public Fields get(int doc) throws IOException {
        if (doc < 0 || doc >= this.offsets.size()) {
            throw new IllegalArgumentException("doc id out of range");
        }
        TreeMap<String, SimpleTVTerms> fields = new TreeMap<String, SimpleTVTerms>();
        this.in.seek(this.offsets.get(doc));
        this.readLine();
        assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.NUMFIELDS));
        int numFields = this.parseIntAt(SimpleTextTermVectorsWriter.NUMFIELDS.length);
        if (numFields == 0) {
            return null;
        }
        for (int i = 0; i < numFields; ++i) {
            this.readLine();
            assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.FIELD));
            this.parseIntAt(SimpleTextTermVectorsWriter.FIELD.length);
            this.readLine();
            assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.FIELDNAME));
            String fieldName = this.readString(SimpleTextTermVectorsWriter.FIELDNAME.length, this.scratch);
            this.readLine();
            assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.FIELDPOSITIONS));
            boolean positions = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDPOSITIONS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.FIELDOFFSETS));
            boolean offsets = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDOFFSETS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.FIELDTERMCOUNT));
            int termCount = this.parseIntAt(SimpleTextTermVectorsWriter.FIELDTERMCOUNT.length);
            SimpleTVTerms terms = new SimpleTVTerms();
            fields.put(fieldName, terms);
            for (int j = 0; j < termCount; ++j) {
                this.readLine();
                assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.TERMTEXT));
                BytesRef term = new BytesRef();
                int termLength = this.scratch.length - SimpleTextTermVectorsWriter.TERMTEXT.length;
                term.grow(termLength);
                term.length = termLength;
                System.arraycopy(this.scratch.bytes, this.scratch.offset + SimpleTextTermVectorsWriter.TERMTEXT.length, term.bytes, term.offset, termLength);
                SimpleTVPostings postings = new SimpleTVPostings();
                terms.terms.put(term, postings);
                this.readLine();
                assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.TERMFREQ));
                postings.freq = this.parseIntAt(SimpleTextTermVectorsWriter.TERMFREQ.length);
                if (!positions && !offsets) continue;
                if (positions) {
                    SimpleTVPostings.access$202(postings, new int[postings.freq]);
                }
                if (offsets) {
                    SimpleTVPostings.access$302(postings, new int[postings.freq]);
                    SimpleTVPostings.access$402(postings, new int[postings.freq]);
                }
                for (int k = 0; k < postings.freq; ++k) {
                    if (positions) {
                        this.readLine();
                        assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.POSITION));
                        ((SimpleTVPostings)postings).positions[k] = this.parseIntAt(SimpleTextTermVectorsWriter.POSITION.length);
                    }
                    if (!offsets) continue;
                    this.readLine();
                    assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.STARTOFFSET));
                    ((SimpleTVPostings)postings).startOffsets[k] = this.parseIntAt(SimpleTextTermVectorsWriter.STARTOFFSET.length);
                    this.readLine();
                    assert (StringHelper.startsWith(this.scratch, SimpleTextTermVectorsWriter.ENDOFFSET));
                    ((SimpleTVPostings)postings).endOffsets[k] = this.parseIntAt(SimpleTextTermVectorsWriter.ENDOFFSET.length);
                }
            }
        }
        return new SimpleTVFields(fields);
    }

    @Override
    public TermVectorsReader clone() {
        if (this.in == null) {
            throw new AlreadyClosedException("this TermVectorsReader is closed");
        }
        return new SimpleTextTermVectorsReader(this.offsets, (IndexInput)this.in.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.in);
        }
        finally {
            this.in = null;
            this.offsets = null;
        }
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine(this.in, this.scratch);
    }

    private int parseIntAt(int offset) throws IOException {
        UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + offset, this.scratch.length - offset, this.scratchUTF16);
        return ArrayUtil.parseInt(this.scratchUTF16.chars, 0, this.scratchUTF16.length);
    }

    private String readString(int offset, BytesRef scratch) {
        UnicodeUtil.UTF8toUTF16(scratch.bytes, scratch.offset + offset, scratch.length - offset, this.scratchUTF16);
        return this.scratchUTF16.toString();
    }

    private static class SimpleTVDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        private boolean didNext;
        private int doc = -1;
        private int nextPos;
        private Bits liveDocs;
        private int[] positions;
        private int[] startOffsets;
        private int[] endOffsets;

        private SimpleTVDocsAndPositionsEnum() {
        }

        @Override
        public int freq() throws IOException {
            if (this.positions != null) {
                return this.positions.length;
            }
            assert (this.startOffsets != null);
            return this.startOffsets.length;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            if (!this.didNext && (this.liveDocs == null || this.liveDocs.get(0))) {
                this.didNext = true;
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) {
            if (!this.didNext && target == 0) {
                return this.nextDoc();
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public void reset(Bits liveDocs, int[] positions, int[] startOffsets, int[] endOffsets) {
            this.liveDocs = liveDocs;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.doc = -1;
            this.didNext = false;
            this.nextPos = 0;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public boolean hasPayload() {
            return false;
        }

        @Override
        public int nextPosition() {
            assert (this.positions != null && this.nextPos < this.positions.length || this.startOffsets != null && this.nextPos < this.startOffsets.length);
            if (this.positions != null) {
                return this.positions[this.nextPos++];
            }
            ++this.nextPos;
            return -1;
        }

        @Override
        public int startOffset() {
            return this.startOffsets[this.nextPos - 1];
        }

        @Override
        public int endOffset() {
            return this.endOffsets[this.nextPos - 1];
        }
    }

    private static class SimpleTVDocsEnum
    extends DocsEnum {
        private boolean didNext;
        private int doc = -1;
        private int freq;
        private Bits liveDocs;

        private SimpleTVDocsEnum() {
        }

        @Override
        public int freq() throws IOException {
            assert (this.freq != -1);
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            if (!this.didNext && (this.liveDocs == null || this.liveDocs.get(0))) {
                this.didNext = true;
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) {
            if (!this.didNext && target == 0) {
                return this.nextDoc();
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public void reset(Bits liveDocs, int freq) {
            this.liveDocs = liveDocs;
            this.freq = freq;
            this.doc = -1;
            this.didNext = false;
        }
    }

    private static class SimpleTVTermsEnum
    extends TermsEnum {
        SortedMap<BytesRef, SimpleTVPostings> terms;
        Iterator<Map.Entry<BytesRef, SimpleTVPostings>> iterator;
        Map.Entry<BytesRef, SimpleTVPostings> current;

        SimpleTVTermsEnum(SortedMap<BytesRef, SimpleTVPostings> terms) {
            this.terms = terms;
            this.iterator = terms.entrySet().iterator();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text, boolean useCache) throws IOException {
            this.iterator = this.terms.tailMap(text).entrySet().iterator();
            if (!this.iterator.hasNext()) {
                return TermsEnum.SeekStatus.END;
            }
            return this.next().equals(text) ? TermsEnum.SeekStatus.FOUND : TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef next() throws IOException {
            if (!this.iterator.hasNext()) {
                return null;
            }
            this.current = this.iterator.next();
            return this.current.getKey();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.current.getKey();
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.current.getValue().freq;
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, boolean needsFreqs) throws IOException {
            SimpleTVDocsEnum e = new SimpleTVDocsEnum();
            e.reset(liveDocs, needsFreqs ? this.current.getValue().freq : -1);
            return e;
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, boolean needsOffsets) throws IOException {
            SimpleTVPostings postings = this.current.getValue();
            if (postings.positions == null && postings.startOffsets == null) {
                return null;
            }
            if (needsOffsets && (postings.startOffsets == null || postings.endOffsets == null)) {
                return null;
            }
            SimpleTVDocsAndPositionsEnum e = new SimpleTVDocsAndPositionsEnum();
            e.reset(liveDocs, postings.positions, postings.startOffsets, postings.endOffsets);
            return e;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }
    }

    private static class SimpleTVPostings {
        private int freq;
        private int[] positions;
        private int[] startOffsets;
        private int[] endOffsets;

        private SimpleTVPostings() {
        }

        static /* synthetic */ int[] access$202(SimpleTVPostings x0, int[] x1) {
            x0.positions = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(SimpleTVPostings x0, int[] x1) {
            x0.startOffsets = x1;
            return x1;
        }

        static /* synthetic */ int[] access$402(SimpleTVPostings x0, int[] x1) {
            x0.endOffsets = x1;
            return x1;
        }
    }

    private static class SimpleTVTerms
    extends Terms {
        final SortedMap<BytesRef, SimpleTVPostings> terms = new TreeMap<BytesRef, SimpleTVPostings>();

        SimpleTVTerms() {
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            return new SimpleTVTermsEnum(this.terms);
        }

        @Override
        public Comparator<BytesRef> getComparator() throws IOException {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public long size() throws IOException {
            return this.terms.size();
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.terms.size();
        }

        @Override
        public int getDocCount() throws IOException {
            return 1;
        }
    }

    private class SimpleTVFields
    extends Fields {
        private final SortedMap<String, SimpleTVTerms> fields;

        SimpleTVFields(SortedMap<String, SimpleTVTerms> fields) throws IOException {
            this.fields = fields;
        }

        @Override
        public FieldsEnum iterator() throws IOException {
            return new FieldsEnum(){
                private Iterator<Map.Entry<String, SimpleTVTerms>> iterator;
                private Map.Entry<String, SimpleTVTerms> current;
                {
                    this.iterator = SimpleTVFields.this.fields.entrySet().iterator();
                    this.current = null;
                }

                @Override
                public String next() throws IOException {
                    if (!this.iterator.hasNext()) {
                        return null;
                    }
                    this.current = this.iterator.next();
                    return this.current.getKey();
                }

                @Override
                public Terms terms() throws IOException {
                    return this.current.getValue();
                }
            };
        }

        @Override
        public Terms terms(String field) throws IOException {
            return (Terms)this.fields.get(field);
        }

        @Override
        public int size() throws IOException {
            return this.fields.size();
        }
    }
}

