/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableFieldType;

public class FieldInfos
implements Iterable<FieldInfo> {
    private final boolean hasFreq;
    private final boolean hasProx;
    private final boolean hasVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final SortedMap<Integer, FieldInfo> byNumber = new TreeMap<Integer, FieldInfo>();
    private final HashMap<String, FieldInfo> byName = new HashMap();
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] infos) {
        boolean hasVectors = false;
        boolean hasProx = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        for (FieldInfo info : infos) {
            assert (!this.byNumber.containsKey(info.number));
            this.byNumber.put(info.number, info);
            assert (!this.byName.containsKey(info.name));
            this.byName.put(info.name, info);
            hasVectors |= info.hasVectors();
            hasProx |= info.isIndexed() && info.getIndexOptions().compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info.isIndexed() && info.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY;
            hasNorms |= info.hasNorms();
            hasDocValues |= info.hasDocValues();
        }
        this.hasVectors = hasVectors;
        this.hasProx = hasProx;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.values = Collections.unmodifiableCollection(this.byNumber.values());
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public int size() {
        assert (this.byNumber.size() == this.byName.size());
        return this.byNumber.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        return fieldNumber >= 0 ? (FieldInfo)this.byNumber.get(fieldNumber) : null;
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;

        Builder() {
            this(new FieldNumbers());
        }

        Builder(FieldNumbers globalFieldNumbers) {
            assert (globalFieldNumbers != null);
            this.globalFieldNumbers = globalFieldNumbers;
        }

        public void add(FieldInfos other) {
            for (FieldInfo fieldInfo : other) {
                this.add(fieldInfo);
            }
        }

        private void putInternal(FieldInfo fi) {
            assert (!this.byName.containsKey(fi.name));
            assert (this.globalFieldNumbers.containsConsistent(fi.number, fi.name));
            this.byName.put(fi.name, fi);
        }

        FieldInfo addOrUpdate(String name, boolean isIndexed, boolean storeTermVector, boolean omitNorms, boolean storePayloads, FieldInfo.IndexOptions indexOptions, DocValues.Type docValues, DocValues.Type normType) {
            return this.addOrUpdateInternal(name, -1, isIndexed, storeTermVector, omitNorms, storePayloads, indexOptions, docValues, normType);
        }

        public FieldInfo addOrUpdate(String name, IndexableFieldType fieldType) {
            return this.addOrUpdateInternal(name, -1, fieldType.indexed(), false, fieldType.omitNorms(), false, fieldType.indexOptions(), null, null);
        }

        private FieldInfo addOrUpdateInternal(String name, int preferredFieldNumber, boolean isIndexed, boolean storeTermVector, boolean omitNorms, boolean storePayloads, FieldInfo.IndexOptions indexOptions, DocValues.Type docValues, DocValues.Type normType) {
            FieldInfo fi = this.fieldInfo(name);
            if (fi == null) {
                int fieldNumber = this.globalFieldNumbers.addOrGet(name, preferredFieldNumber);
                fi = this.addInternal(name, fieldNumber, isIndexed, storeTermVector, omitNorms, storePayloads, indexOptions, docValues, normType);
            } else {
                fi.update(isIndexed, storeTermVector, omitNorms, storePayloads, indexOptions);
                if (docValues != null) {
                    fi.setDocValuesType(docValues);
                }
                if (!fi.omitsNorms() && normType != null) {
                    fi.setNormValueType(normType);
                }
            }
            return fi;
        }

        public FieldInfo add(FieldInfo fi) {
            return this.addOrUpdateInternal(fi.name, fi.number, fi.isIndexed(), fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), fi.getNormType());
        }

        private FieldInfo addInternal(String name, int fieldNumber, boolean isIndexed, boolean storeTermVector, boolean omitNorms, boolean storePayloads, FieldInfo.IndexOptions indexOptions, DocValues.Type docValuesType, DocValues.Type normType) {
            this.globalFieldNumbers.setIfNotSet(fieldNumber, name);
            FieldInfo fi = new FieldInfo(name, isIndexed, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, normType, null);
            this.putInternal(fi);
            return fi;
        }

        public FieldInfo fieldInfo(String fieldName) {
            return this.byName.get(fieldName);
        }

        final FieldInfos finish() {
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldNumbers {
        private final Map<Integer, String> numberToName;
        private final Map<String, Integer> nameToNumber = new HashMap<String, Integer>();
        private int lowestUnassignedFieldNumber = -1;

        FieldNumbers() {
            this.numberToName = new HashMap<Integer, String>();
        }

        synchronized int addOrGet(String fieldName, int preferredFieldNumber) {
            Integer fieldNumber = this.nameToNumber.get(fieldName);
            if (fieldNumber == null) {
                Integer preferredBoxed = preferredFieldNumber;
                if (preferredFieldNumber != -1 && !this.numberToName.containsKey(preferredBoxed)) {
                    fieldNumber = preferredBoxed;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                this.numberToName.put(fieldNumber, fieldName);
                this.nameToNumber.put(fieldName, fieldNumber);
            }
            return fieldNumber;
        }

        synchronized void setIfNotSet(int fieldNumber, String fieldName) {
            Integer boxedFieldNumber = fieldNumber;
            if (!this.numberToName.containsKey(boxedFieldNumber) && !this.nameToNumber.containsKey(fieldName)) {
                this.numberToName.put(boxedFieldNumber, fieldName);
                this.nameToNumber.put(fieldName, boxedFieldNumber);
            } else assert (this.containsConsistent(boxedFieldNumber, fieldName));
        }

        synchronized boolean containsConsistent(Integer number, String name) {
            return name.equals(this.numberToName.get(number)) && number.equals(this.nameToNumber.get(name));
        }
    }
}

