/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.PriorityQueue;

public final class MultiFieldsEnum
extends FieldsEnum {
    private final FieldMergeQueue queue;
    private final FieldsEnumWithSlice[] top;
    private int numTop;
    private final Fields fields;
    private String currentField;

    public MultiFieldsEnum(MultiFields fields, FieldsEnum[] subs, ReaderSlice[] subSlices) throws IOException {
        this.fields = fields;
        this.queue = new FieldMergeQueue(subs.length);
        this.top = new FieldsEnumWithSlice[subs.length];
        ArrayList<FieldsEnumWithSlice> enumWithSlices = new ArrayList<FieldsEnumWithSlice>();
        for (int i = 0; i < subs.length; ++i) {
            assert (subs[i] != null);
            String field = subs[i].next();
            if (field == null) continue;
            FieldsEnumWithSlice sub = new FieldsEnumWithSlice(subs[i], subSlices[i], i);
            enumWithSlices.add(sub);
            sub.current = field;
            this.queue.add(sub);
        }
    }

    @Override
    public String next() throws IOException {
        for (int i = 0; i < this.numTop; ++i) {
            this.top[i].current = this.top[i].fields.next();
            if (this.top[i].current == null) continue;
            this.queue.add(this.top[i]);
        }
        this.numTop = 0;
        if (this.queue.size() > 0) {
            do {
                this.top[this.numTop++] = (FieldsEnumWithSlice)this.queue.pop();
            } while (this.queue.size() != 0 && ((FieldsEnumWithSlice)this.queue.top()).current.equals(this.top[0].current));
            this.currentField = this.top[0].current;
        } else {
            this.currentField = null;
        }
        return this.currentField;
    }

    @Override
    public Terms terms() throws IOException {
        return this.fields.terms(this.currentField);
    }

    private static final class FieldMergeQueue
    extends PriorityQueue<FieldsEnumWithSlice> {
        FieldMergeQueue(int size) {
            super(size);
        }

        @Override
        protected final boolean lessThan(FieldsEnumWithSlice fieldsA, FieldsEnumWithSlice fieldsB) {
            return fieldsA.current.compareTo(fieldsB.current) < 0;
        }
    }

    public static final class FieldsEnumWithSlice {
        public static final FieldsEnumWithSlice[] EMPTY_ARRAY = new FieldsEnumWithSlice[0];
        final FieldsEnum fields;
        final ReaderSlice slice;
        final int index;
        String current;

        public FieldsEnumWithSlice(FieldsEnum fields, ReaderSlice slice, int index) throws IOException {
            this.slice = slice;
            this.index = index;
            assert (slice.length >= 0) : "length=" + slice.length;
            this.fields = fields;
        }
    }
}

