/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.misc.TermStatsQueue;
import org.apache.lucene.misc.TotalTermFreqComparatorSortDescending;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class HighFreqTerms {
    public static final int DEFAULTnumTerms = 100;
    public static int numTerms = 100;

    public static void main(String[] args) throws Exception {
        DirectoryReader reader = null;
        FSDirectory dir = null;
        String field = null;
        boolean IncludeTermFreqs = false;
        if (args.length == 0 || args.length > 4) {
            HighFreqTerms.usage();
            System.exit(1);
        }
        if (args.length > 0) {
            dir = FSDirectory.open(new File(args[0]));
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                IncludeTermFreqs = true;
                continue;
            }
            try {
                numTerms = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                field = args[i];
            }
        }
        reader = DirectoryReader.open(dir);
        TermStats[] terms = HighFreqTerms.getHighFreqTerms(reader, numTerms, field);
        if (!IncludeTermFreqs) {
            for (int i = 0; i < terms.length; ++i) {
                System.out.printf("%s:%s %,d \n", terms[i].field, terms[i].termtext.utf8ToString(), terms[i].docFreq);
            }
        } else {
            TermStats[] termsWithTF = HighFreqTerms.sortByTotalTermFreq(reader, terms);
            for (int i = 0; i < termsWithTF.length; ++i) {
                System.out.printf("%s:%s \t totalTF = %,d \t doc freq = %,d \n", termsWithTF[i].field, termsWithTF[i].termtext.utf8ToString(), termsWithTF[i].totalTermFreq, termsWithTF[i].docFreq);
            }
        }
        reader.close();
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [-t] [number_terms] [field]\n\t -t: include totalTermFreq\n\n");
    }

    public static TermStats[] getHighFreqTerms(IndexReader reader, int numTerms, String field) throws Exception {
        Fields fields;
        TermStatsQueue tiq = null;
        if (field != null) {
            fields = MultiFields.getFields(reader);
            if (fields == null) {
                throw new RuntimeException("field " + field + " not found");
            }
            Terms terms = fields.terms(field);
            if (terms != null) {
                TermsEnum termsEnum = terms.iterator(null);
                tiq = new TermStatsQueue(numTerms);
                tiq.fill(field, termsEnum);
            }
        } else {
            fields = MultiFields.getFields(reader);
            if (fields == null) {
                throw new RuntimeException("no fields found for this index");
            }
            tiq = new TermStatsQueue(numTerms);
            FieldsEnum fieldsEnum = fields.iterator();
            while ((field = fieldsEnum.next()) != null) {
                Terms terms = fieldsEnum.terms();
                if (terms == null) continue;
                tiq.fill(field, terms.iterator(null));
            }
        }
        TermStats[] result = new TermStats[tiq.size()];
        int count = tiq.size() - 1;
        while (tiq.size() != 0) {
            result[count] = (TermStats)tiq.pop();
            --count;
        }
        return result;
    }

    public static TermStats[] sortByTotalTermFreq(IndexReader reader, TermStats[] terms) throws Exception {
        TermStats[] ts = new TermStats[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            long totalTF = HighFreqTerms.getTotalTermFreq(reader, terms[i].field, terms[i].termtext);
            ts[i] = new TermStats(terms[i].field, terms[i].termtext, terms[i].docFreq, totalTF);
        }
        TotalTermFreqComparatorSortDescending c = new TotalTermFreqComparatorSortDescending();
        Arrays.sort(ts, c);
        return ts;
    }

    public static long getTotalTermFreq(IndexReader reader, String field, BytesRef termText) throws Exception {
        long totalTF = 0L;
        for (AtomicReaderContext ctx : reader.getTopReaderContext().leaves()) {
            long totTF;
            AtomicReader r = ctx.reader();
            Bits liveDocs = r.getLiveDocs();
            if (liveDocs == null && (totTF = r.totalTermFreq(field, termText)) != -1L) {
                totalTF += totTF;
                continue;
            }
            DocsEnum de = r.termDocsEnum(liveDocs, field, termText, true);
            if (de == null) continue;
            while (de.nextDoc() != Integer.MAX_VALUE) {
                totalTF += (long)de.freq();
            }
        }
        return totalTF;
    }
}

