/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;

public class NumericIndexDocValueSource
extends ValueSource {
    private final String field;

    public NumericIndexDocValueSource(String field) {
        this.field = field;
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final DocValues.Source source = readerContext.reader().docValues(this.field).getSource();
        DocValues.Type type = source.getType();
        switch (type) {
            case FLOAT_32: 
            case FLOAT_64: {
                return new FunctionValues(){

                    @Override
                    public String toString(int doc) {
                        return "float: [" + this.floatVal(doc) + "]";
                    }

                    @Override
                    public float floatVal(int doc) {
                        return (float)source.getFloat(doc);
                    }
                };
            }
            case VAR_INTS: {
                return new FunctionValues(){

                    @Override
                    public String toString(int doc) {
                        return "float: [" + this.floatVal(doc) + "]";
                    }

                    @Override
                    public float floatVal(int doc) {
                        return source.getInt(doc);
                    }
                };
            }
        }
        throw new IOException("Type: " + (Object)((Object)type) + "is not numeric");
    }

    @Override
    public String description() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericIndexDocValueSource other = (NumericIndexDocValueSource)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }

    @Override
    public String toString() {
        return "FunctionValues float(" + this.field + ')';
    }
}

