/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.DocFreqValueSource;
import org.apache.lucene.util.BytesRef;

public class TermFreqValueSource
extends DocFreqValueSource {
    public TermFreqValueSource(String field, String val, String indexedField, BytesRef indexedBytes) {
        super(field, val, indexedField, indexedBytes);
    }

    @Override
    public String name() {
        return "termfreq";
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        Fields fields = readerContext.reader().fields();
        final Terms terms = fields.terms(this.indexedField);
        return new IntDocValues(this){
            DocsEnum docs;
            int atDoc;
            int lastDocRequested;
            {
                super(x0);
                this.lastDocRequested = -1;
                this.reset();
            }

            public void reset() throws IOException {
                boolean omitTF = false;
                if (terms != null) {
                    TermsEnum termsEnum = terms.iterator(null);
                    if (termsEnum.seekExact(TermFreqValueSource.this.indexedBytes, false)) {
                        this.docs = termsEnum.docs(null, null, true);
                        if (this.docs == null) {
                            omitTF = true;
                            this.docs = termsEnum.docs(null, null, false);
                        }
                    } else {
                        this.docs = null;
                    }
                } else {
                    this.docs = null;
                }
                if (this.docs == null) {
                    this.docs = new DocsEnum(){

                        @Override
                        public int freq() {
                            return 0;
                        }

                        @Override
                        public int docID() {
                            return Integer.MAX_VALUE;
                        }

                        @Override
                        public int nextDoc() throws IOException {
                            return Integer.MAX_VALUE;
                        }

                        @Override
                        public int advance(int target) throws IOException {
                            return Integer.MAX_VALUE;
                        }
                    };
                } else if (omitTF) {
                    final DocsEnum delegate = this.docs;
                    this.docs = new DocsEnum(){

                        @Override
                        public int freq() {
                            return 1;
                        }

                        @Override
                        public int docID() {
                            return delegate.docID();
                        }

                        @Override
                        public int nextDoc() throws IOException {
                            return delegate.nextDoc();
                        }

                        @Override
                        public int advance(int target) throws IOException {
                            return delegate.advance(target);
                        }
                    };
                }
                this.atDoc = -1;
            }

            @Override
            public int intVal(int doc) {
                try {
                    if (doc < this.lastDocRequested) {
                        this.reset();
                    }
                    this.lastDocRequested = doc;
                    if (this.atDoc < doc) {
                        this.atDoc = this.docs.advance(doc);
                    }
                    if (this.atDoc > doc) {
                        return 0;
                    }
                    return this.docs.freq();
                }
                catch (IOException e) {
                    throw new RuntimeException("caught exception in function " + TermFreqValueSource.this.description() + " : doc=" + doc, e);
                }
            }
        };
    }
}

