/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;

class ConjunctionTermScorer
extends Scorer {
    protected final float coord;
    protected int lastDoc = -1;
    protected final DocsAndFreqs[] docsAndFreqs;
    private final DocsAndFreqs lead;

    ConjunctionTermScorer(Weight weight, float coord, DocsAndFreqs[] docsAndFreqs) throws IOException {
        super(weight);
        this.coord = coord;
        this.docsAndFreqs = docsAndFreqs;
        ArrayUtil.mergeSort(docsAndFreqs, new Comparator<DocsAndFreqs>(){

            @Override
            public int compare(DocsAndFreqs o1, DocsAndFreqs o2) {
                return o1.docFreq - o2.docFreq;
            }
        });
        this.lead = docsAndFreqs[0];
    }

    private int doNext(int doc) throws IOException {
        while (true) {
            block5: {
                if (this.lead.doc == Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                for (int i = 1; i < this.docsAndFreqs.length; ++i) {
                    if (this.docsAndFreqs[i].doc < doc) {
                        this.docsAndFreqs[i].doc = this.docsAndFreqs[i].docs.advance(doc);
                    }
                    if (this.docsAndFreqs[i].doc <= doc) {
                        continue;
                    }
                    break block5;
                }
                return doc;
            }
            doc = this.lead.doc = this.lead.docs.nextDoc();
        }
    }

    @Override
    public int advance(int target) throws IOException {
        this.lead.doc = this.lead.docs.advance(target);
        this.lastDoc = this.doNext(this.lead.doc);
        return this.lastDoc;
    }

    @Override
    public int docID() {
        return this.lastDoc;
    }

    @Override
    public int nextDoc() throws IOException {
        this.lead.doc = this.lead.docs.nextDoc();
        this.lastDoc = this.doNext(this.lead.doc);
        return this.lastDoc;
    }

    @Override
    public float score() throws IOException {
        float sum = 0.0f;
        for (DocsAndFreqs docs : this.docsAndFreqs) {
            sum += docs.docScorer.score(this.lastDoc, docs.docs.freq());
        }
        return sum * this.coord;
    }

    static final class DocsAndFreqs {
        final DocsEnum docsAndFreqs;
        final DocsEnum docs;
        final int docFreq;
        final Similarity.ExactSimScorer docScorer;
        int doc = -1;

        DocsAndFreqs(DocsEnum docsAndFreqs, DocsEnum docs, int docFreq, Similarity.ExactSimScorer docScorer) {
            this.docsAndFreqs = docsAndFreqs;
            this.docs = docs;
            this.docFreq = docFreq;
            this.docScorer = docScorer;
        }
    }
}

