/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.util.SorterTemplate;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    private static <T> SorterTemplate getSorter(final List<T> list, final Comparator<? super T> comp) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new SorterTemplate(){
            private T pivot;

            @Override
            protected void swap(int i, int j) {
                Collections.swap(list, i, j);
            }

            @Override
            protected int compare(int i, int j) {
                return comp.compare(list.get(i), list.get(j));
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = list.get(i);
            }

            @Override
            protected int comparePivot(int j) {
                return comp.compare(this.pivot, list.get(j));
            }
        };
    }

    private static <T extends Comparable<? super T>> SorterTemplate getSorter(final List<T> list) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new SorterTemplate(){
            private T pivot;

            @Override
            protected void swap(int i, int j) {
                Collections.swap(list, i, j);
            }

            @Override
            protected int compare(int i, int j) {
                return ((Comparable)list.get(i)).compareTo(list.get(j));
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = (Comparable)list.get(i);
            }

            @Override
            protected int comparePivot(int j) {
                return this.pivot.compareTo(list.get(j));
            }
        };
    }

    public static <T> void quickSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comp).quickSort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void quickSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).quickSort(0, size - 1);
    }

    public static <T> void mergeSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comp).mergeSort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void mergeSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).mergeSort(0, size - 1);
    }

    public static <T> void insertionSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comp).insertionSort(0, size - 1);
    }

    public static <T extends Comparable<? super T>> void insertionSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).insertionSort(0, size - 1);
    }
}

