/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct64
extends PackedInts.MutableImpl {
    private final long[] values;
    private static final int BITS_PER_VALUE = 64;

    public Direct64(int valueCount) {
        super(valueCount, 64);
        this.values = new long[valueCount];
    }

    public Direct64(DataInput in, int valueCount) throws IOException {
        super(valueCount, 64);
        long[] values = new long[valueCount];
        for (int i = 0; i < valueCount; ++i) {
            values[i] = in.readLong();
        }
        this.values = values;
    }

    public Direct64(long[] values) {
        super(values.length, 64);
        this.values = values;
    }

    @Override
    public long get(int index) {
        assert (index >= 0 && index < this.size());
        return this.values[index];
    }

    @Override
    public int get(int index, long[] arr, int off, int len) {
        assert (index >= 0 && index < this.valueCount);
        assert (off + len <= arr.length);
        int gets = Math.min(this.valueCount - index, len);
        System.arraycopy(this.values, index, arr, off, gets);
        return gets;
    }

    @Override
    public void set(int index, long value) {
        this.values[index] = value;
    }

    @Override
    public int set(int index, long[] arr, int off, int len) {
        assert (index >= 0 && index < this.valueCount);
        assert (off + len <= arr.length);
        int sets = Math.min(this.valueCount - index, len);
        System.arraycopy(arr, off, this.values, index, sets);
        return sets;
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        Arrays.fill(this.values, fromIndex, toIndex, val);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.values);
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0L);
    }

    public long[] getArray() {
        return this.values;
    }

    @Override
    public boolean hasArray() {
        return true;
    }
}

