/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.PackedInts;

final class DirectPackedReader
extends PackedInts.ReaderImpl {
    private final IndexInput in;
    private final long startPointer;
    private static final int BLOCK_BITS = 6;
    private static final int MOD_MASK = 63;
    private final long[] masks;

    public DirectPackedReader(int bitsPerValue, int valueCount, IndexInput in) throws IOException {
        super(valueCount, bitsPerValue);
        this.in = in;
        long v = 1L;
        this.masks = new long[bitsPerValue];
        for (int i = 0; i < bitsPerValue; ++i) {
            this.masks[i] = (v *= 2L) - 1L;
        }
        this.startPointer = in.getFilePointer();
    }

    @Override
    public long get(int index) {
        long majorBitPos = (long)index * (long)this.bitsPerValue;
        int elementPos = (int)(majorBitPos >>> 6);
        int bitPos = (int)(majorBitPos & 0x3FL);
        try {
            long result;
            this.in.seek(this.startPointer + (long)(elementPos << 3));
            long l1 = this.in.readLong();
            int bits1 = 64 - bitPos;
            if (bits1 >= this.bitsPerValue) {
                result = l1 >> bits1 - this.bitsPerValue & this.masks[this.bitsPerValue - 1];
            } else {
                int bits2 = this.bitsPerValue - bits1;
                long result1 = (l1 & this.masks[bits1 - 1]) << bits2;
                long l2 = this.in.readLong();
                long result2 = l2 >> 64 - bits2 & this.masks[bits2 - 1];
                result = result1 | result2;
            }
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("failed", ioe);
        }
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }
}

