/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Packed64SingleBlock
extends PackedInts.MutableImpl {
    private static final int[] SUPPORTED_BITS_PER_VALUE = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 16, 21, 32};
    static final int MAX_SUPPORTED_BITS_PER_VALUE = 32;
    private static final long[][] WRITE_MASKS = new long[33][];
    private static final int[][] SHIFTS = new int[33][];
    final long[] blocks;
    final int valuesPerBlock;
    final int[] shifts;
    final long[] writeMasks;
    final long readMask;

    protected static void initMasks(int bpv) {
        int valuesPerBlock = 64 / bpv;
        long[] writeMasks = new long[valuesPerBlock];
        int[] shifts = new int[valuesPerBlock];
        long bits = (1L << bpv) - 1L;
        for (int i = 0; i < valuesPerBlock; ++i) {
            shifts[i] = bpv * i;
            writeMasks[i] = bits << shifts[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Packed64SingleBlock.WRITE_MASKS[bpv] = writeMasks;
        Packed64SingleBlock.SHIFTS[bpv] = shifts;
    }

    public static Packed64SingleBlock create(int valueCount, int bitsPerValue) {
        if (Packed64SingleBlock.isSupported(bitsPerValue)) {
            return new Packed64SingleBlock(valueCount, bitsPerValue);
        }
        throw new IllegalArgumentException("Unsupported bitsPerValue: " + bitsPerValue);
    }

    public static Packed64SingleBlock create(DataInput in, int valueCount, int bitsPerValue) throws IOException {
        Packed64SingleBlock reader = Packed64SingleBlock.create(valueCount, bitsPerValue);
        for (int i = 0; i < reader.blocks.length; ++i) {
            reader.blocks[i] = in.readLong();
        }
        return reader;
    }

    public static boolean isSupported(int bitsPerValue) {
        return Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, bitsPerValue) >= 0;
    }

    public static float overheadPerValue(int bitsPerValue) {
        int valuesPerBlock = 64 / bitsPerValue;
        int overhead = 64 % bitsPerValue;
        return (float)overhead / (float)valuesPerBlock;
    }

    Packed64SingleBlock(int valueCount, int bitsPerValue) {
        super(valueCount, bitsPerValue);
        assert (Packed64SingleBlock.isSupported(bitsPerValue));
        this.valuesPerBlock = 64 / bitsPerValue;
        this.blocks = new long[Packed64SingleBlock.requiredCapacity(valueCount, this.valuesPerBlock)];
        this.shifts = SHIFTS[bitsPerValue];
        this.writeMasks = WRITE_MASKS[bitsPerValue];
        this.readMask = this.writeMasks[0] ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static int requiredCapacity(int valueCount, int valuesPerBlock) {
        return valueCount / valuesPerBlock + (valueCount % valuesPerBlock == 0 ? 0 : 1);
    }

    private int blockOffset(int offset) {
        return offset / this.valuesPerBlock;
    }

    private int offsetInBlock(int offset) {
        return offset % this.valuesPerBlock;
    }

    @Override
    public long get(int index) {
        int o = this.blockOffset(index);
        int b = this.offsetInBlock(index);
        return this.blocks[o] >>> this.shifts[b] & this.readMask;
    }

    @Override
    public int get(int index, long[] arr, int off, int len) {
        assert (len > 0) : "len must be > 0 (got " + len + ")";
        assert (index >= 0 && index < this.valueCount);
        len = Math.min(len, this.valueCount - index);
        assert (off + len <= arr.length);
        int originalIndex = index;
        int offsetInBlock = this.offsetInBlock(index);
        if (offsetInBlock != 0) {
            for (int i = offsetInBlock; i < this.valuesPerBlock && len > 0; --len, ++i) {
                arr[off++] = this.get(index++);
            }
            if (len == 0) {
                return index - originalIndex;
            }
        }
        assert (this.offsetInBlock(index) == 0);
        int startBlock = this.blockOffset(index);
        int endBlock = this.blockOffset(index + len);
        int diff = (endBlock - startBlock) * this.valuesPerBlock;
        index += diff;
        len -= diff;
        for (int block = startBlock; block < endBlock; ++block) {
            for (int i = 0; i < this.valuesPerBlock; ++i) {
                arr[off++] = this.blocks[block] >> this.shifts[i] & this.readMask;
            }
        }
        if (index > originalIndex) {
            return index - originalIndex;
        }
        assert (index == originalIndex);
        return super.get(index, arr, off, len);
    }

    @Override
    public void set(int index, long value) {
        int o = this.blockOffset(index);
        int b = this.offsetInBlock(index);
        this.blocks[o] = this.blocks[o] & this.writeMasks[b] | value << this.shifts[b];
    }

    @Override
    public int set(int index, long[] arr, int off, int len) {
        assert (len > 0) : "len must be > 0 (got " + len + ")";
        assert (index >= 0 && index < this.valueCount);
        len = Math.min(len, this.valueCount - index);
        assert (off + len <= arr.length);
        int originalIndex = index;
        int offsetInBlock = this.offsetInBlock(index);
        if (offsetInBlock != 0) {
            for (int i = offsetInBlock; i < this.valuesPerBlock && len > 0; --len, ++i) {
                this.set(index++, arr[off++]);
            }
            if (len == 0) {
                return index - originalIndex;
            }
        }
        assert (this.offsetInBlock(index) == 0);
        int startBlock = this.blockOffset(index);
        int endBlock = this.blockOffset(index + len);
        int diff = (endBlock - startBlock) * this.valuesPerBlock;
        index += diff;
        len -= diff;
        for (int block = startBlock; block < endBlock; ++block) {
            long next = 0L;
            for (int i = 0; i < this.valuesPerBlock; ++i) {
                next |= arr[off++] << this.shifts[i];
            }
            this.blocks[block] = next;
        }
        if (index > originalIndex) {
            return index - originalIndex;
        }
        assert (index == originalIndex);
        return super.set(index, arr, off, len);
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        int i;
        assert (fromIndex >= 0);
        assert (fromIndex <= toIndex);
        assert ((val & this.readMask) == val);
        if (toIndex - fromIndex <= this.valuesPerBlock << 1) {
            super.fill(fromIndex, toIndex, val);
            return;
        }
        int fromOffsetInBlock = this.offsetInBlock(fromIndex);
        if (fromOffsetInBlock != 0) {
            for (int i2 = fromOffsetInBlock; i2 < this.valuesPerBlock; ++i2) {
                this.set(fromIndex++, val);
            }
            assert (this.offsetInBlock(fromIndex) == 0);
        }
        int fromBlock = this.blockOffset(fromIndex);
        int toBlock = this.blockOffset(toIndex);
        assert (fromBlock * this.valuesPerBlock == fromIndex);
        long blockValue = 0L;
        for (i = 0; i < this.valuesPerBlock; ++i) {
            blockValue |= val << this.shifts[i];
        }
        Arrays.fill(this.blocks, fromBlock, toBlock, blockValue);
        for (i = this.valuesPerBlock * toBlock; i < toIndex; ++i) {
            this.set(i, val);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, 0L);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.blocks);
    }

    @Override
    protected int getFormat() {
        return 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ", size=" + this.size() + ", elements.length=" + this.blocks.length + ")";
    }

    static {
        for (int bpv : SUPPORTED_BITS_PER_VALUE) {
            Packed64SingleBlock.initMasks(bpv);
        }
    }
}

