/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Packed8ThreeBlocks
extends PackedInts.MutableImpl {
    public static final int MAX_SIZE = 0x2AAAAAAA;
    private final byte[] blocks;

    Packed8ThreeBlocks(int valueCount) {
        super(valueCount, 24);
        if (valueCount > 0x2AAAAAAA) {
            throw new ArrayIndexOutOfBoundsException("MAX_SIZE exceeded");
        }
        this.blocks = new byte[3 * valueCount];
    }

    Packed8ThreeBlocks(DataInput in, int valueCount) throws IOException {
        this(valueCount);
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = in.readByte();
        }
        int mod = this.blocks.length % 8;
        if (mod != 0) {
            int pad = 8 - mod;
            for (int i = 0; i < pad; ++i) {
                in.readByte();
            }
        }
    }

    @Override
    public long get(int index) {
        int o = index * 3;
        return ((long)this.blocks[o] & 0xFFL) << 16 | ((long)this.blocks[o + 1] & 0xFFL) << 8 | (long)this.blocks[o + 2] & 0xFFL;
    }

    @Override
    public void set(int index, long value) {
        int o = index * 3;
        this.blocks[o + 2] = (byte)value;
        this.blocks[o + 1] = (byte)(value >> 8);
        this.blocks[o] = (byte)(value >> 16);
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        byte block1 = (byte)(val >> 16);
        byte block2 = (byte)(val >> 8);
        byte block3 = (byte)val;
        int i = fromIndex * 3;
        int end = toIndex * 3;
        while (i < end) {
            this.blocks[i++] = block1;
            this.blocks[i++] = block2;
            this.blocks[i++] = block3;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, (byte)0);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.blocks);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ", size=" + this.size() + ", elements.length=" + this.blocks.length + ")";
    }
}

