/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.PackedInts;

final class PackedReaderIterator
extends PackedInts.ReaderIteratorImpl {
    private long pending;
    private int pendingBitsLeft;
    private int position = -1;
    private final long[] masks;

    public PackedReaderIterator(int valueCount, int bitsPerValue, IndexInput in) throws IOException {
        super(valueCount, bitsPerValue, in);
        this.masks = new long[bitsPerValue];
        long v = 1L;
        for (int i = 0; i < bitsPerValue; ++i) {
            this.masks[i] = (v *= 2L) - 1L;
        }
    }

    @Override
    public long next() throws IOException {
        long result;
        if (this.pendingBitsLeft == 0) {
            this.pending = this.in.readLong();
            this.pendingBitsLeft = 64;
        }
        if (this.pendingBitsLeft >= this.bitsPerValue) {
            result = this.pending >> this.pendingBitsLeft - this.bitsPerValue & this.masks[this.bitsPerValue - 1];
            this.pendingBitsLeft -= this.bitsPerValue;
        } else {
            int bits1 = this.bitsPerValue - this.pendingBitsLeft;
            long result1 = (this.pending & this.masks[this.pendingBitsLeft - 1]) << bits1;
            this.pending = this.in.readLong();
            long result2 = this.pending >> 64 - bits1 & this.masks[bits1 - 1];
            this.pendingBitsLeft = 64 + this.pendingBitsLeft - this.bitsPerValue;
            result = result1 | result2;
        }
        ++this.position;
        return result;
    }

    @Override
    public int ord() {
        return this.position;
    }

    @Override
    public long advance(int ord) throws IOException {
        assert (ord < this.valueCount) : "ord must be less than valueCount";
        assert (ord > this.position) : "ord must be greater than the current position";
        long bits = this.bitsPerValue;
        int posToSkip = ord - 1 - this.position;
        long bitsToSkip = bits * (long)posToSkip;
        if (bitsToSkip < (long)this.pendingBitsLeft) {
            this.pendingBitsLeft = (int)((long)this.pendingBitsLeft - bitsToSkip);
        } else {
            long skip = bitsToSkip - (long)this.pendingBitsLeft;
            long closestByte = skip >> 6 << 3;
            if (closestByte != 0L) {
                long filePointer = this.in.getFilePointer();
                this.in.seek(filePointer + closestByte);
            }
            this.pending = this.in.readLong();
            this.pendingBitsLeft = 64 - (int)(skip % 64L);
        }
        this.position = ord - 1;
        return this.next();
    }
}

