/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilter;
import org.apache.lucene.analysis.util.CharFilterFactory;

public class PatternReplaceCharFilterFactory
extends CharFilterFactory {
    private Pattern p;
    private String replacement;
    private int maxBlockChars;
    private String blockDelimiters;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.p = this.getPattern("pattern");
        this.replacement = args.get("replacement");
        if (this.replacement == null) {
            this.replacement = "";
        }
        this.maxBlockChars = this.getInt("maxBlockChars", 10000);
        this.blockDelimiters = args.get("blockDelimiters");
    }

    @Override
    public CharStream create(CharStream input) {
        return new PatternReplaceCharFilter(this.p, this.replacement, this.maxBlockChars, this.blockDelimiters, input);
    }
}

