/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.Encoder;
import org.apache.commons.codec.language.Caverphone2;
import org.apache.commons.codec.language.ColognePhonetic;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.PhoneticFilter;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class PhoneticFilterFactory
extends TokenFilterFactory {
    public static final String ENCODER = "encoder";
    public static final String INJECT = "inject";
    public static final String MAX_CODE_LENGTH = "maxCodeLength";
    private static final String PACKAGE_CONTAINING_ENCODERS = "org.apache.commons.codec.language.";
    private static final Map<String, Class<? extends Encoder>> registry = new HashMap<String, Class<? extends Encoder>>(6);
    protected boolean inject = true;
    protected String name = null;
    protected Class<? extends Encoder> clazz = null;
    protected Method setMaxCodeLenMethod = null;
    protected Integer maxCodeLength = null;

    @Override
    public void init(Map<String, String> args) {
        String v;
        super.init(args);
        this.inject = this.getBoolean(INJECT, true);
        String name = args.get(ENCODER);
        if (name == null) {
            throw new InitializationException("Missing required parameter: encoder [" + registry.keySet() + "]");
        }
        this.clazz = registry.get(name.toUpperCase(Locale.ENGLISH));
        if (this.clazz == null) {
            this.clazz = this.resolveEncoder(name);
        }
        if ((v = args.get(MAX_CODE_LENGTH)) != null) {
            this.maxCodeLength = Integer.valueOf(v);
            try {
                this.setMaxCodeLenMethod = this.clazz.getMethod("setMaxCodeLen", Integer.TYPE);
            }
            catch (Exception e) {
                throw new InitializationException("Encoder " + name + " / " + this.clazz + " does not support " + MAX_CODE_LENGTH, e);
            }
        }
        this.getEncoder();
    }

    private Class<? extends Encoder> resolveEncoder(String name) {
        String lookupName = name;
        if (name.indexOf(46) == -1) {
            lookupName = PACKAGE_CONTAINING_ENCODERS + name;
        }
        try {
            return Class.forName(lookupName).asSubclass(Encoder.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InitializationException("Unknown encoder: " + name + " must be full class name or one of " + registry.keySet(), cnfe);
        }
        catch (ClassCastException e) {
            throw new InitializationException("Not an encoder: " + name + " must be full class name or one of " + registry.keySet(), e);
        }
    }

    protected Encoder getEncoder() {
        try {
            Encoder encoder = this.clazz.newInstance();
            if (this.maxCodeLength != null && this.setMaxCodeLenMethod != null) {
                this.setMaxCodeLenMethod.invoke((Object)encoder, this.maxCodeLength);
            }
            return encoder;
        }
        catch (Exception e) {
            Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
            throw new InitializationException("Error initializing encoder: " + this.name + " / " + this.clazz, t);
        }
    }

    public PhoneticFilter create(TokenStream input) {
        return new PhoneticFilter(input, this.getEncoder(), this.inject);
    }

    static {
        registry.put("DoubleMetaphone".toUpperCase(Locale.ENGLISH), DoubleMetaphone.class);
        registry.put("Metaphone".toUpperCase(Locale.ENGLISH), Metaphone.class);
        registry.put("Soundex".toUpperCase(Locale.ENGLISH), Soundex.class);
        registry.put("RefinedSoundex".toUpperCase(Locale.ENGLISH), RefinedSoundex.class);
        registry.put("Caverphone".toUpperCase(Locale.ENGLISH), Caverphone2.class);
        registry.put("ColognePhonetic".toUpperCase(Locale.ENGLISH), ColognePhonetic.class);
    }
}

