/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FieldAnalysisResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class FieldAnalysisRequest
extends SolrRequest {
    private String fieldValue;
    private String query;
    private boolean showMatch;
    private List<String> fieldNames;
    private List<String> fieldTypes;

    public FieldAnalysisRequest() {
        super(SolrRequest.METHOD.GET, "/analysis/field");
    }

    public FieldAnalysisRequest(String uri) {
        super(SolrRequest.METHOD.GET, uri);
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    @Override
    public SolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("analysis.fieldvalue", this.fieldValue);
        if (this.query != null) {
            params.add("analysis.query", this.query);
            params.add("analysis.showmatch", String.valueOf(this.showMatch));
        }
        if (this.fieldNames != null) {
            String fieldNameValue = FieldAnalysisRequest.listToCommaDelimitedString(this.fieldNames);
            params.add("analysis.fieldname", fieldNameValue);
        }
        if (this.fieldTypes != null) {
            String fieldTypeValue = FieldAnalysisRequest.listToCommaDelimitedString(this.fieldTypes);
            params.add("analysis.fieldtype", fieldTypeValue);
        }
        return params;
    }

    @Override
    public FieldAnalysisResponse process(SolrServer server) throws SolrServerException, IOException {
        if (this.fieldTypes == null && this.fieldNames == null) {
            throw new IllegalStateException("At least one field type or field name need to be specified");
        }
        if (this.fieldValue == null) {
            throw new IllegalStateException("The field value must be set");
        }
        long startTime = System.currentTimeMillis();
        FieldAnalysisResponse res = new FieldAnalysisResponse();
        res.setResponse(server.request(this));
        res.setElapsedTime(System.currentTimeMillis() - startTime);
        return res;
    }

    static String listToCommaDelimitedString(List<String> list) {
        StringBuilder result = new StringBuilder();
        for (String str : list) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(str);
        }
        return result.toString();
    }

    public FieldAnalysisRequest setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
        return this;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public FieldAnalysisRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public FieldAnalysisRequest setShowMatch(boolean showMatch) {
        this.showMatch = showMatch;
        return this;
    }

    public boolean isShowMatch() {
        return this.showMatch;
    }

    public FieldAnalysisRequest addFieldName(String fieldName) {
        if (this.fieldNames == null) {
            this.fieldNames = new LinkedList<String>();
        }
        this.fieldNames.add(fieldName);
        return this;
    }

    public FieldAnalysisRequest setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
        return this;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public FieldAnalysisRequest addFieldType(String fieldTypeName) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new LinkedList<String>();
        }
        this.fieldTypes.add(fieldTypeName);
        return this;
    }

    public FieldAnalysisRequest setFieldTypes(List<String> fieldTypes) {
        this.fieldTypes = fieldTypes;
        return this;
    }

    public List<String> getFieldTypes() {
        return this.fieldTypes;
    }
}

