/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SafeStopThread;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryStrategy
extends Thread
implements SafeStopThread {
    private static final int MAX_RETRIES = 500;
    private static final int INTERRUPTED = 501;
    private static final int START_TIMEOUT = 100;
    private static final String REPLICATION_HANDLER = "/replication";
    private static Logger log = LoggerFactory.getLogger(RecoveryStrategy.class);
    private volatile boolean close = false;
    private ZkController zkController;
    private String baseUrl;
    private String coreZkNodeName;
    private ZkStateReader zkStateReader;
    private volatile String coreName;
    private int retries;
    private boolean recoveringAfterStartup;
    private CoreContainer cc;

    public RecoveryStrategy(CoreContainer cc, String name) {
        this.cc = cc;
        this.coreName = name;
        this.setName("RecoveryThread");
        this.zkController = cc.getZkController();
        this.zkStateReader = this.zkController.getZkStateReader();
        this.baseUrl = this.zkController.getBaseUrl();
        this.coreZkNodeName = this.zkController.getNodeName() + "_" + this.coreName;
    }

    public void setRecoveringAfterStartup(boolean recoveringAfterStartup) {
        this.recoveringAfterStartup = recoveringAfterStartup;
    }

    public void close() {
        this.close = true;
        log.warn("Stopping recovery for core " + this.coreName + " zkNodeName=" + this.coreZkNodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoveryFailed(SolrCore core, ZkController zkController, String baseUrl, String shardZkNodeName, CoreDescriptor cd) throws KeeperException, InterruptedException {
        SolrException.log(log, "Recovery failed - I give up.");
        try {
            zkController.publish(cd, "recovery_failed");
        }
        finally {
            this.close();
        }
    }

    private void replicate(String nodeName, SolrCore core, ZkNodeProps leaderprops, String baseUrl) throws SolrServerException, IOException {
        String leaderBaseUrl = leaderprops.get("base_url");
        ZkCoreNodeProps leaderCNodeProps = new ZkCoreNodeProps(leaderprops);
        String leaderUrl = leaderCNodeProps.getCoreUrl();
        log.info("Attempting to replicate from " + leaderUrl);
        if (!leaderBaseUrl.equals(baseUrl)) {
            boolean success;
            ReplicationHandler replicationHandler;
            this.commitOnLeader(leaderUrl);
            SolrRequestHandler handler = core.getRequestHandler(REPLICATION_HANDLER);
            if (handler instanceof RequestHandlers.LazyRequestHandlerWrapper) {
                handler = ((RequestHandlers.LazyRequestHandlerWrapper)handler).getWrappedHandler();
            }
            if ((replicationHandler = (ReplicationHandler)handler) == null) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Skipping recovery, no /replication handler found");
            }
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.set("masterUrl", leaderUrl + "replication");
            if (this.isClosed()) {
                this.retries = 501;
            }
            if (!(success = replicationHandler.doFetch(solrParams, true))) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replication for recovery failed.");
            }
        }
    }

    private void commitOnLeader(String leaderUrl) throws MalformedURLException, SolrServerException, IOException {
        HttpSolrServer server = new HttpSolrServer(leaderUrl);
        server.setConnectionTimeout(30000);
        server.setSoTimeout(30000);
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams());
        ureq.getParams().set("commit_end_point", true);
        ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true).process(server);
        server.shutdown();
    }

    private void sendPrepRecoveryCmd(String leaderBaseUrl, String leaderCoreName) throws MalformedURLException, SolrServerException, IOException {
        HttpSolrServer server = new HttpSolrServer(leaderBaseUrl);
        server.setConnectionTimeout(45000);
        server.setSoTimeout(45000);
        CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
        prepCmd.setCoreName(leaderCoreName);
        prepCmd.setNodeName(this.zkController.getNodeName());
        prepCmd.setCoreNodeName(this.coreZkNodeName);
        prepCmd.setState("recovering");
        prepCmd.setCheckLive(true);
        prepCmd.setPauseFor(6000);
        server.request(prepCmd);
        server.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SolrCore core = this.cc.getCore(this.coreName);
        if (core == null) {
            SolrException.log(log, "SolrCore not found - cannot recover:" + this.coreName);
            return;
        }
        try {
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, new ModifiableSolrParams());
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            log.info("Starting recovery process. recoveringAfterStartup=" + this.recoveringAfterStartup);
            try {
                this.doRecovery(core);
            }
            catch (KeeperException e) {
                log.error("", e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolrException.log(log, "", e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
            SolrRequestInfo.clearRequestInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecovery(SolrCore core) throws KeeperException, InterruptedException {
        List<Long> recentVersions;
        boolean replayed = false;
        boolean successfulRecovery = false;
        UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            SolrException.log(log, "No UpdateLog found - cannot recover");
            this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
            return;
        }
        UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();
        try {
            recentVersions = recentUpdates.getVersions(ulog.numRecordsToKeep);
        }
        finally {
            recentUpdates.close();
        }
        List<Long> startingVersions = ulog.getStartingVersions();
        if (startingVersions != null && this.recoveringAfterStartup) {
            int oldIdx;
            long firstStartingVersion;
            long l = firstStartingVersion = startingVersions.size() > 0 ? startingVersions.get(0) : 0L;
            for (oldIdx = 0; oldIdx < recentVersions.size() && recentVersions.get(oldIdx) != firstStartingVersion; ++oldIdx) {
            }
            if (oldIdx > 0) {
                log.info("####### Found new versions added after startup: num=" + oldIdx);
                log.info("###### currentVersions=" + recentVersions);
            }
            log.info("###### startupVersions=" + startingVersions);
        }
        boolean firstTime = true;
        if (this.recoveringAfterStartup) {
            recentVersions = startingVersions;
            if ((ulog.getStartingOperation() & 0x10) != 0) {
                firstTime = false;
            }
        }
        while (!(successfulRecovery || this.isClosed() || this.isInterrupted())) {
            try {
                this.zkController.publish(core.getCoreDescriptor(), "recovering");
                CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
                ZkNodeProps leaderprops = this.zkStateReader.getLeaderProps(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                String leaderBaseUrl = leaderprops.get("base_url");
                String leaderCoreName = leaderprops.get("core");
                String leaderUrl = ZkCoreNodeProps.getCoreUrl(leaderBaseUrl, leaderCoreName);
                this.sendPrepRecoveryCmd(leaderBaseUrl, leaderCoreName);
                if (firstTime) {
                    firstTime = false;
                    log.info("Attempting to PeerSync from " + leaderUrl + " recoveringAfterStartup=" + this.recoveringAfterStartup);
                    PeerSync peerSync = new PeerSync(core, Collections.singletonList(leaderUrl), ulog.numRecordsToKeep);
                    peerSync.setStartingVersions(recentVersions);
                    boolean syncSuccess = peerSync.sync();
                    if (syncSuccess) {
                        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, new ModifiableSolrParams());
                        core.getUpdateHandler().commit(new CommitUpdateCommand(req, false));
                        log.info("Sync Recovery was successful - registering as Active");
                        this.zkController.publish(core.getCoreDescriptor(), "active");
                        successfulRecovery = true;
                        this.close = true;
                        return;
                    }
                    log.info("Sync Recovery was not successful - trying replication");
                }
                log.info("Begin buffering updates");
                ulog.bufferUpdates();
                replayed = false;
                try {
                    this.replicate(this.zkController.getNodeName(), core, leaderprops, leaderUrl);
                    this.replay(ulog);
                    replayed = true;
                    log.info("Recovery was successful - registering as Active");
                    this.zkController.publish(core.getCoreDescriptor(), "active");
                    this.close = true;
                    successfulRecovery = true;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Recovery was interrupted", e);
                    this.retries = 501;
                }
                catch (Throwable t) {
                    log.error("Error while trying to recover", t);
                }
                finally {
                    if (!replayed) {
                        try {
                            ulog.dropBufferedUpdates();
                        }
                        catch (Throwable t) {
                            SolrException.log(log, "", t);
                        }
                    }
                }
            }
            catch (Throwable t) {
                log.error("Error while trying to recover.", t);
            }
            if (successfulRecovery) continue;
            try {
                log.error("Recovery failed - trying again...");
                ++this.retries;
                if (this.retries >= 500) {
                    if (this.retries == 501) break;
                    log.error("Recovery failed - max retries exceeded.");
                    this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
                    break;
                }
            }
            catch (Exception e) {
                log.error("", e);
            }
            try {
                for (int i = 0; i < Math.min(this.retries, 600) && !this.isClosed(); ++i) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Recovery was interrupted", e);
                this.retries = 501;
            }
        }
        log.info("Finished recovery process");
    }

    private Future<UpdateLog.RecoveryInfo> replay(UpdateLog ulog) throws InterruptedException, ExecutionException, TimeoutException {
        Future<UpdateLog.RecoveryInfo> future = ulog.applyBufferedUpdates();
        if (future == null) {
            log.info("No replay needed");
        } else {
            log.info("Replaying buffered documents");
            future.get();
        }
        return future;
    }

    @Override
    public boolean isClosed() {
        return this.close;
    }
}

