/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ConnectionManager;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkOperation;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.SolrZooKeeper;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrZkClient {
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    static final String NEWL = System.getProperty("line.separator");
    static final int DEFAULT_CLIENT_CONNECT_TIMEOUT = 30000;
    private static final Logger log = LoggerFactory.getLogger(SolrZkClient.class);
    private ConnectionManager connManager;
    private volatile SolrZooKeeper keeper;
    private ZkCmdExecutor zkCmdExecutor = new ZkCmdExecutor();
    private volatile boolean isClosed = false;

    public SolrZkClient(String zkServerAddress, int zkClientTimeout) throws InterruptedException, TimeoutException, IOException {
        this(zkServerAddress, zkClientTimeout, new DefaultConnectionStrategy(), null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout, OnReconnect onReonnect) throws InterruptedException, TimeoutException, IOException {
        this(zkServerAddress, zkClientTimeout, new DefaultConnectionStrategy(), onReonnect, zkClientConnectTimeout);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect) throws InterruptedException, TimeoutException, IOException {
        this(zkServerAddress, zkClientTimeout, strat, onReconnect, 30000);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect, int clientConnectTimeout) throws InterruptedException, TimeoutException, IOException {
        this.connManager = new ConnectionManager("ZooKeeperConnection Watcher:" + zkServerAddress, this, zkServerAddress, zkClientTimeout, strat, onReconnect);
        strat.connect(zkServerAddress, zkClientTimeout, this.connManager, new ZkClientConnectionStrategy.ZkUpdate(){

            @Override
            public void update(SolrZooKeeper zooKeeper) {
                SolrZooKeeper oldKeeper = SolrZkClient.this.keeper;
                SolrZkClient.this.keeper = zooKeeper;
                if (oldKeeper != null) {
                    try {
                        oldKeeper.close();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("", e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                    }
                }
            }
        });
        this.connManager.waitForConnected(clientConnectTimeout);
        numOpens.incrementAndGet();
    }

    public boolean isConnected() {
        return this.keeper != null && this.keeper.getState() == ZooKeeper.States.CONNECTED;
    }

    public void delete(final String path, final int version, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            this.zkCmdExecutor.retryOperation(new ZkOperation(){

                public Stat execute() throws KeeperException, InterruptedException {
                    SolrZkClient.this.keeper.delete(path, version);
                    return null;
                }
            });
        } else {
            this.keeper.delete(path, version);
        }
    }

    public Stat exists(final String path, final Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (Stat)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                public Stat execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.exists(path, watcher);
                }
            });
        }
        return this.keeper.exists(path, watcher);
    }

    public Boolean exists(final String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (Boolean)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public Boolean execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.exists(path, null) != null;
                }
            });
        }
        return this.keeper.exists(path, null) != null;
    }

    public String create(final String path, final byte[] data, final List<ACL> acl, final CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (String)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public String execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.create(path, data, acl, createMode);
                }
            });
        }
        return this.keeper.create(path, data, acl, createMode);
    }

    public List<String> getChildren(final String path, final Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (List)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public List<String> execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.getChildren(path, watcher);
                }
            });
        }
        return this.keeper.getChildren(path, watcher);
    }

    public byte[] getData(final String path, final Watcher watcher, final Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (byte[])this.zkCmdExecutor.retryOperation(new ZkOperation(){

                public byte[] execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.getData(path, watcher, stat);
                }
            });
        }
        return this.keeper.getData(path, watcher, stat);
    }

    public Stat setData(final String path, final byte[] data, final int version, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (Stat)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                public Stat execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.setData(path, data, version);
                }
            });
        }
        return this.keeper.setData(path, data, version);
    }

    public String create(final String path, final byte[] data, final CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (String)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public String execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
                }
            });
        }
        return this.keeper.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
    }

    public void makePath(String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss);
    }

    public void makePath(String path, File file, boolean failOnExists, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, FileUtils.readFileToString((File)file).getBytes("UTF-8"), CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss);
    }

    public void makePath(String path, File file, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, FileUtils.readFileToString((File)file).getBytes("UTF-8"), retryOnConnLoss);
    }

    public void makePath(String path, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, createMode, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, null, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, watcher, true, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("makePath: " + path);
        }
        boolean retry = true;
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String[] paths = path.split("/");
        StringBuilder sbPath = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            byte[] bytes = null;
            String pathPiece = paths[i];
            sbPath.append("/" + pathPiece);
            final String currentPath = sbPath.toString();
            Stat exists = this.exists(currentPath, watcher, retryOnConnLoss);
            if (exists == null || i == paths.length - 1 && failOnExists) {
                block11: {
                    CreateMode mode = CreateMode.PERSISTENT;
                    if (i == paths.length - 1) {
                        mode = createMode;
                        bytes = data;
                        if (!retryOnConnLoss) {
                            retry = false;
                        }
                    }
                    try {
                        if (retry) {
                            final CreateMode finalMode = mode;
                            final byte[] finalBytes = bytes;
                            this.zkCmdExecutor.retryOperation(new ZkOperation(){

                                @Override
                                public Object execute() throws KeeperException, InterruptedException {
                                    SolrZkClient.this.keeper.create(currentPath, finalBytes, ZooDefs.Ids.OPEN_ACL_UNSAFE, finalMode);
                                    return null;
                                }
                            });
                        } else {
                            this.keeper.create(currentPath, bytes, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
                        }
                    }
                    catch (KeeperException.NodeExistsException e) {
                        if (!failOnExists) {
                            this.setData(currentPath, data, -1, retryOnConnLoss);
                            this.exists(currentPath, watcher, retryOnConnLoss);
                            return;
                        }
                        if (i != paths.length - 1) break block11;
                        throw e;
                    }
                }
                if (i != paths.length - 1) continue;
                this.exists(currentPath, watcher, retryOnConnLoss);
                continue;
            }
            if (i != paths.length - 1) continue;
            this.setData(currentPath, data, -1, retryOnConnLoss);
            this.exists(currentPath, watcher, retryOnConnLoss);
        }
    }

    public void makePath(String zkPath, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(zkPath, null, createMode, watcher, retryOnConnLoss);
    }

    public void setData(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.setData(path, data, -1, retryOnConnLoss);
    }

    public void setData(String path, File file, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("Write to ZooKeepeer " + file.getAbsolutePath() + " to " + path);
        }
        String data = FileUtils.readFileToString((File)file);
        this.setData(path, data.getBytes("UTF-8"), retryOnConnLoss);
    }

    public void printLayout(String path, int indent, StringBuilder string) throws KeeperException, InterruptedException {
        byte[] data = this.getData(path, null, null, true);
        List<String> children = this.getChildren(path, null, true);
        StringBuilder dent = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            dent.append(" ");
        }
        string.append(dent + path + " (" + children.size() + ")" + NEWL);
        if (data != null) {
            try {
                String dataString = new String(data, "UTF-8");
                if (!path.endsWith(".txt") && !path.endsWith(".xml") || path.endsWith("/clusterstate.json")) {
                    if (path.endsWith(".xml")) {
                        dataString = SolrZkClient.prettyPrint(dataString);
                    }
                    string.append(dent + "DATA:\n" + dent + "    " + dataString.replaceAll("\n", "\n" + dent + "    ") + NEWL);
                } else {
                    string.append(dent + "DATA: ...supressed..." + NEWL);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        for (String child : children) {
            if (child.equals("quota")) continue;
            try {
                this.printLayout(path + (path.equals("/") ? "" : "/") + child, indent + 1, string);
            }
            catch (KeeperException.NoNodeException e) {}
        }
    }

    public void printLayoutToStdOut() throws KeeperException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        this.printLayout("/", 0, sb);
        System.out.println(sb.toString());
    }

    public static String prettyPrint(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem pretty printing XML", e);
        }
    }

    private static String prettyPrint(String input) {
        return SolrZkClient.prettyPrint(input, 2);
    }

    public void close() throws InterruptedException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.keeper.close();
        numCloses.incrementAndGet();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void updateKeeper(SolrZooKeeper keeper) throws InterruptedException {
        SolrZooKeeper oldKeeper = this.keeper;
        this.keeper = keeper;
        if (oldKeeper != null) {
            oldKeeper.close();
        }
    }

    public SolrZooKeeper getSolrZooKeeper() {
        return this.keeper;
    }
}

