/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DefaultCodecFactory;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.JmxMonitoredMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrDeletionPolicy;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.StandardDirectoryFactory;
import org.apache.solr.core.StandardIndexReaderFactory;
import org.apache.solr.handler.admin.ShowFileRequestHandler;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.MoreLikeThisComponent;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.CSVResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.PHPResponseWriter;
import org.apache.solr.response.PHPSerializedResponseWriter;
import org.apache.solr.response.PythonResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.RubyResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XMLResponseWriter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrFieldCacheMBean;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class SolrCore
implements SolrInfoMBean {
    public static final String version = "1.0";
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    public static Map<SolrCore, Exception> openHandles = Collections.synchronizedMap(new IdentityHashMap());
    public static Logger log = LoggerFactory.getLogger(SolrCore.class);
    private String name;
    private String logid;
    private final CoreDescriptor coreDescriptor;
    private boolean isReloaded = false;
    private final SolrConfig solrConfig;
    private final SolrResourceLoader resourceLoader;
    private final IndexSchema schema;
    private final String dataDir;
    private final UpdateHandler updateHandler;
    private final long startTime;
    private final RequestHandlers reqHandlers;
    private final Map<String, SearchComponent> searchComponents;
    private final Map<String, UpdateRequestProcessorChain> updateProcessorChains;
    private final Map<String, SolrInfoMBean> infoRegistry;
    private IndexDeletionPolicyWrapper solrDelPolicy;
    private DirectoryFactory directoryFactory;
    private IndexReaderFactory indexReaderFactory;
    private final Codec codec;
    static int boolean_query_max_clause_count = Integer.MIN_VALUE;
    private String lastNewIndexDir;
    final List<SolrEventListener> firstSearcherListeners = new ArrayList<SolrEventListener>();
    final List<SolrEventListener> newSearcherListeners = new ArrayList<SolrEventListener>();
    private static Set<String> dirs = new HashSet<String>();
    private final AtomicInteger refCount = new AtomicInteger(1);
    private Collection<CloseHook> closeHooks = null;
    public static boolean VERBOSE = Boolean.parseBoolean(System.getProperty("tests.verbose", "false"));
    private RefCounted<SolrIndexSearcher> _searcher;
    private final LinkedList<RefCounted<SolrIndexSearcher>> _searchers = new LinkedList();
    private final LinkedList<RefCounted<SolrIndexSearcher>> _realtimeSearchers = new LinkedList();
    final ExecutorService searcherExecutor = Executors.newSingleThreadExecutor();
    private int onDeckSearchers;
    private Object searcherLock = new Object();
    private ReentrantLock openSearcherLock = new ReentrantLock(true);
    private final int maxWarmingSearchers;
    private RefCounted<SolrIndexSearcher> realtimeSearcher;
    private QueryResponseWriter defaultResponseWriter;
    private final Map<String, QueryResponseWriter> responseWriters = new HashMap<String, QueryResponseWriter>();
    public static final Map<String, QueryResponseWriter> DEFAULT_RESPONSE_WRITERS;
    private final Map<String, QParserPlugin> qParserPlugins = new HashMap<String, QParserPlugin>();
    private final HashMap<String, ValueSourceParser> valueSourceParsers = new HashMap();
    private final HashMap<String, TransformerFactory> transformerFactories = new HashMap();

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void booleanQueryMaxClauseCount() {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            if (boolean_query_max_clause_count == Integer.MIN_VALUE) {
                boolean_query_max_clause_count = this.solrConfig.booleanQueryMaxClauseCount;
                BooleanQuery.setMaxClauseCount(boolean_query_max_clause_count);
            } else if (boolean_query_max_clause_count != this.solrConfig.booleanQueryMaxClauseCount) {
                log.debug("BooleanQuery.maxClauseCount= " + boolean_query_max_clause_count + ", ignoring " + this.solrConfig.booleanQueryMaxClauseCount);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public SolrResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getConfigResource() {
        return this.solrConfig.getResourceName();
    }

    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public String getSchemaResource() {
        return this.schema.getResourceName();
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIndexDir() {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher == null) {
                return this.dataDir + "index/";
            }
            SolrIndexSearcher searcher = this._searcher.get();
            String string = searcher.getIndexDir() == null ? this.dataDir + "index/" : searcher.getIndexDir();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getNewIndexDir() {
        String result;
        block6: {
            File tmp;
            result = this.dataDir + "index/";
            File propsFile = new File(this.dataDir + "index.properties");
            if (!propsFile.exists()) break block6;
            Properties p = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(propsFile);
                p.load(is);
            }
            catch (IOException e) {
                IOUtils.closeQuietly((InputStream)is);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            String s = p.getProperty("index");
            if (s != null && s.trim().length() > 0 && (tmp = new File(this.dataDir + s)).exists() && tmp.isDirectory()) {
                result = this.dataDir + s;
            }
        }
        if (!result.equals(this.lastNewIndexDir)) {
            log.warn("New index directory detected: old=" + this.lastNewIndexDir + " new=" + result);
        }
        this.lastNewIndexDir = result;
        return result;
    }

    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    public IndexReaderFactory getIndexReaderFactory() {
        return this.indexReaderFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
        this.logid = v == null ? "" : "[" + v + "] ";
    }

    public String getLogId() {
        return this.logid;
    }

    public Map<String, SolrInfoMBean> getInfoRegistry() {
        return this.infoRegistry;
    }

    private void initDeletionPolicy() {
        PluginInfo info = this.solrConfig.getPluginInfo(IndexDeletionPolicy.class.getName());
        IndexDeletionPolicy delPolicy = null;
        if (info != null) {
            delPolicy = this.createInstance(info.className, IndexDeletionPolicy.class, "Deletion Policy for SOLR");
            if (delPolicy instanceof NamedListInitializedPlugin) {
                ((NamedListInitializedPlugin)((Object)delPolicy)).init(info.initArgs);
            }
        } else {
            delPolicy = new SolrDeletionPolicy();
        }
        this.solrDelPolicy = new IndexDeletionPolicyWrapper(delPolicy);
    }

    private void initListeners() {
        Class<SolrEventListener> clazz = SolrEventListener.class;
        String label = "Event Listener";
        for (PluginInfo info : this.solrConfig.getPluginInfos(SolrEventListener.class.getName())) {
            SolrEventListener obj;
            String event = info.attributes.get("event");
            if ("firstSearcher".equals(event)) {
                obj = this.createInitInstance(info, clazz, "Event Listener", null);
                this.firstSearcherListeners.add(obj);
                log.info(this.logid + "Added SolrEventListener for firstSearcher: " + obj);
                continue;
            }
            if (!"newSearcher".equals(event)) continue;
            obj = this.createInitInstance(info, clazz, "Event Listener", null);
            this.newSearcherListeners.add(obj);
            log.info(this.logid + "Added SolrEventListener for newSearcher: " + obj);
        }
    }

    public void registerFirstSearcherListener(SolrEventListener listener) {
        this.firstSearcherListeners.add(listener);
    }

    public void registerNewSearcherListener(SolrEventListener listener) {
        this.newSearcherListeners.add(listener);
    }

    public QueryResponseWriter registerResponseWriter(String name, QueryResponseWriter responseWriter) {
        return this.responseWriters.put(name, responseWriter);
    }

    public SolrCore reload(SolrResourceLoader resourceLoader) throws IOException, ParserConfigurationException, SAXException {
        SolrConfig config = new SolrConfig(resourceLoader, this.getSolrConfig().getName(), null);
        IndexSchema schema = new IndexSchema(config, this.getSchema().getResourceName(), null);
        this.updateHandler.incref();
        SolrCore core = new SolrCore(this.getName(), null, config, schema, this.coreDescriptor, this.updateHandler);
        return core;
    }

    public SolrIndexSearcher newSearcher(String name) throws IOException {
        return new SolrIndexSearcher(this, this.getNewIndexDir(), this.schema, this.getSolrConfig().indexConfig, name, false, this.directoryFactory);
    }

    private void initDirectoryFactory() {
        DirectoryFactory dirFactory;
        PluginInfo info = this.solrConfig.getPluginInfo(DirectoryFactory.class.getName());
        if (info != null) {
            dirFactory = this.getResourceLoader().newInstance(info.className, DirectoryFactory.class, new String[0]);
            dirFactory.init(info.initArgs);
        } else {
            dirFactory = new StandardDirectoryFactory();
        }
        this.directoryFactory = dirFactory;
    }

    private void initIndexReaderFactory() {
        IndexReaderFactory indexReaderFactory;
        PluginInfo info = this.solrConfig.getPluginInfo(IndexReaderFactory.class.getName());
        if (info != null) {
            indexReaderFactory = this.resourceLoader.newInstance(info.className, IndexReaderFactory.class, new String[0]);
            indexReaderFactory.init(info.initArgs);
        } else {
            indexReaderFactory = new StandardIndexReaderFactory();
        }
        this.indexReaderFactory = indexReaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initIndex() {
        try {
            String indexDir = this.getNewIndexDir();
            boolean indexExists = this.getDirectoryFactory().exists(indexDir);
            Class<SolrCore> clazz = SolrCore.class;
            synchronized (SolrCore.class) {
                Directory dir;
                boolean firstTime = dirs.add(new File(indexDir).getCanonicalPath());
                // ** MonitorExit[var4_4] (shouldn't be in output)
                boolean removeLocks = this.solrConfig.unlockOnStartup;
                this.initIndexReaderFactory();
                if (indexExists && firstTime && (dir = this.directoryFactory.get(indexDir, this.getSolrConfig().indexConfig.lockType)) != null) {
                    if (IndexWriter.isLocked(dir)) {
                        if (removeLocks) {
                            log.warn(this.logid + "WARNING: Solr index directory '{}' is locked.  Unlocking...", (Object)indexDir);
                            IndexWriter.unlock(dir);
                        } else {
                            log.error(this.logid + "Solr index directory '{}' is locked.  Throwing exception", (Object)indexDir);
                            throw new LockObtainFailedException("Index locked for write for core " + this.name);
                        }
                    }
                    this.directoryFactory.release(dir);
                }
                if (!indexExists) {
                    log.warn(this.logid + "Solr index directory '" + new File(indexDir) + "' doesn't exist." + " Creating new index...");
                    SolrIndexWriter writer = new SolrIndexWriter("SolrCore.initIndex", indexDir, this.getDirectoryFactory(), true, this.schema, this.solrConfig.indexConfig, this.solrDelPolicy, this.codec, false);
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T createInstance(String className, Class<T> cast, String msg) {
        Class<T> clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            Constructor<?>[] cons;
            clazz = this.getResourceLoader().findClass(className, cast, new String[0]);
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] types = con.getParameterTypes();
                if (types.length != 1 || types[0] != SolrCore.class) continue;
                return (T)con.newInstance(this);
            }
            return this.getResourceLoader().newInstance(className, cast, new String[0]);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + cast.getName(), e);
        }
    }

    private UpdateHandler createReloadedUpdateHandler(String className, String msg, UpdateHandler updateHandler) {
        Class<UpdateHandler> clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            Constructor<?>[] cons;
            clazz = this.getResourceLoader().findClass(className, UpdateHandler.class, new String[0]);
            Object justSolrCoreCon = null;
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] types = con.getParameterTypes();
                if (types.length != 2 || types[0] != SolrCore.class || types[1] != UpdateHandler.class) continue;
                return (UpdateHandler)con.newInstance(this, updateHandler);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " could not find proper constructor for " + UpdateHandler.class.getName());
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + UpdateHandler.class.getName(), e);
        }
    }

    public <T> T createInitInstance(PluginInfo info, Class<T> cast, String msg, String defClassName) {
        if (info == null) {
            return null;
        }
        T o = this.createInstance(info.className == null ? defClassName : info.className, cast, msg);
        if (o instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)o).init(info);
        } else if (o instanceof NamedListInitializedPlugin) {
            ((NamedListInitializedPlugin)o).init(info.initArgs);
        }
        return o;
    }

    public SolrEventListener createEventListener(String className) {
        return this.createInstance(className, SolrEventListener.class, "Event Listener");
    }

    public SolrRequestHandler createRequestHandler(String className) {
        return this.createInstance(className, SolrRequestHandler.class, "Request Handler");
    }

    private UpdateHandler createUpdateHandler(String className) {
        return this.createInstance(className, UpdateHandler.class, "Update Handler");
    }

    private UpdateHandler createUpdateHandler(String className, UpdateHandler updateHandler) {
        return this.createReloadedUpdateHandler(className, "Update Handler", updateHandler);
    }

    private QueryResponseWriter createQueryResponseWriter(String className) {
        return this.createInstance(className, QueryResponseWriter.class, "Query Response Writer");
    }

    public SolrCore(String name, String dataDir, SolrConfig config, IndexSchema schema, CoreDescriptor cd) {
        this(name, dataDir, config, schema, cd, null);
    }

    public SolrCore(String name, String dataDir, SolrConfig config, IndexSchema schema, CoreDescriptor cd, UpdateHandler updateHandler) {
        this.coreDescriptor = cd;
        this.setName(name);
        this.resourceLoader = config.getResourceLoader();
        if (dataDir == null) {
            if (cd.usingDefaultDataDir()) {
                dataDir = config.getDataDir();
            }
            if (dataDir == null) {
                dataDir = cd.getDataDir();
            }
        }
        dataDir = SolrResourceLoader.normalizeDir(dataDir);
        log.info(this.logid + "Opening new SolrCore at " + this.resourceLoader.getInstanceDir() + ", dataDir=" + dataDir);
        if (schema == null) {
            schema = new IndexSchema(config, "schema.xml", null);
        }
        if (config.jmxConfig.enabled) {
            this.infoRegistry = new JmxMonitoredMap(name, String.valueOf(this.hashCode()), config.jmxConfig);
        } else {
            log.info("JMX monitoring not detected for core: " + name);
            this.infoRegistry = new ConcurrentHashMap<String, SolrInfoMBean>();
        }
        this.infoRegistry.put("fieldCache", new SolrFieldCacheMBean());
        this.schema = schema;
        this.dataDir = dataDir;
        this.solrConfig = config;
        this.startTime = System.currentTimeMillis();
        this.maxWarmingSearchers = config.maxWarmingSearchers;
        this.booleanQueryMaxClauseCount();
        this.initListeners();
        this.initDeletionPolicy();
        this.codec = this.initCodec(this.solrConfig, schema);
        if (updateHandler == null) {
            this.initDirectoryFactory();
        } else {
            this.directoryFactory = updateHandler.getSolrCoreState().getDirectoryFactory();
            this.isReloaded = true;
        }
        this.initIndex();
        this.initWriters();
        this.initQParsers();
        this.initValueSourceParsers();
        this.initTransformerFactories();
        this.searchComponents = Collections.unmodifiableMap(this.loadSearchComponents());
        this.updateProcessorChains = this.loadUpdateProcessorChains();
        this.reqHandlers = new RequestHandlers(this);
        this.reqHandlers.initHandlersFromConfig(this.solrConfig);
        this.initDeprecatedSupport();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            this.searcherExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    latch.await();
                    return null;
                }
            });
            this.getSearcher(false, false, null);
            String updateHandlerClass = this.solrConfig.getUpdateHandlerInfo().className;
            this.updateHandler = updateHandler == null ? this.createUpdateHandler(updateHandlerClass == null ? DirectUpdateHandler2.class.getName() : updateHandlerClass) : this.createUpdateHandler(updateHandlerClass == null ? DirectUpdateHandler2.class.getName() : updateHandlerClass, updateHandler);
            this.infoRegistry.put("updateHandler", this.updateHandler);
            this.resourceLoader.inform(this.resourceLoader);
            this.resourceLoader.inform(this);
        }
        catch (Throwable e) {
            latch.countDown();
            this.close();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, e);
        }
        finally {
            latch.countDown();
        }
        this.infoRegistry.put("core", this);
        this.resourceLoader.inform(this.infoRegistry);
    }

    private Codec initCodec(SolrConfig solrConfig, IndexSchema schema) {
        CodecFactory factory;
        PluginInfo info = solrConfig.getPluginInfo(CodecFactory.class.getName());
        if (info != null) {
            factory = schema.getResourceLoader().newInstance(info.className, CodecFactory.class, new String[0]);
            factory.init(info.initArgs);
        } else {
            factory = new DefaultCodecFactory();
        }
        return factory.create(schema);
    }

    private Map<String, UpdateRequestProcessorChain> loadUpdateProcessorChains() {
        HashMap<String, UpdateRequestProcessorChain> map = new HashMap<String, UpdateRequestProcessorChain>();
        UpdateRequestProcessorChain def = this.initPlugins(map, UpdateRequestProcessorChain.class, UpdateRequestProcessorChain.class.getName());
        if (def == null) {
            def = (UpdateRequestProcessorChain)map.get(null);
        }
        if (def == null) {
            UpdateRequestProcessorFactory[] factories = new UpdateRequestProcessorFactory[]{new LogUpdateProcessorFactory(), new DistributedUpdateProcessorFactory(), new RunUpdateProcessorFactory()};
            def = new UpdateRequestProcessorChain(factories, this);
        }
        map.put(null, def);
        map.put("", def);
        return map;
    }

    public UpdateRequestProcessorChain getUpdateProcessingChain(String name) {
        UpdateRequestProcessorChain chain = this.updateProcessorChains.get(name);
        if (chain == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown UpdateRequestProcessorChain: " + name);
        }
        return chain;
    }

    final void open() {
        this.refCount.incrementAndGet();
    }

    public void close() {
        int count = this.refCount.decrementAndGet();
        if (count > 0) {
            return;
        }
        if (count < 0) {
            log.error("Too many close [count:{}] on {}. Please report this exception to solr-user@lucene.apache.org", count, (Object)this);
            return;
        }
        log.info(this.logid + " CLOSING SolrCore " + this);
        if (this.closeHooks != null) {
            for (CloseHook hook : this.closeHooks) {
                try {
                    hook.preClose(this);
                }
                catch (Throwable e) {
                    SolrException.log(log, e);
                }
            }
        }
        try {
            this.infoRegistry.clear();
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
        try {
            this.searcherExecutor.shutdown();
            if (!this.searcherExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.error("Timeout waiting for searchExecutor to terminate");
            }
        }
        catch (InterruptedException e) {
            this.searcherExecutor.shutdownNow();
            try {
                if (!this.searcherExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    log.error("Timeout waiting for searchExecutor to terminate");
                }
            }
            catch (InterruptedException e2) {
                SolrException.log(log, e2);
            }
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
        try {
            this.closeSearcher();
        }
        catch (Throwable e) {
            SolrException.log(log, e);
        }
        try {
            if (this.updateHandler != null) {
                this.updateHandler.close();
            }
        }
        catch (Throwable e) {
            SolrException.log(log, e);
        }
        if (this.closeHooks != null) {
            for (CloseHook hook : this.closeHooks) {
                try {
                    hook.postClose(this);
                }
                catch (Throwable e) {
                    SolrException.log(log, e);
                }
            }
        }
    }

    public int getOpenCount() {
        return this.refCount.get();
    }

    public boolean isClosed() {
        return this.refCount.get() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.getOpenCount() != 0) {
                log.error("REFCOUNT ERROR: unreferenced " + this + " (" + this.getName() + ") has a reference count of " + this.getOpenCount());
            }
        }
        finally {
            super.finalize();
        }
    }

    public void addCloseHook(CloseHook hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new ArrayList<CloseHook>();
        }
        this.closeHooks.add(hook);
    }

    public static void verbose(Object ... args) {
        if (!VERBOSE) {
            return;
        }
        StringBuilder sb = new StringBuilder("VERBOSE:");
        sb.append(Thread.currentThread().getName());
        sb.append(':');
        for (Object o : args) {
            sb.append(' ');
            sb.append(o == null ? "(null)" : o.toString());
        }
        System.out.println(sb.toString());
    }

    public SolrRequestHandler getRequestHandler(String handlerName) {
        return this.reqHandlers.get(handlerName);
    }

    public Map<String, SolrRequestHandler> getRequestHandlers(Class clazz) {
        return this.reqHandlers.getAll(clazz);
    }

    public Map<String, SolrRequestHandler> getRequestHandlers() {
        return this.reqHandlers.getRequestHandlers();
    }

    public SolrRequestHandler registerRequestHandler(String handlerName, SolrRequestHandler handler) {
        return this.reqHandlers.register(handlerName, handler);
    }

    private Map<String, SearchComponent> loadSearchComponents() {
        HashMap<String, SearchComponent> components = new HashMap<String, SearchComponent>();
        this.initPlugins(components, SearchComponent.class);
        for (Map.Entry e : components.entrySet()) {
            SearchComponent c = (SearchComponent)e.getValue();
            if (!(c instanceof HighlightComponent)) continue;
            HighlightComponent hl = (HighlightComponent)c;
            if ("highlight".equals(e.getKey())) break;
            components.put("highlight", hl);
            break;
        }
        this.addIfNotPresent(components, "highlight", HighlightComponent.class);
        this.addIfNotPresent(components, "query", QueryComponent.class);
        this.addIfNotPresent(components, "facet", FacetComponent.class);
        this.addIfNotPresent(components, "mlt", MoreLikeThisComponent.class);
        this.addIfNotPresent(components, "stats", StatsComponent.class);
        this.addIfNotPresent(components, "debug", DebugComponent.class);
        this.addIfNotPresent(components, "get", RealTimeGetComponent.class);
        return components;
    }

    private <T> void addIfNotPresent(Map<String, T> registry, String name, Class<? extends T> c) {
        if (!registry.containsKey(name)) {
            T searchComp = this.resourceLoader.newInstance(c.getName(), c, new String[0]);
            if (searchComp instanceof NamedListInitializedPlugin) {
                ((NamedListInitializedPlugin)searchComp).init(new NamedList());
            }
            registry.put(name, searchComp);
            if (searchComp instanceof SolrInfoMBean) {
                this.infoRegistry.put(((SolrInfoMBean)searchComp).getName(), (SolrInfoMBean)searchComp);
            }
        }
    }

    public SearchComponent getSearchComponent(String name) {
        SearchComponent component = this.searchComponents.get(name);
        if (component == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Search Component: " + name);
        }
        return component;
    }

    public Map<String, SearchComponent> getSearchComponents() {
        return this.searchComponents;
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public RefCounted<SolrIndexSearcher> getSearcher() {
        try {
            return this.getSearcher(false, true, null);
        }
        catch (IOException e) {
            SolrException.log(log, null, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getRegisteredSearcher() {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null) {
                this._searcher.incref();
            }
            return this._searcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getNewestSearcher(boolean openNew) {
        Object object = this.searcherLock;
        synchronized (object) {
            if (!this._searchers.isEmpty()) {
                RefCounted<SolrIndexSearcher> newest = this._searchers.getLast();
                newest.incref();
                return newest;
            }
        }
        return openNew ? this.getRealtimeSearcher() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefCounted<SolrIndexSearcher> getRealtimeSearcher() {
        RefCounted<SolrIndexSearcher> refCounted = this.searcherLock;
        synchronized (refCounted) {
            if (this.realtimeSearcher != null) {
                this.realtimeSearcher.incref();
                return this.realtimeSearcher;
            }
        }
        this.openSearcherLock.lock();
        try {
            refCounted = this.searcherLock;
            synchronized (refCounted) {
                if (this.realtimeSearcher != null) {
                    this.realtimeSearcher.incref();
                    RefCounted<SolrIndexSearcher> refCounted2 = this.realtimeSearcher;
                    return refCounted2;
                }
            }
            refCounted = this.openNewSearcher(true, true);
            return refCounted;
        }
        finally {
            this.openSearcherLock.unlock();
        }
    }

    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher) throws IOException {
        return this.getSearcher(forceNew, returnSearcher, waitSearcher, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> openNewSearcher(boolean updateHandlerReopens, boolean realtime) {
        RefCounted<SolrIndexSearcher> newestSearcher = null;
        boolean nrt = this.solrConfig.reopenReaders && updateHandlerReopens;
        this.openSearcherLock.lock();
        try {
            SolrIndexSearcher tmp;
            RefCounted<SolrIndexSearcher> refCounted;
            String newIndexDir = this.getNewIndexDir();
            File indexDirFile = null;
            File newIndexDirFile = null;
            if (!nrt) {
                indexDirFile = new File(this.getIndexDir()).getCanonicalFile();
                newIndexDirFile = new File(newIndexDir).getCanonicalFile();
            }
            Object object = this.searcherLock;
            synchronized (object) {
                newestSearcher = this.realtimeSearcher;
                if (newestSearcher != null) {
                    newestSearcher.incref();
                }
            }
            if (newestSearcher != null && this.solrConfig.reopenReaders && (nrt || indexDirFile.equals(newIndexDirFile))) {
                DirectoryReader newReader;
                DirectoryReader currentReader = newestSearcher.get().getIndexReader();
                if (updateHandlerReopens) {
                    IndexWriter writer = this.getUpdateHandler().getSolrCoreState().getIndexWriter(this);
                    newReader = DirectoryReader.openIfChanged(currentReader, writer, true);
                } else {
                    newReader = DirectoryReader.openIfChanged(currentReader);
                }
                if (newReader == null) {
                    if (realtime) {
                        newestSearcher.incref();
                        refCounted = newestSearcher;
                        return refCounted;
                    }
                    currentReader.incRef();
                    newReader = currentReader;
                }
                tmp = new SolrIndexSearcher(this, this.schema, realtime ? "realtime" : "main", newReader, true, !realtime, true, this.directoryFactory);
            } else {
                tmp = new SolrIndexSearcher(this, newIndexDir, this.schema, this.getSolrConfig().indexConfig, "main", true, this.directoryFactory);
            }
            LinkedList<RefCounted<SolrIndexSearcher>> searcherList = realtime ? this._realtimeSearchers : this._searchers;
            RefCounted<SolrIndexSearcher> newSearcher = this.newHolder(tmp, searcherList);
            newSearcher.incref();
            refCounted = this.searcherLock;
            synchronized (refCounted) {
                if (this.realtimeSearcher != null) {
                    this.realtimeSearcher.decref();
                }
                this.realtimeSearcher = newSearcher;
                searcherList.add(this.realtimeSearcher);
            }
            refCounted = newSearcher;
            return refCounted;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error opening new searcher", e);
        }
        finally {
            this.openSearcherLock.unlock();
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher, boolean updateHandlerReopens) throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            if (this.onDeckSearchers > 0 && !forceNew && this._searcher == null) {
                try {
                    this.searcherLock.wait();
                }
                catch (InterruptedException e) {
                    log.info(SolrException.toStr(e));
                }
            }
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            ++this.onDeckSearchers;
            if (this.onDeckSearchers < 1) {
                log.error(this.logid + "ERROR!!! onDeckSearchers is " + this.onDeckSearchers);
                this.onDeckSearchers = 1;
            } else {
                if (this.onDeckSearchers > this.maxWarmingSearchers) {
                    --this.onDeckSearchers;
                    String msg = "Error opening new searcher. exceeded limit of maxWarmingSearchers=" + this.maxWarmingSearchers + ", try again later.";
                    log.warn(this.logid + "" + msg);
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, msg);
                }
                if (this.onDeckSearchers > 1) {
                    log.warn(this.logid + "PERFORMANCE WARNING: Overlapping onDeckSearchers=" + this.onDeckSearchers);
                }
            }
        }
        boolean[] decrementOnDeckCount = new boolean[]{true};
        RefCounted<SolrIndexSearcher> currSearcherHolder = null;
        RefCounted<SolrIndexSearcher> searchHolder = null;
        boolean success = false;
        this.openSearcherLock.lock();
        try {
            searchHolder = this.openNewSearcher(updateHandlerReopens, false);
            if (returnSearcher) {
                searchHolder.incref();
            }
            final RefCounted<SolrIndexSearcher> newSearchHolder = searchHolder;
            final SolrIndexSearcher newSearcher = newSearchHolder.get();
            boolean alreadyRegistered = false;
            Object object2 = this.searcherLock;
            synchronized (object2) {
                if (this._searcher == null) {
                    if (this.solrConfig.useColdSearcher) {
                        this.registerSearcher(newSearchHolder);
                        decrementOnDeckCount[0] = false;
                        alreadyRegistered = true;
                    }
                } else {
                    currSearcherHolder = this._searcher;
                    currSearcherHolder.incref();
                }
            }
            final SolrIndexSearcher currSearcher = currSearcherHolder == null ? null : currSearcherHolder.get();
            Future future = null;
            if (currSearcher != null) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            newSearcher.warm(currSearcher);
                        }
                        catch (Throwable e) {
                            SolrException.log(log, e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher == null && this.firstSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.firstSearcherListeners) {
                                listener.newSearcher(newSearcher, null);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.log(log, null, e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher != null && this.newSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.newSearcherListeners) {
                                listener.newSearcher(newSearcher, currSearcher);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.log(log, null, e);
                        }
                        return null;
                    }
                });
            }
            final RefCounted<SolrIndexSearcher> currSearcherHolderF = currSearcherHolder;
            if (!alreadyRegistered) {
                future = this.searcherExecutor.submit(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() throws Exception {
                        try {
                            SolrCore.this.registerSearcher(newSearchHolder);
                        }
                        catch (Throwable e) {
                            SolrException.log(log, e);
                        }
                        finally {
                            if (currSearcherHolderF != null) {
                                currSearcherHolderF.decref();
                            }
                        }
                        return null;
                    }
                });
            }
            if (waitSearcher != null) {
                waitSearcher[0] = future;
            }
            success = true;
            RefCounted<SolrIndexSearcher> refCounted = returnSearcher ? newSearchHolder : null;
            return refCounted;
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                throw (SolrException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            if (!success) {
                Object object3 = this.searcherLock;
                synchronized (object3) {
                    --this.onDeckSearchers;
                    if (this.onDeckSearchers < 0) {
                        log.error(this.logid + "ERROR!!! onDeckSearchers after decrement=" + this.onDeckSearchers);
                        this.onDeckSearchers = 0;
                    }
                    this.searcherLock.notify();
                }
                if (currSearcherHolder != null) {
                    currSearcherHolder.decref();
                }
                if (searchHolder != null) {
                    searchHolder.decref();
                    if (returnSearcher) {
                        searchHolder.decref();
                    }
                }
            }
            this.openSearcherLock.unlock();
        }
    }

    private RefCounted<SolrIndexSearcher> newHolder(SolrIndexSearcher newSearcher, final List<RefCounted<SolrIndexSearcher>> searcherList) {
        RefCounted<SolrIndexSearcher> holder = new RefCounted<SolrIndexSearcher>(newSearcher){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    Object object = SolrCore.this.searcherLock;
                    synchronized (object) {
                        if (this.refcount.get() > 0) {
                            return;
                        }
                        searcherList.remove(this);
                    }
                    ((SolrIndexSearcher)this.resource).close();
                }
                catch (Throwable e) {
                    SolrException.log(log, "Error closing searcher:", e);
                }
            }
        };
        holder.incref();
        return holder;
    }

    public boolean isReloaded() {
        return this.isReloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearcher(RefCounted<SolrIndexSearcher> newSearcherHolder) throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            try {
                if (this._searcher != null) {
                    this._searcher.decref();
                    this._searcher = null;
                }
                this._searcher = newSearcherHolder;
                SolrIndexSearcher newSearcher = newSearcherHolder.get();
                newSearcher.register();
                log.info(this.logid + "Registered new searcher " + newSearcher);
            }
            catch (Throwable e) {
                SolrCore.log(e);
            }
            finally {
                --this.onDeckSearchers;
                this.searcherLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSearcher() {
        log.info(this.logid + "Closing main searcher on request.");
        Object object = this.searcherLock;
        synchronized (object) {
            if (this.realtimeSearcher != null) {
                this.realtimeSearcher.decref();
                this.realtimeSearcher = null;
            }
            if (this._searcher != null) {
                this._searcher.decref();
                this._searcher = null;
                this.infoRegistry.remove("currentSearcher");
            }
        }
    }

    public void execute(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        if (handler == null) {
            String msg = "Null Request Handler '" + req.getParams().get("qt") + "'";
            if (log.isWarnEnabled()) {
                log.warn(this.logid + msg + ":" + req);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        rsp.add("responseHeader", responseHeader);
        NamedList<Object> toLog = rsp.getToLog();
        toLog.add("webapp", req.getContext().get("webapp"));
        toLog.add("path", req.getContext().get("path"));
        toLog.add("params", "{" + req.getParamString() + "}");
        handler.handleRequest(req, rsp);
        SolrCore.setResponseHeaderValues(handler, req, rsp);
        if (log.isInfoEnabled() && toLog.size() > 0) {
            StringBuilder sb = new StringBuilder(this.logid);
            for (int i = 0; i < toLog.size(); ++i) {
                String name = toLog.getName(i);
                Object val = toLog.getVal(i);
                if (name != null) {
                    sb.append(name).append('=');
                }
                sb.append(val).append(' ');
            }
            log.info(sb.toString());
        }
    }

    public static void setResponseHeaderValues(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        String ep;
        SolrParams params;
        NamedList<Object> responseHeader = rsp.getResponseHeader();
        int qtime = (int)(rsp.getEndTime() - req.getStartTime());
        int status = 0;
        Exception exception = rsp.getException();
        if (exception != null) {
            status = exception instanceof SolrException ? ((SolrException)exception).code() : 500;
        }
        responseHeader.add("status", status);
        responseHeader.add("QTime", qtime);
        if (rsp.getToLog().size() > 0) {
            rsp.getToLog().add("status", status);
            rsp.getToLog().add("QTime", qtime);
        }
        if ((params = req.getParams()).getBool("echoHandler", false)) {
            responseHeader.add("handler", handler.getName());
        }
        if ((ep = params.get("echoParams", null)) != null) {
            CommonParams.EchoParamStyle echoParams = CommonParams.EchoParamStyle.get(ep);
            if (echoParams == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value '" + ep + "' for " + "echoParams" + " parameter, use '" + (Object)((Object)CommonParams.EchoParamStyle.EXPLICIT) + "' or '" + (Object)((Object)CommonParams.EchoParamStyle.ALL) + "'");
            }
            if (echoParams == CommonParams.EchoParamStyle.EXPLICIT) {
                responseHeader.add("params", req.getOriginalParams().toNamedList());
            } else if (echoParams == CommonParams.EchoParamStyle.ALL) {
                responseHeader.add("params", req.getParams().toNamedList());
            }
        }
    }

    public static final void log(Throwable e) {
        SolrException.log(log, null, e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initWriters() {
        LinkedHashMap<PluginInfo, QueryResponseWriter> writers = new LinkedHashMap<PluginInfo, QueryResponseWriter>();
        for (PluginInfo pluginInfo : this.solrConfig.getPluginInfos(QueryResponseWriter.class.getName())) {
            try {
                QueryResponseWriter writer;
                String startup = pluginInfo.attributes.get("startup");
                if (startup != null) {
                    if (!"lazy".equals(startup)) throw new Exception("Unknown startup value: '" + startup + "' for: " + pluginInfo.className);
                    log.info("adding lazy queryResponseWriter: " + pluginInfo.className);
                    writer = new LazyQueryResponseWriterWrapper(this, pluginInfo.className, pluginInfo.initArgs);
                } else {
                    writer = this.createQueryResponseWriter(pluginInfo.className);
                }
                writers.put(pluginInfo, writer);
                QueryResponseWriter old = this.registerResponseWriter(pluginInfo.name, writer);
                if (old != null) {
                    log.warn("Multiple queryResponseWriter registered to the same name: " + pluginInfo.name + " ignoring: " + old.getClass().getName());
                }
                if (pluginInfo.isDefault()) {
                    if (this.defaultResponseWriter != null) {
                        log.warn("Multiple default queryResponseWriter registered, using: " + pluginInfo.name);
                    }
                    this.defaultResponseWriter = writer;
                }
                log.info("created " + pluginInfo.name + ": " + pluginInfo.className);
            }
            catch (Exception ex) {
                SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryResponseWriter init failure", ex);
                SolrException.log(log, null, e);
                throw e;
            }
        }
        for (Map.Entry entry : writers.entrySet()) {
            PluginInfo info = (PluginInfo)entry.getKey();
            QueryResponseWriter writer = (QueryResponseWriter)entry.getValue();
            this.responseWriters.put(info.name, writer);
            if (writer instanceof PluginInfoInitialized) {
                ((PluginInfoInitialized)((Object)writer)).init(info);
                continue;
            }
            writer.init(info.initArgs);
        }
        NamedList emptyList = new NamedList();
        for (Map.Entry<String, QueryResponseWriter> entry : DEFAULT_RESPONSE_WRITERS.entrySet()) {
            if (this.responseWriters.get(entry.getKey()) != null) continue;
            this.responseWriters.put(entry.getKey(), entry.getValue());
            entry.getValue().init(emptyList);
        }
        if (this.defaultResponseWriter != null) return;
        this.defaultResponseWriter = this.responseWriters.get("standard");
    }

    public final QueryResponseWriter getQueryResponseWriter(String writerName) {
        QueryResponseWriter writer;
        if (writerName != null && (writer = this.responseWriters.get(writerName)) != null) {
            return writer;
        }
        return this.defaultResponseWriter;
    }

    public final QueryResponseWriter getQueryResponseWriter(SolrQueryRequest request) {
        return this.getQueryResponseWriter(request.getParams().get("wt"));
    }

    private void initQParsers() {
        this.initPlugins(this.qParserPlugins, QParserPlugin.class);
        for (int i = 0; i < QParserPlugin.standardPlugins.length; i += 2) {
            try {
                String name = (String)QParserPlugin.standardPlugins[i];
                if (null != this.qParserPlugins.get(name)) continue;
                Class clazz = (Class)QParserPlugin.standardPlugins[i + 1];
                QParserPlugin plugin = (QParserPlugin)clazz.newInstance();
                this.qParserPlugins.put(name, plugin);
                plugin.init(null);
                continue;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public QParserPlugin getQueryPlugin(String parserName) {
        QParserPlugin plugin = this.qParserPlugins.get(parserName);
        if (plugin != null) {
            return plugin;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown query parser '" + parserName + "'");
    }

    private void initValueSourceParsers() {
        this.initPlugins(this.valueSourceParsers, ValueSourceParser.class);
        for (Map.Entry<String, ValueSourceParser> entry : ValueSourceParser.standardValueSourceParsers.entrySet()) {
            try {
                String name = entry.getKey();
                if (null != this.valueSourceParsers.get(name)) continue;
                ValueSourceParser valueSourceParser = entry.getValue();
                this.valueSourceParsers.put(name, valueSourceParser);
                valueSourceParser.init(null);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    private void initTransformerFactories() {
        this.initPlugins(this.transformerFactories, TransformerFactory.class);
        for (Map.Entry<String, TransformerFactory> entry : TransformerFactory.defaultFactories.entrySet()) {
            try {
                String name = entry.getKey();
                if (null != this.valueSourceParsers.get(name)) continue;
                TransformerFactory f = entry.getValue();
                this.transformerFactories.put(name, f);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public TransformerFactory getTransformerFactory(String name) {
        return this.transformerFactories.get(name);
    }

    public void addTransformerFactory(String name, TransformerFactory factory) {
        this.transformerFactories.put(name, factory);
    }

    public <T> T initPlugins(Map<String, T> registry, Class<T> type, String defClassName) {
        return this.initPlugins(this.solrConfig.getPluginInfos(type.getName()), registry, type, defClassName);
    }

    public <T> T initPlugins(List<PluginInfo> pluginInfos, Map<String, T> registry, Class<T> type, String defClassName) {
        T def = null;
        for (PluginInfo info : pluginInfos) {
            T o = this.createInitInstance(info, type, type.getSimpleName(), defClassName);
            registry.put(info.name, o);
            if (!info.isDefault()) continue;
            def = o;
        }
        return def;
    }

    public <T> List<T> initPlugins(List<PluginInfo> pluginInfos, Class<T> type, String defClassName) {
        if (pluginInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (PluginInfo info : pluginInfos) {
            result.add(this.createInitInstance(info, type, type.getSimpleName(), defClassName));
        }
        return result;
    }

    public <T> T initPlugins(Map<String, T> registry, Class<T> type) {
        return this.initPlugins(registry, type, null);
    }

    public ValueSourceParser getValueSourceParser(String parserName) {
        return this.valueSourceParsers.get(parserName);
    }

    private void initDeprecatedSupport() {
        String facetSort;
        String gettable = this.solrConfig.get("admin/gettableFiles", null);
        if (gettable != null) {
            log.warn("solrconfig.xml uses deprecated <admin/gettableFiles>, Please update your config to use the ShowFileRequestHandler.");
            if (this.getRequestHandler("/admin/file") == null) {
                NamedList<String> invariants = new NamedList<String>();
                HashSet<String> hide = new HashSet<String>();
                for (String file : this.solrConfig.getResourceLoader().listConfigDir()) {
                    hide.add(file.toUpperCase(Locale.ENGLISH));
                }
                StringTokenizer st = new StringTokenizer(gettable);
                while (st.hasMoreTokens()) {
                    hide.remove(st.nextToken().toUpperCase(Locale.ENGLISH));
                }
                for (String s : hide) {
                    invariants.add("hidden", s);
                }
                NamedList<NamedList<String>> args = new NamedList<NamedList<String>>();
                args.add("invariants", invariants);
                ShowFileRequestHandler handler = new ShowFileRequestHandler();
                handler.init(args);
                this.reqHandlers.register("/admin/file", handler);
                log.warn("adding ShowFileRequestHandler with hidden files: " + hide);
            }
        }
        if ((facetSort = this.solrConfig.get("//bool[@name='facet.sort']", null)) != null) {
            log.warn("solrconfig.xml uses deprecated <bool name='facet.sort'>. Please update your config to use <string name='facet.sort'>.");
        }
    }

    public CoreDescriptor getCoreDescriptor() {
        return this.coreDescriptor;
    }

    public IndexDeletionPolicyWrapper getDeletionPolicy() {
        return this.solrDelPolicy;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public String getDescription() {
        return "SolrCore";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_4x/solr/core/src/java/org/apache/solr/core/SolrCore.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap<Object> lst = new SimpleOrderedMap<Object>();
        lst.add("coreName", this.name == null ? "(null)" : this.name);
        lst.add("startTime", new Date(this.startTime));
        lst.add("refCount", this.getOpenCount());
        if (null != this.getCoreDescriptor() && null != this.getCoreDescriptor().getCoreContainer()) {
            lst.add("aliases", this.getCoreDescriptor().getCoreContainer().getCoreNames(this));
        }
        return lst;
    }

    public Codec getCodec() {
        return this.codec;
    }

    static {
        HashMap<String, QueryResponseWriter> m = new HashMap<String, QueryResponseWriter>();
        m.put("xml", new XMLResponseWriter());
        m.put("standard", (QueryResponseWriter)m.get("xml"));
        m.put("json", new JSONResponseWriter());
        m.put("python", new PythonResponseWriter());
        m.put("php", new PHPResponseWriter());
        m.put("phps", new PHPSerializedResponseWriter());
        m.put("ruby", new RubyResponseWriter());
        m.put("raw", new RawResponseWriter());
        m.put("javabin", new BinaryResponseWriter());
        m.put("csv", new CSVResponseWriter());
        DEFAULT_RESPONSE_WRITERS = Collections.unmodifiableMap(m);
    }

    public final class LazyQueryResponseWriterWrapper
    implements QueryResponseWriter {
        private SolrCore _core;
        private String _className;
        private NamedList _args;
        private QueryResponseWriter _writer;

        public LazyQueryResponseWriterWrapper(SolrCore core, String className, NamedList args) {
            this._core = core;
            this._className = className;
            this._args = args;
            this._writer = null;
        }

        public synchronized QueryResponseWriter getWrappedWriter() {
            if (this._writer == null) {
                try {
                    QueryResponseWriter writer = SolrCore.this.createQueryResponseWriter(this._className);
                    writer.init(this._args);
                    this._writer = writer;
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "lazy loading error", ex);
                }
            }
            return this._writer;
        }

        @Override
        public void init(NamedList args) {
        }

        @Override
        public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
            this.getWrappedWriter().write(writer, request, response);
        }

        @Override
        public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
            return this.getWrappedWriter().getContentType(request, response);
        }
    }
}

