/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.LucenePackage;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoHandler
extends RequestHandlerBase {
    private static Logger log = LoggerFactory.getLogger(SystemInfoHandler.class);
    private String hostname = null;
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    public SystemInfoHandler() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("core", this.getCoreInfo(req.getCore()));
        rsp.add("lucene", SystemInfoHandler.getLuceneInfo());
        rsp.add("jvm", SystemInfoHandler.getJvmInfo());
        rsp.add("system", SystemInfoHandler.getSystemInfo());
        rsp.setHttpCaching(false);
    }

    private SimpleOrderedMap<Object> getCoreInfo(SolrCore core) throws Exception {
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        IndexSchema schema = core.getSchema();
        info.add("schema", schema != null ? schema.getSchemaName() : "no schema!");
        info.add("host", this.hostname);
        info.add("now", new Date());
        info.add("start", new Date(core.getStartTime()));
        SimpleOrderedMap<String> dirs = new SimpleOrderedMap<String>();
        dirs.add("cwd", new File(System.getProperty("user.dir")).getAbsolutePath());
        dirs.add("instance", new File(core.getResourceLoader().getInstanceDir()).getAbsolutePath());
        dirs.add("data", new File(core.getDataDir()).getAbsolutePath());
        dirs.add("index", new File(core.getIndexDir()).getAbsolutePath());
        info.add("directory", dirs);
        return info;
    }

    public static SimpleOrderedMap<Object> getSystemInfo() throws Exception {
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        info.add("name", os.getName());
        info.add("version", os.getVersion());
        info.add("arch", os.getArch());
        info.add("systemLoadAverage", os.getSystemLoadAverage());
        SystemInfoHandler.addGetterIfAvaliable(os, "committedVirtualMemorySize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "freePhysicalMemorySize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "freeSwapSpaceSize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "processCpuTime", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalPhysicalMemorySize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalSwapSpaceSize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "openFileDescriptorCount", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "maxFileDescriptorCount", info);
        try {
            if (!os.getName().toLowerCase(Locale.ENGLISH).startsWith("windows")) {
                info.add("uname", SystemInfoHandler.execute("uname -a"));
                info.add("uptime", SystemInfoHandler.execute("uptime"));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return info;
    }

    static void addGetterIfAvaliable(Object obj, String getter, NamedList<Object> info) {
        try {
            String n = Character.toUpperCase(getter.charAt(0)) + getter.substring(1);
            Method m = obj.getClass().getMethod("get" + n, new Class[0]);
            m.setAccessible(true);
            Object v = m.invoke(obj, (Object[])null);
            if (v != null) {
                info.add(getter, v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execute(String cmd) {
        DataInputStream in = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            in = new DataInputStream(process.getInputStream());
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        catch (Exception ex) {
            String string = "(error executing: " + cmd + ")";
            return string;
        }
        finally {
            if (process != null) {
                IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                IOUtils.closeQuietly((InputStream)process.getInputStream());
                IOUtils.closeQuietly((InputStream)process.getErrorStream());
            }
        }
    }

    public static SimpleOrderedMap<Object> getJvmInfo() {
        SimpleOrderedMap<Object> jvm = new SimpleOrderedMap<Object>();
        jvm.add("version", System.getProperty("java.vm.version"));
        jvm.add("name", System.getProperty("java.vm.name"));
        Runtime runtime = Runtime.getRuntime();
        jvm.add("processors", runtime.availableProcessors());
        DecimalFormat df = new DecimalFormat("#.#");
        SimpleOrderedMap<Object> mem = new SimpleOrderedMap<Object>();
        SimpleOrderedMap<Number> raw = new SimpleOrderedMap<Number>();
        long free = runtime.freeMemory();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        double percentUsed = (double)used / (double)max * 100.0;
        raw.add("free", free);
        mem.add("free", SystemInfoHandler.humanReadableUnits(free, df));
        raw.add("total", total);
        mem.add("total", SystemInfoHandler.humanReadableUnits(total, df));
        raw.add("max", max);
        mem.add("max", SystemInfoHandler.humanReadableUnits(max, df));
        raw.add("used", used);
        mem.add("used", SystemInfoHandler.humanReadableUnits(used, df) + " (%" + df.format(percentUsed) + ")");
        raw.add("used%", percentUsed);
        mem.add("raw", raw);
        jvm.add("memory", mem);
        SimpleOrderedMap<Object> jmx = new SimpleOrderedMap<Object>();
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            jmx.add("bootclasspath", mx.getBootClassPath());
            jmx.add("classpath", mx.getClassPath());
            jmx.add("commandLineArgs", mx.getInputArguments());
            jmx.add("startTime", new Date(mx.getStartTime()));
            jmx.add("upTimeMS", mx.getUptime());
        }
        catch (Exception e) {
            log.warn("Error getting JMX properties", e);
        }
        jvm.add("jmx", jmx);
        return jvm;
    }

    private static SimpleOrderedMap<Object> getLuceneInfo() throws Exception {
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        Package p = SolrCore.class.getPackage();
        info.add("solr-spec-version", p.getSpecificationVersion());
        info.add("solr-impl-version", p.getImplementationVersion());
        p = LucenePackage.class.getPackage();
        info.add("lucene-spec-version", p.getSpecificationVersion());
        info.add("lucene-impl-version", p.getImplementationVersion());
        return info;
    }

    @Override
    public String getDescription() {
        return "Get System Info";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_4x/solr/core/src/java/org/apache/solr/handler/admin/SystemInfoHandler.java $";
    }

    private static String humanReadableUnits(long bytes, DecimalFormat df) {
        String newSizeAndUnits = bytes / 0x40000000L > 0L ? String.valueOf(df.format((float)bytes / 1.0737418E9f)) + " GB" : (bytes / 0x100000L > 0L ? String.valueOf(df.format((float)bytes / 1048576.0f)) + " MB" : (bytes / 1024L > 0L ? String.valueOf(df.format((float)bytes / 1024.0f)) + " KB" : String.valueOf(bytes) + " bytes"));
        return newSizeAndUnits;
    }
}

