/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.CloudState;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformContext;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealTimeGetComponent
extends SearchComponent {
    public static Logger log = LoggerFactory.getLogger(UpdateLog.class);
    public static final String COMPONENT_NAME = "get";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        ReturnFields returnFields = new ReturnFields(rb.req);
        rb.rsp.setReturnFields(returnFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ResponseBuilder rb) throws IOException {
        String[] allIds;
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        String val = params.get("getVersions");
        if (val != null) {
            this.processGetVersions(rb);
            return;
        }
        val = params.get("getUpdates");
        if (val != null) {
            this.processGetUpdates(rb);
            return;
        }
        String[] id = params.getParams("id");
        String[] ids = params.getParams("ids");
        if (id == null && ids == null) {
            return;
        }
        String[] stringArray = allIds = id == null ? new String[]{} : id;
        if (ids != null) {
            ArrayList<String> lst = new ArrayList<String>();
            for (String s : allIds) {
                lst.add(s);
            }
            for (String idList : ids) {
                lst.addAll(StrUtils.splitSmart(idList, ",", true));
            }
            allIds = lst.toArray(new String[lst.size()]);
        }
        SchemaField idField = req.getSchema().getUniqueKeyField();
        FieldType fieldType = idField.getType();
        SolrDocumentList docList = new SolrDocumentList();
        UpdateLog ulog = req.getCore().getUpdateHandler().getUpdateLog();
        RefCounted<SolrIndexSearcher> searcherHolder = null;
        DocTransformer transformer = rsp.getReturnFields().getTransformer();
        if (transformer != null) {
            TransformContext context = new TransformContext();
            context.req = req;
            transformer.setContext(context);
        }
        try {
            SolrIndexSearcher searcher = null;
            BytesRef idBytes = new BytesRef();
            for (String idStr : allIds) {
                int docid;
                Object o;
                fieldType.readableToIndexed(idStr, idBytes);
                if (ulog != null && (o = ulog.lookup(idBytes)) != null) {
                    List entry = (List)o;
                    assert (entry.size() >= 3);
                    int oper = (Integer)entry.get(0) & 0xF;
                    switch (oper) {
                        case 1: {
                            SolrDocument doc = RealTimeGetComponent.toSolrDoc((SolrInputDocument)entry.get(entry.size() - 1), req.getSchema());
                            if (transformer != null) {
                                transformer.transform(doc, -1);
                            }
                            docList.add(doc);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                        }
                    }
                    continue;
                }
                if (searcher == null) {
                    searcherHolder = req.getCore().getRealtimeSearcher();
                    searcher = searcherHolder.get();
                }
                if ((docid = searcher.getFirstMatch(new Term(idField.getName(), idBytes))) < 0) continue;
                Document luceneDocument = searcher.doc(docid);
                SolrDocument doc = RealTimeGetComponent.toSolrDoc(luceneDocument, req.getSchema());
                if (transformer != null) {
                    transformer.transform(doc, docid);
                }
                docList.add(doc);
            }
        }
        finally {
            if (searcherHolder != null) {
                searcherHolder.decref();
            }
        }
        if (ids == null && allIds.length <= 1) {
            rsp.add("doc", docList.size() > 0 ? (SolrDocument)docList.get(0) : null);
        } else {
            docList.setNumFound(docList.size());
            rsp.add("response", docList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrInputDocument getInputDocument(SolrCore core, BytesRef idBytes) throws IOException {
        SolrInputDocument sid = null;
        RefCounted<SolrIndexSearcher> searcherHolder = null;
        try {
            Object o;
            SolrIndexSearcher searcher = null;
            UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
            if (ulog != null && (o = ulog.lookup(idBytes)) != null) {
                List entry = (List)o;
                assert (entry.size() >= 3);
                int oper = (Integer)entry.get(0) & 0xF;
                switch (oper) {
                    case 1: {
                        sid = (SolrInputDocument)entry.get(entry.size() - 1);
                        break;
                    }
                    case 2: {
                        SolrInputDocument solrInputDocument = null;
                        return solrInputDocument;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                    }
                }
            }
            if (sid == null) {
                SchemaField idField;
                int docid;
                if (searcher == null) {
                    searcherHolder = core.getRealtimeSearcher();
                    searcher = searcherHolder.get();
                }
                if ((docid = searcher.getFirstMatch(new Term((idField = core.getSchema().getUniqueKeyField()).getName(), idBytes))) < 0) {
                    SolrInputDocument oper = null;
                    return oper;
                }
                Document luceneDocument = searcher.doc(docid);
                sid = RealTimeGetComponent.toSolrInputDocument(luceneDocument, core.getSchema());
            }
        }
        finally {
            if (searcherHolder != null) {
                searcherHolder.decref();
            }
        }
        return sid;
    }

    private static SolrInputDocument toSolrInputDocument(Document doc, IndexSchema schema) {
        SolrInputDocument out = new SolrInputDocument();
        for (IndexableField f : doc.getFields()) {
            String fname = f.name();
            SchemaField sf = schema.getFieldOrNull(f.name());
            Object val = null;
            if (sf != null) {
                val = sf.getType().toObject(f);
            } else {
                val = f.stringValue();
                if (val == null) {
                    val = f.numericValue();
                }
                if (val == null) {
                    val = f.binaryValue();
                }
                if (val == null) {
                    val = f;
                }
            }
            out.addField(fname, val);
        }
        return out;
    }

    private static SolrDocument toSolrDoc(Document doc, IndexSchema schema) {
        SolrDocument out = new SolrDocument();
        for (IndexableField f : doc.getFields()) {
            Object existing = out.get(f.name());
            if (existing == null) {
                SchemaField sf = schema.getFieldOrNull(f.name());
                if (sf != null && sf.multiValued()) {
                    ArrayList<IndexableField> vals = new ArrayList<IndexableField>();
                    vals.add(f);
                    out.setField(f.name(), vals);
                    continue;
                }
                out.setField(f.name(), f);
                continue;
            }
            out.addField(f.name(), f);
        }
        return out;
    }

    private static SolrDocument toSolrDoc(SolrInputDocument sdoc, IndexSchema schema) {
        Document doc = DocumentBuilder.toDocument(sdoc, schema);
        List<IndexableField> fields = doc.getFields();
        Document out = new Document();
        for (IndexableField f : doc.getFields()) {
            if (!f.fieldType().stored()) continue;
            out.add(f);
        }
        return RealTimeGetComponent.toSolrDoc(out, schema);
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            return this.createSubRequests(rb);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    public int createSubRequests(ResponseBuilder rb) throws IOException {
        ZkController zkController;
        SolrParams params = rb.req.getParams();
        String[] id1 = params.getParams("id");
        String[] ids = params.getParams("ids");
        if (id1 == null && ids == null) {
            return ResponseBuilder.STAGE_DONE;
        }
        ArrayList<String> allIds = new ArrayList<String>();
        if (id1 != null) {
            for (String s : id1) {
                allIds.add(s);
            }
        }
        if (ids != null) {
            for (String s : ids) {
                allIds.addAll(StrUtils.splitSmart(s, ",", true));
            }
        }
        if ((zkController = rb.req.getCore().getCoreDescriptor().getCoreContainer().getZkController()) != null && params.get("shards") == null) {
            SchemaField sf = rb.req.getSchema().getUniqueKeyField();
            CloudDescriptor cloudDescriptor = rb.req.getCore().getCoreDescriptor().getCloudDescriptor();
            String collection = cloudDescriptor.getCollectionName();
            CloudState cloudState = zkController.getCloudState();
            HashMap<String, ArrayList<String>> shardToId = new HashMap<String, ArrayList<String>>();
            for (String string : allIds) {
                BytesRef br = new BytesRef();
                sf.getType().readableToIndexed(string, br);
                int hash = Hash.murmurhash3_x86_32(br.bytes, br.offset, br.length, 0);
                String shard = cloudState.getShard(hash, collection);
                ArrayList<String> idsForShard = (ArrayList<String>)shardToId.get(shard);
                if (idsForShard == null) {
                    idsForShard = new ArrayList<String>(2);
                    shardToId.put(shard, idsForShard);
                }
                idsForShard.add(string);
            }
            for (Map.Entry entry : shardToId.entrySet()) {
                String shard = (String)entry.getKey();
                String shardIdList = StrUtils.join((List)entry.getValue(), ',');
                ShardRequest sreq = new ShardRequest();
                sreq.purpose = 1;
                sreq.shards = this.sliceToShards(rb, collection, shard);
                sreq.actualShards = sreq.shards;
                sreq.params = new ModifiableSolrParams();
                sreq.params.set("shards.qt", "/get");
                sreq.params.set("distrib", false);
                sreq.params.set("ids", shardIdList);
                rb.addRequest(this, sreq);
            }
        } else {
            String shardIdList = StrUtils.join(allIds, ',');
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 1;
            sreq.shards = null;
            sreq.actualShards = sreq.shards;
            sreq.params = new ModifiableSolrParams();
            sreq.params.set("shards.qt", "/get");
            sreq.params.set("distrib", false);
            sreq.params.set("ids", shardIdList);
            rb.addRequest(this, sreq);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    private String[] sliceToShards(ResponseBuilder rb, String collection, String slice) {
        String lookup = collection + '_' + slice;
        for (int i = 0; i < rb.slices.length; ++i) {
            log.info("LOOKUP_SLICE:" + rb.slices[i] + "=" + rb.shards[i]);
            if (!lookup.equals(rb.slices[i]) && !slice.equals(rb.slices[i])) continue;
            return new String[]{rb.shards[i]};
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find shard '" + lookup + "'");
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        this.mergeResponses(rb);
    }

    private void mergeResponses(ResponseBuilder rb) {
        SolrDocumentList docList = new SolrDocumentList();
        for (ShardRequest sreq : rb.finished) {
            for (ShardResponse srsp : sreq.responses) {
                SolrResponse sr = srsp.getSolrResponse();
                NamedList<Object> nl = sr.getResponse();
                SolrDocumentList subList = (SolrDocumentList)nl.get("response");
                docList.addAll(subList);
            }
        }
        if (docList.size() <= 1 && rb.req.getParams().getParams("ids") == null) {
            rb.rsp.add("doc", docList.size() > 0 ? (SolrDocument)docList.get(0) : null);
        } else {
            docList.setNumFound(docList.size());
            rb.rsp.add("response", docList);
        }
    }

    @Override
    public String getDescription() {
        return "query";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_4x/solr/core/src/java/org/apache/solr/handler/component/RealTimeGetComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGetVersions(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        int nVersions = params.getInt("getVersions", -1);
        if (nVersions == -1) {
            return;
        }
        String sync = params.get("sync");
        if (sync != null) {
            this.processSync(rb, nVersions, sync);
            return;
        }
        UpdateLog ulog = req.getCore().getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            return;
        }
        UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();
        try {
            rb.rsp.add("versions", recentUpdates.getVersions(nVersions));
        }
        finally {
            recentUpdates.close();
        }
    }

    public void processSync(ResponseBuilder rb, int nVersions, String sync) {
        List<String> replicas = StrUtils.splitSmart(sync, ",", true);
        PeerSync peerSync = new PeerSync(rb.req.getCore(), replicas, nVersions);
        boolean success = peerSync.sync();
        rb.rsp.add("sync", success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGetUpdates(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        String versionsStr = params.get("getUpdates");
        if (versionsStr == null) {
            return;
        }
        UpdateLog ulog = req.getCore().getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            return;
        }
        List<String> versions = StrUtils.splitSmart(versionsStr, ",", true);
        UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();
        ArrayList<Object> updates = new ArrayList<Object>(versions.size());
        long minVersion = Long.MAX_VALUE;
        try {
            for (String versionStr : versions) {
                long version = Long.parseLong(versionStr);
                try {
                    Object o = recentUpdates.lookup(version);
                    if (o == null) continue;
                    if (version > 0L) {
                        minVersion = Math.min(minVersion, version);
                    }
                    updates.add(o);
                }
                catch (SolrException e) {
                    log.warn("Exception reading log for updates", e);
                }
                catch (ClassCastException e) {
                    log.warn("Exception reading log for updates", e);
                }
            }
            updates.addAll(recentUpdates.getDeleteByQuery(minVersion));
            rb.rsp.add("updates", updates);
        }
        finally {
            recentUpdates.close();
        }
    }
}

