/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.StatsInfo;
import org.apache.solr.handler.component.TermsComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.util.RTimer;

public class ResponseBuilder {
    public SolrQueryRequest req;
    public SolrQueryResponse rsp;
    public boolean doHighlights;
    public boolean doFacets;
    public boolean doStats;
    public boolean doTerms;
    private boolean needDocList = false;
    private boolean needDocSet = false;
    private int fieldFlags = 0;
    private boolean debugTimings;
    private boolean debugQuery;
    private boolean debugResults;
    private QParser qparser = null;
    private String queryString = null;
    private Query query = null;
    private List<Query> filters = null;
    private SortSpec sortSpec = null;
    private GroupingSpecification groupingSpec;
    private ScoreDoc scoreDoc;
    private DocListAndSet results = null;
    private NamedList<Object> debugInfo = null;
    private RTimer timer = null;
    private Query highlightQuery = null;
    public List<SearchComponent> components;
    SolrRequestInfo requestInfo;
    public static final String FIELD_SORT_VALUES = "fsv";
    public static final String SHARDS = "shards";
    public static final String IDS = "ids";
    public static int STAGE_START = 0;
    public static int STAGE_PARSE_QUERY = 1000;
    public static int STAGE_TOP_GROUPS = 1500;
    public static int STAGE_EXECUTE_QUERY = 2000;
    public static int STAGE_GET_FIELDS = 3000;
    public static int STAGE_DONE = Integer.MAX_VALUE;
    public int stage;
    boolean isDistrib;
    public String[] shards;
    public String[] slices;
    public int shards_rows = -1;
    public int shards_start = -1;
    public List<ShardRequest> outgoing;
    public List<ShardRequest> finished;
    public GlobalCollectionStat globalCollectionStat;
    public Map<Object, ShardDoc> resultIds;
    public FacetComponent.FacetInfo _facetInfo;
    SolrDocumentList _responseDocs;
    StatsInfo _statsInfo;
    TermsComponent.TermsHelper _termsHelper;
    SimpleOrderedMap<List<NamedList<Object>>> _pivots;
    public final Map<String, Collection<SearchGroup<BytesRef>>> mergedSearchGroups = new HashMap<String, Collection<SearchGroup<BytesRef>>>();
    public final Map<String, Integer> mergedGroupCounts = new HashMap<String, Integer>();
    public final Map<String, Map<SearchGroup<BytesRef>, Set<String>>> searchGroupToShards = new HashMap<String, Map<SearchGroup<BytesRef>, Set<String>>>();
    public final Map<String, TopGroups<BytesRef>> mergedTopGroups = new HashMap<String, TopGroups<BytesRef>>();
    public final Map<String, QueryCommandResult> mergedQueryCommandResults = new HashMap<String, QueryCommandResult>();
    public final Map<Object, SolrDocument> retrievedDocuments = new HashMap<Object, SolrDocument>();
    public int totalHitCount;
    public int firstPhaseElapsedTime;

    public ResponseBuilder(SolrQueryRequest req, SolrQueryResponse rsp, List<SearchComponent> components) {
        this.req = req;
        this.rsp = rsp;
        this.components = components;
        this.requestInfo = SolrRequestInfo.getRequestInfo();
    }

    public int getShardNum(String shard) {
        for (int i = 0; i < this.shards.length; ++i) {
            if (this.shards[i] != shard && !this.shards[i].equals(shard)) continue;
            return i;
        }
        return -1;
    }

    public void addRequest(SearchComponent me, ShardRequest sreq) {
        this.outgoing.add(sreq);
        if ((sreq.purpose & 1) == 0) {
            for (SearchComponent component : this.components) {
                if (component == me) continue;
                component.modifyRequest(this, me, sreq);
            }
        }
    }

    public void addDebugInfo(String name, Object val) {
        if (this.debugInfo == null) {
            this.debugInfo = new SimpleOrderedMap<Object>();
        }
        this.debugInfo.add(name, val);
    }

    public void addDebug(Object val, String ... path) {
        if (this.debugInfo == null) {
            this.debugInfo = new SimpleOrderedMap<Object>();
        }
        SimpleOrderedMap<Object> target = this.debugInfo;
        for (int i = 0; i < path.length - 1; ++i) {
            String elem = path[i];
            SimpleOrderedMap<Object> newTarget = (SimpleOrderedMap<Object>)this.debugInfo.get(elem);
            if (newTarget == null) {
                newTarget = new SimpleOrderedMap<Object>();
                target.add(elem, newTarget);
            }
            target = newTarget;
        }
        target.add(path[path.length - 1], val);
    }

    public boolean isDebug() {
        return this.debugQuery || this.debugTimings || this.debugResults;
    }

    public boolean isDebugAll() {
        return this.debugQuery && this.debugTimings && this.debugResults;
    }

    public void setDebug(boolean dbg) {
        this.debugQuery = dbg;
        this.debugTimings = dbg;
        this.debugResults = dbg;
    }

    public boolean isDebugTimings() {
        return this.debugTimings;
    }

    public void setDebugTimings(boolean debugTimings) {
        this.debugTimings = debugTimings;
    }

    public boolean isDebugQuery() {
        return this.debugQuery;
    }

    public void setDebugQuery(boolean debugQuery) {
        this.debugQuery = debugQuery;
    }

    public boolean isDebugResults() {
        return this.debugResults;
    }

    public void setDebugResults(boolean debugResults) {
        this.debugResults = debugResults;
    }

    public NamedList<Object> getDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(NamedList<Object> debugInfo) {
        this.debugInfo = debugInfo;
    }

    public int getFieldFlags() {
        return this.fieldFlags;
    }

    public void setFieldFlags(int fieldFlags) {
        this.fieldFlags = fieldFlags;
    }

    public List<Query> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Query> filters) {
        this.filters = filters;
    }

    public Query getHighlightQuery() {
        return this.highlightQuery;
    }

    public void setHighlightQuery(Query highlightQuery) {
        this.highlightQuery = highlightQuery;
    }

    public boolean isNeedDocList() {
        return this.needDocList;
    }

    public void setNeedDocList(boolean needDocList) {
        this.needDocList = needDocList;
    }

    public boolean isNeedDocSet() {
        return this.needDocSet;
    }

    public void setNeedDocSet(boolean needDocSet) {
        this.needDocSet = needDocSet;
    }

    public QParser getQparser() {
        return this.qparser;
    }

    public void setQparser(QParser qparser) {
        this.qparser = qparser;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String qstr) {
        this.queryString = qstr;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public DocListAndSet getResults() {
        return this.results;
    }

    public void setResults(DocListAndSet results) {
        this.results = results;
    }

    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    public void setSortSpec(SortSpec sort) {
        this.sortSpec = sort;
    }

    public GroupingSpecification getGroupingSpec() {
        return this.groupingSpec;
    }

    public void setGroupingSpec(GroupingSpecification groupingSpec) {
        this.groupingSpec = groupingSpec;
    }

    public boolean grouping() {
        return this.groupingSpec != null;
    }

    public RTimer getTimer() {
        return this.timer;
    }

    public void setTimer(RTimer timer) {
        this.timer = timer;
    }

    public SolrIndexSearcher.QueryCommand getQueryCommand() {
        SolrIndexSearcher.QueryCommand cmd = new SolrIndexSearcher.QueryCommand();
        cmd.setQuery(this.getQuery()).setFilterList(this.getFilters()).setSort(this.getSortSpec().getSort()).setOffset(this.getSortSpec().getOffset()).setLen(this.getSortSpec().getCount()).setFlags(this.getFieldFlags()).setNeedDocSet(this.isNeedDocSet()).setScoreDoc(this.getScoreDoc());
        return cmd;
    }

    public void setResult(SolrIndexSearcher.QueryResult result) {
        this.setResults(result.getDocListAndSet());
        if (result.isPartialResults()) {
            this.rsp.getResponseHeader().add("partialResults", Boolean.TRUE);
        }
    }

    public long getNumberDocumentsFound() {
        if (this._responseDocs == null) {
            return 0L;
        }
        return this._responseDocs.getNumFound();
    }

    public ScoreDoc getScoreDoc() {
        return this.scoreDoc;
    }

    public void setScoreDoc(ScoreDoc scoreDoc) {
        this.scoreDoc = scoreDoc;
    }

    public static class GlobalCollectionStat {
        public final long numDocs;
        public final Map<String, Long> dfMap;

        public GlobalCollectionStat(int numDocs, Map<String, Long> dfMap) {
            this.numDocs = numDocs;
            this.dfMap = dfMap;
        }
    }
}

