/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.CurrencyValue;
import org.apache.solr.schema.ExchangeRateProvider;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyField
extends FieldType
implements SchemaAware,
ResourceLoaderAware {
    protected static final String PARAM_DEFAULT_CURRENCY = "defaultCurrency";
    protected static final String PARAM_RATE_PROVIDER_CLASS = "providerClass";
    protected static final Object PARAM_PRECISION_STEP = "precisionStep";
    protected static final String DEFAULT_RATE_PROVIDER_CLASS = "solr.FileExchangeRateProvider";
    protected static final String DEFAULT_DEFAULT_CURRENCY = "USD";
    protected static final String DEFAULT_PRECISION_STEP = "0";
    protected static final String FIELD_SUFFIX_AMOUNT_RAW = "_amount_raw";
    protected static final String FIELD_SUFFIX_CURRENCY = "_currency";
    private IndexSchema schema;
    protected FieldType fieldTypeCurrency;
    protected FieldType fieldTypeAmountRaw;
    private String exchangeRateProviderClass;
    private String defaultCurrency;
    private ExchangeRateProvider provider;
    public static Logger log = LoggerFactory.getLogger(CurrencyField.class);

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.schema = schema;
        this.exchangeRateProviderClass = args.get(PARAM_RATE_PROVIDER_CLASS);
        this.defaultCurrency = args.get(PARAM_DEFAULT_CURRENCY);
        if (this.defaultCurrency == null) {
            this.defaultCurrency = DEFAULT_DEFAULT_CURRENCY;
        }
        if (this.exchangeRateProviderClass == null) {
            this.exchangeRateProviderClass = DEFAULT_RATE_PROVIDER_CLASS;
        }
        if (Currency.getInstance(this.defaultCurrency) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid currency code " + this.defaultCurrency);
        }
        String precisionStepString = args.get(PARAM_PRECISION_STEP);
        if (precisionStepString == null) {
            precisionStepString = DEFAULT_PRECISION_STEP;
        }
        this.fieldTypeAmountRaw = new TrieLongField();
        this.fieldTypeAmountRaw.setTypeName("amount_raw_type_tlong");
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("precisionStep", precisionStepString);
        this.fieldTypeAmountRaw.init(schema, map);
        this.fieldTypeCurrency = new StrField();
        this.fieldTypeCurrency.setTypeName("currency_type_string");
        this.fieldTypeCurrency.init(schema, new HashMap<String, String>());
        args.remove(PARAM_RATE_PROVIDER_CLASS);
        args.remove(PARAM_DEFAULT_CURRENCY);
        args.remove(PARAM_PRECISION_STEP);
        try {
            Class<ExchangeRateProvider> c = schema.getResourceLoader().findClass(this.exchangeRateProviderClass, ExchangeRateProvider.class, new String[0]);
            this.provider = c.newInstance();
            this.provider.init(args);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error instansiating exhange rate provider " + this.exchangeRateProviderClass + ". Please check your FieldType configuration", e);
        }
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public IndexableField[] createFields(SchemaField field, Object externalVal, float boost) {
        CurrencyValue value = CurrencyValue.parse(externalVal.toString(), this.defaultCurrency);
        IndexableField[] f = new IndexableField[field.stored() ? 3 : 2];
        SchemaField amountField = this.getAmountField(field);
        f[0] = amountField.createField(String.valueOf(value.getAmount()), amountField.omitNorms() ? 1.0f : boost);
        SchemaField currencyField = this.getCurrencyField(field);
        f[1] = currencyField.createField(value.getCurrencyCode(), currencyField.omitNorms() ? 1.0f : boost);
        if (field.stored()) {
            org.apache.lucene.document.FieldType customType = new org.apache.lucene.document.FieldType();
            assert (!customType.omitNorms());
            customType.setStored(true);
            String storedValue = externalVal.toString().trim();
            if (storedValue.indexOf(",") < 0) {
                storedValue = storedValue + "," + this.defaultCurrency;
            }
            f[2] = this.createField(field.getName(), storedValue, customType, boost);
        }
        return f;
    }

    private SchemaField getAmountField(SchemaField field) {
        return this.schema.getField(field.getName() + "___" + FIELD_SUFFIX_AMOUNT_RAW);
    }

    private SchemaField getCurrencyField(SchemaField field) {
        return this.schema.getField(field.getName() + "___" + FIELD_SUFFIX_CURRENCY);
    }

    private void createDynamicCurrencyField(String suffix, FieldType type) {
        String name = "*___" + suffix;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("indexed", "true");
        props.put("stored", "false");
        props.put("multiValued", "false");
        props.put("omitNorms", "true");
        int p = SchemaField.calcProps(name, type, props);
        this.schema.registerDynamicField(SchemaField.create(name, type, p, null));
    }

    @Override
    public void inform(IndexSchema indexSchema) {
        this.createDynamicCurrencyField(FIELD_SUFFIX_CURRENCY, this.fieldTypeCurrency);
        this.createDynamicCurrencyField(FIELD_SUFFIX_AMOUNT_RAW, this.fieldTypeAmountRaw);
    }

    @Override
    public void inform(ResourceLoader resourceLoader) {
        this.provider.inform(resourceLoader);
        boolean reloaded = this.provider.reload();
        if (!reloaded) {
            log.warn("Failed reloading currencies");
        }
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        CurrencyValue value = CurrencyValue.parse(externalVal, this.defaultCurrency);
        CurrencyValue valueDefault = value.convertTo(this.provider, this.defaultCurrency);
        return this.getRangeQuery(parser, field, valueDefault, valueDefault, true, true);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        CurrencyValue p1 = CurrencyValue.parse(part1, this.defaultCurrency);
        CurrencyValue p2 = CurrencyValue.parse(part2, this.defaultCurrency);
        if (!p1.getCurrencyCode().equals(p2.getCurrencyCode())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot parse range query " + part1 + " to " + part2 + ": range queries only supported when upper and lower bound have same currency.");
        }
        return this.getRangeQuery(parser, field, p1, p2, minInclusive, maxInclusive);
    }

    public Query getRangeQuery(QParser parser, SchemaField field, CurrencyValue p1, CurrencyValue p2, boolean minInclusive, boolean maxInclusive) {
        String currencyCode = p1.getCurrencyCode();
        CurrencyValueSource vs = new CurrencyValueSource(field, currencyCode, parser);
        return new SolrConstantScoreQuery(new ValueSourceRangeFilter(vs, p1.getAmount() + "", p2.getAmount() + "", minInclusive, maxInclusive));
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        try {
            return new CurrencyValueSource(field, this.defaultCurrency, null).getSortField(reverse);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    public void write(XMLWriter xmlWriter, String name, IndexableField field) throws IOException {
        xmlWriter.writeStr(name, field.stringValue(), false);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField field) throws IOException {
        writer.writeStr(name, field.stringValue(), false);
    }

    public ExchangeRateProvider getProvider() {
        return this.provider;
    }

    class CurrencyValueSource
    extends ValueSource {
        private static final long serialVersionUID = 1L;
        private String targetCurrencyCode;
        private ValueSource currencyValues;
        private ValueSource amountValues;
        private final SchemaField sf;

        public CurrencyValueSource(SchemaField sfield, String targetCurrencyCode, QParser parser) {
            this.sf = sfield;
            this.targetCurrencyCode = targetCurrencyCode;
            SchemaField amountField = CurrencyField.this.schema.getField(this.sf.getName() + "___" + CurrencyField.FIELD_SUFFIX_AMOUNT_RAW);
            SchemaField currencyField2 = CurrencyField.this.schema.getField(this.sf.getName() + "___" + CurrencyField.FIELD_SUFFIX_CURRENCY);
            this.currencyValues = currencyField2.getType().getValueSource(currencyField2, parser);
            this.amountValues = amountField.getType().getValueSource(amountField, parser);
        }

        @Override
        public FunctionValues getValues(Map context, AtomicReaderContext reader) throws IOException {
            final FunctionValues amounts = this.amountValues.getValues(context, reader);
            final FunctionValues currencies = this.currencyValues.getValues(context, reader);
            return new FunctionValues(){
                private final int MAX_CURRENCIES_TO_CACHE = 256;
                private final int[] fractionDigitCache = new int[256];
                private final String[] currencyOrdToCurrencyCache = new String[256];
                private final double[] exchangeRateCache = new double[256];
                private int targetFractionDigits = -1;
                private int targetCurrencyOrd = -1;
                private boolean initializedCache;

                private String getDocCurrencyCode(int doc, int currencyOrd) {
                    if (currencyOrd < 256) {
                        String currency = this.currencyOrdToCurrencyCache[currencyOrd];
                        if (currency == null) {
                            this.currencyOrdToCurrencyCache[currencyOrd] = currency = currencies.strVal(doc);
                        }
                        if (currency == null) {
                            currency = CurrencyField.this.defaultCurrency;
                        }
                        if (this.targetCurrencyOrd == -1 && currency.equals(CurrencyValueSource.this.targetCurrencyCode)) {
                            this.targetCurrencyOrd = currencyOrd;
                        }
                        return currency;
                    }
                    return currencies.strVal(doc);
                }

                @Override
                public long longVal(int doc) {
                    int sourceFractionDigits;
                    double exchangeRate;
                    if (!this.initializedCache) {
                        for (int i = 0; i < this.fractionDigitCache.length; ++i) {
                            this.fractionDigitCache[i] = -1;
                        }
                        this.initializedCache = true;
                    }
                    long amount = amounts.longVal(doc);
                    int currencyOrd = currencies.ordVal(doc);
                    if (currencyOrd == this.targetCurrencyOrd) {
                        return amount;
                    }
                    if (this.targetFractionDigits == -1) {
                        this.targetFractionDigits = Currency.getInstance(CurrencyValueSource.this.targetCurrencyCode).getDefaultFractionDigits();
                    }
                    if (currencyOrd < 256) {
                        String sourceCurrencyCode;
                        exchangeRate = this.exchangeRateCache[currencyOrd];
                        if (exchangeRate <= 0.0) {
                            sourceCurrencyCode = this.getDocCurrencyCode(doc, currencyOrd);
                            exchangeRate = this.exchangeRateCache[currencyOrd] = CurrencyField.this.provider.getExchangeRate(sourceCurrencyCode, CurrencyValueSource.this.targetCurrencyCode);
                        }
                        if ((sourceFractionDigits = this.fractionDigitCache[currencyOrd]) == -1) {
                            sourceCurrencyCode = this.getDocCurrencyCode(doc, currencyOrd);
                            sourceFractionDigits = this.fractionDigitCache[currencyOrd] = Currency.getInstance(sourceCurrencyCode).getDefaultFractionDigits();
                        }
                    } else {
                        String sourceCurrencyCode = this.getDocCurrencyCode(doc, currencyOrd);
                        exchangeRate = CurrencyField.this.provider.getExchangeRate(sourceCurrencyCode, CurrencyValueSource.this.targetCurrencyCode);
                        sourceFractionDigits = Currency.getInstance(sourceCurrencyCode).getDefaultFractionDigits();
                    }
                    return CurrencyValue.convertAmount(exchangeRate, sourceFractionDigits, amount, this.targetFractionDigits);
                }

                @Override
                public int intVal(int doc) {
                    return (int)this.longVal(doc);
                }

                @Override
                public double doubleVal(int doc) {
                    return this.longVal(doc);
                }

                @Override
                public float floatVal(int doc) {
                    return this.longVal(doc);
                }

                @Override
                public String strVal(int doc) {
                    return Long.toString(this.longVal(doc));
                }

                @Override
                public String toString(int doc) {
                    return CurrencyValueSource.this.name() + '(' + amounts.toString(doc) + ',' + currencies.toString(doc) + ')';
                }
            };
        }

        public String name() {
            return "currency";
        }

        @Override
        public String description() {
            return this.name() + "(" + this.sf.getName() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrencyValueSource that = (CurrencyValueSource)o;
            return !((this.amountValues == null ? that.amountValues != null : !this.amountValues.equals(that.amountValues)) || (this.currencyValues == null ? that.currencyValues != null : !this.currencyValues.equals(that.currencyValues)) || (this.targetCurrencyCode == null ? that.targetCurrencyCode != null : !this.targetCurrencyCode.equals(that.targetCurrencyCode)));
        }

        @Override
        public int hashCode() {
            int result = this.targetCurrencyCode != null ? this.targetCurrencyCode.hashCode() : 0;
            result = 31 * result + (this.currencyValues != null ? this.currencyValues.hashCode() : 0);
            result = 31 * result + (this.amountValues != null ? this.amountValues.hashCode() : 0);
            return result;
        }
    }
}

