/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;
import org.apache.solr.util.NumberUtils;

class SortableFloatFieldSource
extends FieldCacheSource {
    protected float defVal;
    private static int hcode = SortableFloatFieldSource.class.hashCode();

    public SortableFloatFieldSource(String field) {
        this(field, 0.0f);
    }

    public SortableFloatFieldSource(String field, float defVal) {
        super(field);
        this.defVal = defVal;
    }

    @Override
    public String description() {
        return "sfloat(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final float def = this.defVal;
        return new DocTermsIndexDocValues(this, readerContext, this.field){
            private final BytesRef spare;
            {
                super(x0, x1, x2);
                this.spare = new BytesRef();
            }

            @Override
            protected String toTerm(String readableValue) {
                return NumberUtils.float2sortableStr(readableValue);
            }

            @Override
            public float floatVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord == 0 ? def : NumberUtils.SortableStr2float(this.termsIndex.lookup(ord, this.spare));
            }

            @Override
            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public String toString(int doc) {
                return SortableFloatFieldSource.this.description() + '=' + this.floatVal(doc);
            }

            @Override
            public Object objectVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord == 0 ? null : Float.valueOf(NumberUtils.SortableStr2float(this.termsIndex.lookup(ord, this.spare)));
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueFloat mval = new MutableValueFloat();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        int ord = termsIndex.getOrd(doc);
                        if (ord == 0) {
                            this.mval.value = def;
                            this.mval.exists = false;
                        } else {
                            this.mval.value = NumberUtils.SortableStr2float(termsIndex.lookup(ord, spare));
                            this.mval.exists = true;
                        }
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SortableFloatFieldSource && super.equals(o) && this.defVal == ((SortableFloatFieldSource)o).defVal;
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode() + Float.floatToIntBits(this.defVal);
    }
}

