/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.FunctionRangeQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.function.ValueSourceRangeFilter;

public class FunctionRangeQParserPlugin
extends QParserPlugin {
    public static String NAME = "frange";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){
            ValueSource vs;
            String funcStr;

            @Override
            public Query parse() throws ParseException {
                this.funcStr = this.localParams.get("v", null);
                Query funcQ = this.subQuery(this.funcStr, FunctionQParserPlugin.NAME).getQuery();
                this.vs = funcQ instanceof FunctionQuery ? ((FunctionQuery)funcQ).getValueSource() : new QueryValueSource(funcQ, 0.0f);
                String l = this.localParams.get("l");
                String u = this.localParams.get("u");
                boolean includeLower = this.localParams.getBool("incl", true);
                boolean includeUpper = this.localParams.getBool("incu", true);
                ValueSourceRangeFilter rf = new ValueSourceRangeFilter(this.vs, l, u, includeLower, includeUpper);
                FunctionRangeQuery frq = new FunctionRangeQuery(rf);
                return frq;
            }
        };
    }
}

