/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;

public class QueryParsing {
    public static final String OP = "q.op";
    public static final String V = "v";
    public static final String F = "f";
    public static final String TYPE = "type";
    public static final String DEFTYPE = "defType";
    public static final String LOCALPARAM_START = "{!";
    public static final char LOCALPARAM_END = '}';
    public static final String DOCID = "_docid_";
    public static final String SCORE = "score";
    public static final String VAL_EXPLICIT = "__VAL_EXPLICIT__";

    public static QueryParser.Operator getQueryParserDefaultOperator(IndexSchema sch, String override) {
        String val = override;
        if (null == val) {
            val = sch.getQueryParserDefaultOperator();
        }
        return "AND".equals(val) ? QueryParser.Operator.AND : QueryParser.Operator.OR;
    }

    public static String getDefaultField(IndexSchema s, String df) {
        return df != null ? df : s.getDefaultSearchFieldName();
    }

    public static int parseLocalParams(String txt, int start, Map<String, String> target, SolrParams params) throws ParseException {
        return QueryParsing.parseLocalParams(txt, start, target, params, LOCALPARAM_START, '}');
    }

    public static int parseLocalParams(String txt, int start, Map<String, String> target, SolrParams params, String startString, char endChar) throws ParseException {
        int off = start;
        if (!txt.startsWith(startString, off)) {
            return start;
        }
        StrParser p = new StrParser(txt, start, txt.length());
        p.pos += startString.length();
        char ch;
        while ((ch = p.peek()) != endChar) {
            String id = p.getId();
            if (id.length() == 0) {
                throw new ParseException("Expected ending character '" + endChar + "' parsing local params '" + txt + '\"');
            }
            String val = null;
            ch = p.peek();
            if (ch != '=') {
                val = id;
                id = TYPE;
            } else {
                ++p.pos;
                ch = p.peek();
                boolean deref = false;
                if (ch == '$') {
                    ++p.pos;
                    ch = p.peek();
                    deref = true;
                }
                if (ch == '\"' || ch == '\'') {
                    val = p.getQuotedString();
                } else {
                    int valStart = p.pos;
                    while (true) {
                        if (p.pos >= p.end) {
                            throw new ParseException("Missing end to unquoted value starting at " + valStart + " str='" + txt + "'");
                        }
                        char c = p.val.charAt(p.pos);
                        if (c == endChar || Character.isWhitespace(c)) {
                            val = p.val.substring(valStart, p.pos);
                            break;
                        }
                        ++p.pos;
                    }
                }
                if (deref && params != null) {
                    val = params.get(val);
                }
            }
            if (target == null) continue;
            target.put(id, val);
        }
        return p.pos + 1;
    }

    public static String encodeLocalParamVal(String val) {
        int i;
        int len = val.length();
        if (len > 0 && val.charAt(0) != '$') {
            char ch;
            for (i = 0; i < len && !Character.isWhitespace(ch = val.charAt(i)) && ch != '}'; ++i) {
            }
        }
        if (i >= len) {
            return val;
        }
        StringBuilder sb = new StringBuilder(val.length() + 4);
        sb.append('\'');
        for (i = 0; i < len; ++i) {
            char ch = val.charAt(i);
            if (ch == '\'') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static SolrParams getLocalParams(String txt, SolrParams params) throws ParseException {
        if (txt == null || !txt.startsWith(LOCALPARAM_START)) {
            return null;
        }
        HashMap<String, String> localParams = new HashMap<String, String>();
        int start = QueryParsing.parseLocalParams(txt, 0, localParams, params);
        String val = (String)localParams.get(V);
        if (val == null) {
            val = txt.substring(start);
            localParams.put(V, val);
        }
        return new MapSolrParams(localParams);
    }

    public static Sort parseSort(String sortSpec, SolrQueryRequest req) {
        if (sortSpec == null || sortSpec.length() == 0) {
            return null;
        }
        ArrayList<SortField> lst = new ArrayList<SortField>(4);
        try {
            StrParser sp = new StrParser(sortSpec);
            while (sp.pos < sp.end) {
                Boolean top;
                sp.eatws();
                int start = sp.pos;
                String field = sp.getId(null);
                Exception qParserException = null;
                if (field == null || !Character.isWhitespace(sp.peekChar())) {
                    field = null;
                    String funcStr = sp.val.substring(start);
                    QParser parser = QParser.getParser(funcStr, FunctionQParserPlugin.NAME, req);
                    Query q = null;
                    try {
                        if (parser instanceof FunctionQParser) {
                            int leftOver;
                            FunctionQParser fparser = (FunctionQParser)parser;
                            fparser.setParseMultipleSources(false);
                            fparser.setParseToEnd(false);
                            q = fparser.getQuery();
                            if (fparser.localParams != null) {
                                if (fparser.valFollowedParams) {
                                    leftOver = fparser.sp.end - fparser.sp.pos;
                                    sp.pos = sp.end - leftOver;
                                } else {
                                    sp.pos = start + fparser.localParamsEnd;
                                }
                            } else {
                                leftOver = fparser.sp.end - fparser.sp.pos;
                                sp.pos = sp.end - leftOver;
                            }
                        } else {
                            q = parser.getQuery();
                            assert (parser.getLocalParams() != null);
                            sp.pos = start + parser.localParamsEnd;
                        }
                        Boolean top2 = sp.getSortDirection();
                        if (null != top2) {
                            if (q instanceof FunctionQuery) {
                                lst.add(((FunctionQuery)q).getValueSource().getSortField(top2));
                                continue;
                            }
                            lst.add(new QueryValueSource(q, 0.0f).getSortField(top2));
                            continue;
                        }
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (Exception e) {
                        qParserException = e;
                    }
                }
                if (field == null) {
                    sp.pos = start;
                    field = sp.getSimpleString();
                }
                if (null == (top = sp.getSortDirection())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't determine a Sort Order (asc or desc) in sort spec " + sp);
                }
                if (SCORE.equals(field)) {
                    if (top.booleanValue()) {
                        lst.add(SortField.FIELD_SCORE);
                        continue;
                    }
                    lst.add(new SortField(null, SortField.Type.SCORE, true));
                    continue;
                }
                if (DOCID.equals(field)) {
                    lst.add(new SortField(null, SortField.Type.DOC, (boolean)top));
                    continue;
                }
                SchemaField sf = req.getSchema().getFieldOrNull(field);
                if (null == sf) {
                    if (null != qParserException) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sort param could not be parsed as a query, and is not a field that exists in the index: " + field, qParserException);
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sort param field can't be found: " + field);
                }
                lst.add(sf.getSortField(top));
            }
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error in sort: " + sortSpec, e);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error in sort: " + sortSpec, e);
        }
        if (lst.size() == 1 && lst.get(0) == SortField.FIELD_SCORE) {
            return null;
        }
        return new Sort(lst.toArray(new SortField[lst.size()]));
    }

    static FieldType writeFieldName(String name, IndexSchema schema, Appendable out, int flags) throws IOException {
        FieldType ft = null;
        ft = schema.getFieldTypeNoEx(name);
        out.append(name);
        if (ft == null) {
            out.append("(UNKNOWN FIELD " + name + ')');
        }
        out.append(':');
        return ft;
    }

    static void writeFieldVal(String val, FieldType ft, Appendable out, int flags) throws IOException {
        if (ft != null) {
            try {
                out.append(ft.indexedToReadable(val));
            }
            catch (Exception e) {
                out.append("EXCEPTION(val=");
                out.append(val);
                out.append(")");
            }
        } else {
            out.append(val);
        }
    }

    static void writeFieldVal(BytesRef val, FieldType ft, Appendable out, int flags) throws IOException {
        if (ft != null) {
            try {
                CharsRef readable = new CharsRef();
                ft.indexedToReadable(val, readable);
                out.append(readable);
            }
            catch (Exception e) {
                out.append("EXCEPTION(val=");
                out.append(val.utf8ToString());
                out.append(")");
            }
        } else {
            out.append(val.utf8ToString());
        }
    }

    public static void toString(Query query, IndexSchema schema, Appendable out, int flags) throws IOException {
        boolean writeBoost = true;
        if (query instanceof TermQuery) {
            TermQuery q = (TermQuery)query;
            Term t = q.getTerm();
            FieldType ft = QueryParsing.writeFieldName(t.field(), schema, out, flags);
            QueryParsing.writeFieldVal(t.bytes(), ft, out, flags);
        } else if (query instanceof TermRangeQuery) {
            TermRangeQuery q = (TermRangeQuery)query;
            String fname = q.getField();
            FieldType ft = QueryParsing.writeFieldName(fname, schema, out, flags);
            out.append(q.includesLower() ? (char)'[' : '{');
            BytesRef lt = q.getLowerTerm();
            BytesRef ut = q.getUpperTerm();
            if (lt == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(lt, ft, out, flags);
            }
            out.append(" TO ");
            if (ut == null) {
                out.append('*');
            } else {
                QueryParsing.writeFieldVal(ut, ft, out, flags);
            }
            out.append(q.includesUpper() ? (char)']' : '}');
        } else if (query instanceof NumericRangeQuery) {
            NumericRangeQuery q = (NumericRangeQuery)query;
            String fname = q.getField();
            FieldType ft = QueryParsing.writeFieldName(fname, schema, out, flags);
            out.append(q.includesMin() ? (char)'[' : '{');
            Object lt = q.getMin();
            Object ut = q.getMax();
            if (lt == null) {
                out.append('*');
            } else {
                out.append(lt.toString());
            }
            out.append(" TO ");
            if (ut == null) {
                out.append('*');
            } else {
                out.append(ut.toString());
            }
            out.append(q.includesMax() ? (char)']' : '}');
        } else if (query instanceof BooleanQuery) {
            BooleanQuery q = (BooleanQuery)query;
            boolean needParens = false;
            if ((double)q.getBoost() != 1.0 || q.getMinimumNumberShouldMatch() != 0 || q.isCoordDisabled()) {
                needParens = true;
            }
            if (needParens) {
                out.append('(');
            }
            boolean first = true;
            for (BooleanClause c : q.clauses()) {
                if (!first) {
                    out.append(' ');
                } else {
                    first = false;
                }
                if (c.isProhibited()) {
                    out.append('-');
                } else if (c.isRequired()) {
                    out.append('+');
                }
                Query subQuery = c.getQuery();
                boolean wrapQuery = false;
                if (subQuery instanceof BooleanQuery) {
                    wrapQuery = true;
                }
                if (wrapQuery) {
                    out.append('(');
                }
                QueryParsing.toString(subQuery, schema, out, flags);
                if (!wrapQuery) continue;
                out.append(')');
            }
            if (needParens) {
                out.append(')');
            }
            if (q.getMinimumNumberShouldMatch() > 0) {
                out.append('~');
                out.append(Integer.toString(q.getMinimumNumberShouldMatch()));
            }
            if (q.isCoordDisabled()) {
                out.append("/no_coord");
            }
        } else if (query instanceof PrefixQuery) {
            PrefixQuery q = (PrefixQuery)query;
            Term prefix = q.getPrefix();
            FieldType ft = QueryParsing.writeFieldName(prefix.field(), schema, out, flags);
            out.append(prefix.text());
            out.append('*');
        } else if (query instanceof WildcardQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else if (query instanceof FuzzyQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else if (query instanceof ConstantScoreQuery) {
            out.append(query.toString());
            writeBoost = false;
        } else {
            out.append(query.getClass().getSimpleName() + '(' + query.toString() + ')');
            writeBoost = false;
        }
        if (writeBoost && query.getBoost() != 1.0f) {
            out.append("^");
            out.append(Float.toString(query.getBoost()));
        }
    }

    public static String toString(Query query, IndexSchema schema) {
        try {
            StringBuilder sb = new StringBuilder();
            QueryParsing.toString(query, schema, sb, 0);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> toString(List<Query> queries, IndexSchema schema) {
        ArrayList<String> out = new ArrayList<String>(queries.size());
        for (Query q : queries) {
            out.add(QueryParsing.toString(q, schema));
        }
        return out;
    }

    public static class StrParser {
        String val;
        int pos;
        int end;

        public StrParser(String val) {
            this(val, 0, val.length());
        }

        public StrParser(String val, int start, int end) {
            this.val = val;
            this.pos = start;
            this.end = end;
        }

        void eatws() {
            while (this.pos < this.end && Character.isWhitespace(this.val.charAt(this.pos))) {
                ++this.pos;
            }
        }

        char ch() {
            return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
        }

        void skip(int nChars) {
            this.pos = Math.max(this.pos + nChars, this.end);
        }

        boolean opt(String s) {
            this.eatws();
            int slen = s.length();
            if (this.val.regionMatches(this.pos, s, 0, slen)) {
                this.pos += slen;
                return true;
            }
            return false;
        }

        boolean opt(char ch) {
            this.eatws();
            if (this.pos < this.end && this.val.charAt(this.pos) == ch) {
                ++this.pos;
                return true;
            }
            return false;
        }

        void expect(String s) throws ParseException {
            this.eatws();
            int slen = s.length();
            if (this.val.regionMatches(this.pos, s, 0, slen)) {
                this.pos += slen;
            } else {
                throw new ParseException("Expected '" + s + "' at position " + this.pos + " in '" + this.val + "'");
            }
        }

        float getFloat() throws ParseException {
            char ch;
            int i;
            this.eatws();
            char[] arr = new char[this.end - this.pos];
            for (i = 0; i < arr.length && ((ch = this.val.charAt(this.pos)) >= '0' && ch <= '9' || ch == '+' || ch == '-' || ch == '.' || ch == 'e' || ch == 'E'); ++i) {
                ++this.pos;
                arr[i] = ch;
            }
            return Float.parseFloat(new String(arr, 0, i));
        }

        Number getNumber() throws ParseException {
            this.eatws();
            int start = this.pos;
            boolean flt = false;
            while (this.pos < this.end) {
                char ch = this.val.charAt(this.pos);
                if (ch >= '0' && ch <= '9' || ch == '+' || ch == '-') {
                    ++this.pos;
                    continue;
                }
                if (ch != '.' && ch != 'e' && ch != 'E') break;
                flt = true;
                ++this.pos;
            }
            String v = this.val.substring(start, this.pos);
            if (flt) {
                return Double.parseDouble(v);
            }
            return Long.parseLong(v);
        }

        double getDouble() throws ParseException {
            char ch;
            int i;
            this.eatws();
            char[] arr = new char[this.end - this.pos];
            for (i = 0; i < arr.length && ((ch = this.val.charAt(this.pos)) >= '0' && ch <= '9' || ch == '+' || ch == '-' || ch == '.' || ch == 'e' || ch == 'E'); ++i) {
                ++this.pos;
                arr[i] = ch;
            }
            return Double.parseDouble(new String(arr, 0, i));
        }

        int getInt() throws ParseException {
            char ch;
            int i;
            this.eatws();
            char[] arr = new char[this.end - this.pos];
            for (i = 0; i < arr.length && ((ch = this.val.charAt(this.pos)) >= '0' && ch <= '9' || ch == '+' || ch == '-'); ++i) {
                ++this.pos;
                arr[i] = ch;
            }
            return Integer.parseInt(new String(arr, 0, i));
        }

        String getId() throws ParseException {
            return this.getId("Expected identifier");
        }

        String getId(String errMessage) throws ParseException {
            char ch;
            this.eatws();
            int id_start = this.pos;
            if (this.pos < this.end && (ch = this.val.charAt(this.pos)) != '$' && Character.isJavaIdentifierStart(ch)) {
                ++this.pos;
                while (this.pos < this.end && (Character.isJavaIdentifierPart(ch = this.val.charAt(this.pos)) || ch == '.')) {
                    ++this.pos;
                }
                return this.val.substring(id_start, this.pos);
            }
            if (errMessage != null) {
                throw new ParseException(errMessage + " at pos " + this.pos + " str='" + this.val + "'");
            }
            return null;
        }

        public String getGlobbedId(String errMessage) throws ParseException {
            char ch;
            this.eatws();
            int id_start = this.pos;
            if (this.pos < this.end && (ch = this.val.charAt(this.pos)) != '$' && (Character.isJavaIdentifierStart(ch) || ch == '?' || ch == '*')) {
                ++this.pos;
                while (this.pos < this.end && (Character.isJavaIdentifierPart(ch = this.val.charAt(this.pos)) || ch == '?' || ch == '*' || ch == '.')) {
                    ++this.pos;
                }
                return this.val.substring(id_start, this.pos);
            }
            if (errMessage != null) {
                throw new ParseException(errMessage + " at pos " + this.pos + " str='" + this.val + "'");
            }
            return null;
        }

        String getSimpleString() {
            char ch;
            this.eatws();
            int startPos = this.pos;
            while (this.pos < this.end && !Character.isWhitespace(ch = this.val.charAt(this.pos))) {
                ++this.pos;
            }
            return this.val.substring(startPos, this.pos);
        }

        Boolean getSortDirection() throws ParseException {
            int startPos = this.pos;
            String order = this.getId(null);
            Boolean top = null;
            if (null != order) {
                if ("desc".equals(order) || "top".equals(order)) {
                    top = true;
                } else if ("asc".equals(order) || "bottom".equals(order)) {
                    top = false;
                }
                this.eatws();
                char c = this.ch();
                if ('\u0000' != c) {
                    if (',' == c) {
                        ++this.pos;
                    } else {
                        top = null;
                    }
                }
            }
            if (null == top) {
                this.pos = startPos;
            }
            return top;
        }

        String getQuotedString() throws ParseException {
            this.eatws();
            char delim = this.peekChar();
            if (delim != '\"' && delim != '\'') {
                return null;
            }
            int val_start = ++this.pos;
            StringBuilder sb = new StringBuilder();
            while (true) {
                if (this.pos >= this.end) {
                    throw new ParseException("Missing end quote for string at pos " + (val_start - 1) + " str='" + this.val + "'");
                }
                char ch = this.val.charAt(this.pos);
                if (ch == '\\') {
                    ++this.pos;
                    if (this.pos >= this.end) break;
                    ch = this.val.charAt(this.pos);
                    switch (ch) {
                        case 110: {
                            ch = '\n';
                            break;
                        }
                        case 116: {
                            ch = '\t';
                            break;
                        }
                        case 114: {
                            ch = '\r';
                            break;
                        }
                        case 98: {
                            ch = '\b';
                            break;
                        }
                        case 102: {
                            ch = '\f';
                            break;
                        }
                        case 117: {
                            if (this.pos + 4 >= this.end) {
                                throw new ParseException("bad unicode escape \\uxxxx at pos" + (val_start - 1) + " str='" + this.val + "'");
                            }
                            ch = (char)Integer.parseInt(this.val.substring(this.pos + 1, this.pos + 5), 16);
                            this.pos += 4;
                        }
                    }
                } else if (ch == delim) {
                    ++this.pos;
                    break;
                }
                sb.append(ch);
                ++this.pos;
            }
            return sb.toString();
        }

        char peek() {
            this.eatws();
            return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
        }

        char peekChar() {
            return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
        }

        public String toString() {
            return "'" + this.val + "'" + ", pos=" + this.pos;
        }
    }
}

