/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.BasicAutomata;
import org.apache.lucene.util.automaton.BasicOperations;
import org.apache.lucene.util.automaton.SpecialOperations;
import org.apache.solr.analysis.ReversedWildcardFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;

public class SolrQueryParser
extends QueryParser {
    protected final IndexSchema schema;
    protected final QParser parser;
    protected final String defaultField;
    private Map<FieldType, ReversedWildcardFilterFactory> leadingWildcards;

    public SolrQueryParser(QParser parser, String defaultField) {
        this(parser, defaultField, parser.getReq().getSchema().getQueryAnalyzer());
    }

    public SolrQueryParser(QParser parser, String defaultField, Analyzer analyzer) {
        super(parser.getReq().getCore().getSolrConfig().luceneMatchVersion, defaultField, analyzer);
        this.schema = parser.getReq().getSchema();
        this.parser = parser;
        this.defaultField = defaultField;
        this.setEnablePositionIncrements(true);
        this.setLowercaseExpandedTerms(false);
        this.setAllowLeadingWildcard(true);
    }

    protected ReversedWildcardFilterFactory getReversedWildcardFilterFactory(FieldType fieldType) {
        ReversedWildcardFilterFactory fac;
        if (this.leadingWildcards == null) {
            this.leadingWildcards = new HashMap<FieldType, ReversedWildcardFilterFactory>();
        }
        if ((fac = this.leadingWildcards.get(fieldType)) == null && this.leadingWildcards.containsKey(fac)) {
            return fac;
        }
        Analyzer a = fieldType.getAnalyzer();
        if (a instanceof TokenizerChain) {
            TokenFilterFactory[] factories;
            TokenizerChain tc = (TokenizerChain)a;
            for (TokenFilterFactory factory : factories = tc.getTokenFilterFactories()) {
                if (!(factory instanceof ReversedWildcardFilterFactory)) continue;
                fac = (ReversedWildcardFilterFactory)factory;
                break;
            }
        }
        this.leadingWildcards.put(fieldType, fac);
        return fac;
    }

    private void checkNullField(String field) throws SolrException {
        if (field == null && this.defaultField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no field name specified in query and no default specified via 'df' param");
        }
    }

    protected String analyzeIfMultitermTermText(String field, String part, FieldType fieldType) {
        if (part == null) {
            return part;
        }
        SchemaField sf = this.schema.getFieldOrNull(field);
        if (sf == null || !(fieldType instanceof TextField)) {
            return part;
        }
        String out = TextField.analyzeMultiTerm(field, part, ((TextField)fieldType).getMultiTermAnalyzer()).utf8ToString();
        return out;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        MagicFieldName magic;
        this.checkNullField(field);
        if (field.charAt(0) == '_' && this.parser != null && null != (magic = MagicFieldName.get(field))) {
            QParser nested = this.parser.subQuery(queryText, magic.subParser);
            return nested.getQuery();
        }
        SchemaField sf = this.schema.getFieldOrNull(field);
        if (sf != null) {
            FieldType ft = sf.getType();
            if (ft.isTokenized()) {
                return super.getFieldQuery(field, queryText, quoted || ft instanceof TextField && ((TextField)ft).getAutoGeneratePhraseQueries());
            }
            return sf.getType().getFieldQuery(this.parser, sf, queryText);
        }
        return super.getFieldQuery(field, queryText, quoted);
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        this.checkNullField(field);
        SchemaField sf = this.schema.getField(field);
        return sf.getType().getRangeQuery(this.parser, sf, part1, part2, startInclusive, endInclusive);
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        this.checkNullField(field);
        termStr = this.analyzeIfMultitermTermText(field, termStr, this.schema.getFieldType(field));
        return this.newPrefixQuery(new Term(field, termStr));
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        this.checkNullField(field);
        if ("*".equals(field) && "*".equals(termStr)) {
            return this.newMatchAllDocsQuery();
        }
        FieldType fieldType = this.schema.getFieldType(field);
        termStr = this.analyzeIfMultitermTermText(field, termStr, fieldType);
        ReversedWildcardFilterFactory factory = this.getReversedWildcardFilterFactory(fieldType);
        if (factory != null) {
            Term term = new Term(field, termStr);
            Automaton automaton = WildcardQuery.toAutomaton(term);
            if (factory.shouldReverse(termStr)) {
                automaton = BasicOperations.concatenate(automaton, BasicAutomata.makeChar(factory.getMarkerChar()));
                SpecialOperations.reverse(automaton);
            } else {
                Automaton falsePositives = BasicOperations.concatenate(BasicAutomata.makeChar(factory.getMarkerChar()), BasicAutomata.makeAnyString());
                automaton = BasicOperations.minus(automaton, falsePositives);
            }
            return new AutomatonQuery(term, automaton){

                @Override
                public String toString(String field) {
                    StringBuilder buffer = new StringBuilder();
                    if (!this.getField().equals(field)) {
                        buffer.append(this.getField());
                        buffer.append(":");
                    }
                    buffer.append(this.term.text());
                    buffer.append(ToStringUtils.boost(this.getBoost()));
                    return buffer.toString();
                }
            };
        }
        return this.newWildcardQuery(new Term(field, termStr));
    }

    @Override
    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        termStr = this.analyzeIfMultitermTermText(field, termStr, this.schema.getFieldType(field));
        return this.newRegexpQuery(new Term(field, termStr));
    }

    public static enum MagicFieldName {
        VAL("_val_", "func"),
        QUERY("_query_", null);

        public final String field;
        public final String subParser;
        private static final Map<String, MagicFieldName> lookup;

        private MagicFieldName(String field, String subParser) {
            this.field = field;
            this.subParser = subParser;
        }

        public String toString() {
            return this.field;
        }

        public static MagicFieldName get(String field) {
            return lookup.get(field);
        }

        static {
            lookup = new HashMap<String, MagicFieldName>();
            for (MagicFieldName s : EnumSet.allOf(MagicFieldName.class)) {
                lookup.put(s.toString(), s);
            }
        }
    }
}

