/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrRequestInfo;

class TestValueSource
extends ValueSource {
    ValueSource source;

    public TestValueSource(ValueSource source) {
        this.source = source;
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        if (context.get(this) == null) {
            SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "testfunc: unweighted value source detected.  delegate=" + this.source + " request=" + (requestInfo == null ? "null" : requestInfo.getReq()));
        }
        return this.source.getValues(context, readerContext);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof TestValueSource && this.source.equals(((TestValueSource)o).source);
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() + TestValueSource.class.hashCode();
    }

    @Override
    public String description() {
        return "testfunc(" + this.source.description() + ')';
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        context.put(this, this);
    }

    @Override
    public SortField getSortField(boolean reverse) throws IOException {
        return super.getSortField(reverse);
    }
}

