/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.suggest.FileDictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;
import org.apache.solr.spelling.suggest.LookupFactory;
import org.apache.solr.spelling.suggest.fst.FSTLookupFactory;
import org.apache.solr.spelling.suggest.jaspell.JaspellLookupFactory;
import org.apache.solr.spelling.suggest.tst.TSTLookupFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Suggester
extends SolrSpellChecker {
    private static final Logger LOG = LoggerFactory.getLogger(Suggester.class);
    public static final String LOCATION = "sourceLocation";
    public static final String LOOKUP_IMPL = "lookupImpl";
    public static final String THRESHOLD_TOKEN_FREQUENCY = "threshold";
    public static final String STORE_DIR = "storeDir";
    protected String sourceLocation;
    protected File storeDir;
    protected float threshold;
    protected Dictionary dictionary;
    protected IndexReader reader;
    protected Lookup lookup;
    protected String lookupImpl;
    protected SolrCore core;
    private LookupFactory factory;
    static SpellingResult EMPTY_RESULT = new SpellingResult();

    @Override
    public String init(NamedList config, SolrCore core) {
        LOG.info("init: " + config);
        String name = super.init(config, core);
        this.threshold = config.get(THRESHOLD_TOKEN_FREQUENCY) == null ? 0.0f : ((Float)config.get(THRESHOLD_TOKEN_FREQUENCY)).floatValue();
        this.sourceLocation = (String)config.get(LOCATION);
        this.lookupImpl = (String)config.get(LOOKUP_IMPL);
        if (this.lookupImpl == null || "org.apache.solr.spelling.suggest.jaspell.JaspellLookup".equals(this.lookupImpl)) {
            this.lookupImpl = JaspellLookupFactory.class.getName();
        } else if ("org.apache.solr.spelling.suggest.tst.TSTLookup".equals(this.lookupImpl)) {
            this.lookupImpl = TSTLookupFactory.class.getName();
        } else if ("org.apache.solr.spelling.suggest.fst.FSTLookup".equals(this.lookupImpl)) {
            this.lookupImpl = FSTLookupFactory.class.getName();
        }
        this.factory = core.getResourceLoader().newInstance(this.lookupImpl, LookupFactory.class, new String[0]);
        this.lookup = this.factory.create(config, core);
        String store = (String)config.get(STORE_DIR);
        if (store != null) {
            this.storeDir = new File(store);
            if (!this.storeDir.isAbsolute()) {
                this.storeDir = new File(core.getDataDir() + File.separator + this.storeDir);
            }
            if (!this.storeDir.exists()) {
                this.storeDir.mkdirs();
            } else {
                try {
                    this.lookup.load((InputStream)new FileInputStream(new File(this.storeDir, this.factory.storeFileName())));
                }
                catch (IOException e) {
                    LOG.warn("Loading stored lookup data failed", e);
                }
            }
        }
        return name;
    }

    @Override
    public void build(SolrCore core, SolrIndexSearcher searcher) {
        LOG.info("build()");
        if (this.sourceLocation == null) {
            this.reader = searcher.getIndexReader();
            this.dictionary = new HighFrequencyDictionary(this.reader, this.field, this.threshold);
        } else {
            try {
                this.dictionary = new FileDictionary((Reader)new InputStreamReader(core.getResourceLoader().openResource(this.sourceLocation), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("should not happen", e);
            }
        }
        try {
            this.lookup.build(this.dictionary);
            if (this.storeDir != null) {
                File target = new File(this.storeDir, this.factory.storeFileName());
                if (!this.lookup.store((OutputStream)new FileOutputStream(target))) {
                    if (this.sourceLocation == null) {
                        assert (this.reader != null && this.field != null);
                        LOG.error("Store Lookup build from index on field: " + this.field + " failed reader has: " + this.reader.maxDoc() + " docs");
                    } else {
                        LOG.error("Store Lookup build from sourceloaction: " + this.sourceLocation + " failed");
                    }
                } else {
                    LOG.info("Stored suggest data to: " + target.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while building or storing Suggester data", e);
        }
    }

    @Override
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        LOG.info("reload()");
        if (this.dictionary == null && this.storeDir != null) {
            if (this.lookup.load((InputStream)new FileInputStream(new File(this.storeDir, this.factory.storeFileName())))) {
                return;
            }
            LOG.debug("load failed, need to build Lookup again");
        }
        this.build(core, searcher);
    }

    @Override
    public SpellingResult getSuggestions(SpellingOptions options) throws IOException {
        LOG.debug("getSuggestions: " + options.tokens);
        if (this.lookup == null) {
            LOG.info("Lookup is null - invoke spellchecker.build first");
            return EMPTY_RESULT;
        }
        SpellingResult res = new SpellingResult();
        CharsRef scratch = new CharsRef();
        for (Token t : options.tokens) {
            scratch.chars = t.buffer();
            scratch.offset = 0;
            scratch.length = t.length();
            List suggestions = this.lookup.lookup((CharSequence)scratch, options.suggestMode == SuggestMode.SUGGEST_MORE_POPULAR, options.count);
            if (suggestions == null) continue;
            if (options.suggestMode != SuggestMode.SUGGEST_MORE_POPULAR) {
                Collections.sort(suggestions);
            }
            for (Lookup.LookupResult lr : suggestions) {
                res.add(t, ((Object)lr.key).toString(), (int)lr.value);
            }
        }
        return res;
    }
}

