/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.solr.cloud.RecoveryStrategy;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolrCoreState
extends SolrCoreState {
    public static Logger log = LoggerFactory.getLogger(DefaultSolrCoreState.class);
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final Object recoveryLock = new Object();
    private int refCnt = 1;
    private SolrIndexWriter indexWriter = null;
    private DirectoryFactory directoryFactory;
    private boolean recoveryRunning;
    private RecoveryStrategy recoveryStrat;
    private boolean closed = false;

    public DefaultSolrCoreState(DirectoryFactory directoryFactory) {
        this.directoryFactory = directoryFactory;
    }

    @Override
    public synchronized IndexWriter getIndexWriter(SolrCore core) throws IOException {
        if (this.indexWriter == null) {
            this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2", false, false);
        }
        return this.indexWriter;
    }

    @Override
    public synchronized void newIndexWriter(SolrCore core) throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
        this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decref(SolrCoreState.IndexWriterCloser closer) throws IOException {
        DefaultSolrCoreState defaultSolrCoreState = this;
        synchronized (defaultSolrCoreState) {
            --this.refCnt;
            if (this.refCnt == 0) {
                try {
                    if (closer != null) {
                        closer.closeWriter(this.indexWriter);
                    } else if (this.indexWriter != null) {
                        this.indexWriter.close();
                    }
                }
                catch (Throwable t) {
                    log.error("Error during shutdown of writer.", t);
                }
                try {
                    this.directoryFactory.close();
                }
                catch (Throwable t) {
                    log.error("Error during shutdown of directory factory.", t);
                }
                try {
                    this.cancelRecovery();
                }
                catch (Throwable t) {
                    log.error("Error cancelling recovery", t);
                }
                this.closed = true;
            }
        }
    }

    @Override
    public synchronized void incref() {
        if (this.refCnt == 0) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        ++this.refCnt;
    }

    @Override
    public synchronized void rollbackIndexWriter(SolrCore core) throws IOException {
        this.indexWriter.rollback();
        this.newIndexWriter(core);
    }

    protected SolrIndexWriter createMainIndexWriter(SolrCore core, String name, boolean removeAllExisting, boolean forceNewDirectory) throws IOException {
        return new SolrIndexWriter(name, core.getNewIndexDir(), core.getDirectoryFactory(), removeAllExisting, core.getSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec(), forceNewDirectory);
    }

    @Override
    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecovery(CoreContainer cc, String name) {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return;
        }
        this.cancelRecovery();
        Object object = this.recoveryLock;
        synchronized (object) {
            while (this.recoveryRunning) {
                try {
                    this.recoveryLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.closed) continue;
                return;
            }
            boolean recoveringAfterStartup = this.recoveryStrat == null;
            this.recoveryStrat = new RecoveryStrategy(cc, name);
            this.recoveryStrat.setRecoveringAfterStartup(recoveringAfterStartup);
            this.recoveryStrat.start();
            this.recoveryRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRecovery() {
        Object object = this.recoveryLock;
        synchronized (object) {
            if (this.recoveryStrat != null) {
                this.recoveryStrat.close();
                try {
                    this.recoveryStrat.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.recoveryRunning = false;
                this.recoveryLock.notifyAll();
            }
        }
    }
}

