/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class SimplePostTool {
    public static final String DEFAULT_POST_URL = "http://localhost:8983/solr/update";
    public static final String VERSION_OF_THIS_TOOL = "1.4";
    private static final String DEFAULT_COMMIT = "yes";
    private static final String DEFAULT_OPTIMIZE = "no";
    private static final String DEFAULT_OUT = "no";
    public static final String DEFAULT_DATA_TYPE = "application/xml";
    private static final String DATA_MODE_FILES = "files";
    private static final String DATA_MODE_ARGS = "args";
    private static final String DATA_MODE_STDIN = "stdin";
    private static final String DEFAULT_DATA_MODE = "files";
    private static final Set<String> DATA_MODES = new HashSet<String>();
    protected URL solrUrl;

    public static void main(String[] args) {
        SimplePostTool.info("version 1.4");
        if (0 < args.length && ("-help".equals(args[0]) || "--help".equals(args[0]) || "-h".equals(args[0]))) {
            System.out.println("This is a simple command line tool for POSTing raw data to a Solr\nport.  Data can be read from files specified as commandline args,\nas raw commandline arg strings, or via STDIN.\nExamples:\n  java -jar post.jar *.xml\n  java -Ddata=args  -jar post.jar '<delete><id>42</id></delete>'\n  java -Ddata=stdin -jar post.jar < hd.xml\n  java -Dtype=text/csv -jar post.jar *.csv\n  java -Dtype=application/json -jar post.jar *.json\n  java -Durl=http://localhost:8983/solr/update/extract?literal.id=a -Dtype=application/pdf -jar post.jar a.pdf\nOther options controlled by System Properties include the Solr\nURL to POST to, the Content-Type of the data, whether a commit\nor optimize should be executed, and whether the response should\nbe written to STDOUT. These are the defaults for all System Properties:\n  -Ddata=files\n  -Dtype=application/xml\n  -Durl=http://localhost:8983/solr/update\n  -Dcommit=yes\n  -Doptimize=no\n  -Dout=no\n");
            return;
        }
        PrintStream out = null;
        String type = System.getProperty("type", DEFAULT_DATA_TYPE);
        URL u = null;
        try {
            u = new URL(System.getProperty("url", DEFAULT_POST_URL));
        }
        catch (MalformedURLException e) {
            SimplePostTool.fatal("System Property 'url' is not a valid URL: " + u);
        }
        SimplePostTool t = new SimplePostTool(u);
        String mode = System.getProperty("data", "files");
        if (!DATA_MODES.contains(mode)) {
            SimplePostTool.fatal("System Property 'data' is not valid for this tool: " + mode);
        }
        if (DEFAULT_COMMIT.equals(System.getProperty("out", "no"))) {
            out = System.out;
        }
        try {
            if ("files".equals(mode)) {
                if (0 < args.length) {
                    SimplePostTool.info("POSTing files to " + u + "..");
                    t.postFiles(args, 0, out, type);
                } else {
                    SimplePostTool.info("No files specified. (Use -h for help)");
                }
            } else if (DATA_MODE_ARGS.equals(mode)) {
                if (0 < args.length) {
                    SimplePostTool.info("POSTing args to " + u + "..");
                    for (String a : args) {
                        t.postData(SimplePostTool.stringToStream(a), null, out, type);
                    }
                }
            } else if (DATA_MODE_STDIN.equals(mode)) {
                SimplePostTool.info("POSTing stdin to " + u + "..");
                t.postData(System.in, null, out, type);
            }
            if (DEFAULT_COMMIT.equals(System.getProperty("commit", DEFAULT_COMMIT))) {
                SimplePostTool.info("COMMITting Solr index changes..");
                t.commit();
            }
            if (DEFAULT_COMMIT.equals(System.getProperty("optimize", "no"))) {
                SimplePostTool.info("Performing an OPTIMIZE..");
                t.optimize();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            SimplePostTool.fatal("RuntimeException " + e);
        }
    }

    @Deprecated
    int postFiles(String[] args, int startIndexInArgs, OutputStream out) {
        String type = System.getProperty("type", DEFAULT_DATA_TYPE);
        return this.postFiles(args, startIndexInArgs, out, type);
    }

    int postFiles(String[] args, int startIndexInArgs, OutputStream out, String type) {
        int filesPosted = 0;
        for (int j = startIndexInArgs; j < args.length; ++j) {
            File srcFile = new File(args[j]);
            if (srcFile.canRead()) {
                SimplePostTool.info("POSTing file " + srcFile.getName());
                this.postFile(srcFile, out, type);
                ++filesPosted;
                continue;
            }
            SimplePostTool.warn("Cannot read input file: " + srcFile);
        }
        return filesPosted;
    }

    static void warn(String msg) {
        System.err.println("SimplePostTool: WARNING: " + msg);
    }

    static void info(String msg) {
        System.out.println("SimplePostTool: " + msg);
    }

    static void fatal(String msg) {
        System.err.println("SimplePostTool: FATAL: " + msg);
        System.exit(1);
    }

    public SimplePostTool(URL solrUrl) {
        this.solrUrl = solrUrl;
    }

    public void commit() {
        SimplePostTool.doGet(this.appendParam(this.solrUrl.toString(), "commit=true"));
    }

    public void optimize() {
        SimplePostTool.doGet(this.appendParam(this.solrUrl.toString(), "optimize=true"));
    }

    private String appendParam(String url, String param) {
        return url + (url.indexOf(63) > 0 ? "&" : "?") + param;
    }

    public void postFile(File file, OutputStream output) {
        String type = System.getProperty("type", DEFAULT_DATA_TYPE);
        this.postFile(file, output, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFile(File file, OutputStream output, String type) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.postData(is, (int)file.length(), output, type);
        }
        catch (IOException e) {
            SimplePostTool.fatal("Can't open/read file: " + file);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                SimplePostTool.fatal("IOException while closing file: " + e);
            }
        }
    }

    public static void doGet(String url) {
        try {
            SimplePostTool.doGet(new URL(url));
        }
        catch (MalformedURLException e) {
            SimplePostTool.fatal("The specified URL " + url + " is not a valid URL. Please check");
        }
    }

    public static void doGet(URL url) {
        try {
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            if (200 != urlc.getResponseCode()) {
                SimplePostTool.fatal("Solr returned an error #" + urlc.getResponseCode() + " " + urlc.getResponseMessage());
            }
        }
        catch (IOException e) {
            SimplePostTool.fatal("An error occured posting data to " + url + ". Please check that Solr is running.");
        }
    }

    @Deprecated
    public void postData(InputStream data, Integer length, OutputStream output) {
        String type = System.getProperty("type", DEFAULT_DATA_TYPE);
        this.postData(data, length, output, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postData(InputStream data, Integer length, OutputStream output, String type) {
        HttpURLConnection urlc = null;
        try {
            try {
                urlc = (HttpURLConnection)this.solrUrl.openConnection();
                try {
                    urlc.setRequestMethod("POST");
                }
                catch (ProtocolException e) {
                    SimplePostTool.fatal("Shouldn't happen: HttpURLConnection doesn't support POST??" + e);
                }
                urlc.setDoOutput(true);
                urlc.setDoInput(true);
                urlc.setUseCaches(false);
                urlc.setAllowUserInteraction(false);
                urlc.setRequestProperty("Content-type", type);
                if (null != length) {
                    urlc.setFixedLengthStreamingMode(length);
                }
            }
            catch (IOException e) {
                SimplePostTool.fatal("Connection error (is Solr running at " + this.solrUrl + " ?): " + e);
            }
            OutputStream out = null;
            try {
                out = urlc.getOutputStream();
                SimplePostTool.pipe(data, out);
            }
            catch (IOException e) {
                SimplePostTool.fatal("IOException while posting data: " + e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException x) {}
            }
            InputStream in = null;
            try {
                if (200 != urlc.getResponseCode()) {
                    SimplePostTool.fatal("Solr returned an error #" + urlc.getResponseCode() + " " + urlc.getResponseMessage());
                }
                in = urlc.getInputStream();
                SimplePostTool.pipe(in, output);
            }
            catch (IOException e) {
                SimplePostTool.fatal("IOException while reading response: " + e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException x) {}
            }
        }
        finally {
            if (urlc != null) {
                urlc.disconnect();
            }
        }
    }

    public static InputStream stringToStream(String s) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            SimplePostTool.fatal("Shouldn't happen: UTF-8 not supported?!?!?!");
        }
        return is;
    }

    private static void pipe(InputStream source, OutputStream dest) throws IOException {
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = source.read(buf)) >= 0) {
            if (null == dest) continue;
            dest.write(buf, 0, read);
        }
        if (null != dest) {
            dest.flush();
        }
    }

    static {
        DATA_MODES.add("files");
        DATA_MODES.add(DATA_MODE_ARGS);
        DATA_MODES.add(DATA_MODE_STDIN);
    }
}

