/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ClassFinder {
    private ClassFinder() {
    }

    public static List findClassesThatExtend(String[] paths, Class[] superClasses) throws IOException, ClassNotFoundException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    public static List findClassesThatExtend(Class[] superClasses) throws IOException, ClassNotFoundException {
        String javaClassPath = System.getProperty("java.class.path");
        String[] paths = javaClassPath.split(File.pathSeparator);
        return ClassFinder.findClassesThatExtend(paths, superClasses);
    }

    public static List findClassesThatExtend(Class superClass) throws IOException, ClassNotFoundException {
        String javaClassPath = System.getProperty("java.class.path");
        String[] paths = javaClassPath.split("" + File.pathSeparatorChar);
        Class[] superClasses = new Class[]{superClass};
        return ClassFinder.findClassesThatExtend(paths, superClasses);
    }

    public static Class[] getInstantiableSubclasses(Class superclass) throws IOException, ClassNotFoundException {
        ArrayList instantiableSubclasses = new ArrayList();
        List classes = ClassFinder.findClassesThatExtend(superclass);
        HashSet uniq = new HashSet(classes);
        classes.clear();
        classes.addAll(uniq);
        Collections.sort(classes);
        for (String className : classes) {
            try {
                Class<?> clazz = Class.forName(className);
                int modifiers = clazz.getModifiers();
                if (Modifier.isAbstract(modifiers)) continue;
                instantiableSubclasses.add(clazz);
            }
            catch (Throwable ignore) {}
        }
        return instantiableSubclasses.toArray(new Class[0]);
    }

    private static String[] addJarsInPath(String[] paths) {
        HashSet<String> fullList = new HashSet<String>();
        for (int i = 0; i < paths.length; ++i) {
            File dir;
            fullList.add(paths[i]);
            if (paths[i].endsWith(".jar") || !(dir = new File(paths[i])).exists() || !dir.isDirectory()) continue;
            String[] jars = dir.list(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int x = 0; x < jars.length; ++x) {
                fullList.add(jars[x]);
            }
        }
        return fullList.toArray(new String[0]);
    }

    public static List findClassesThatExtend(String[] strPathsOrJars, Class[] superClasses, boolean innerClasses) throws IOException, ClassNotFoundException {
        List listPaths = null;
        ArrayList listClasses = null;
        ArrayList<String> listSuperClasses = null;
        strPathsOrJars = ClassFinder.addJarsInPath(strPathsOrJars);
        listPaths = ClassFinder.getClasspathMatches(strPathsOrJars);
        listClasses = new ArrayList();
        listSuperClasses = new ArrayList<String>();
        for (int i = 0; i < superClasses.length; ++i) {
            listSuperClasses.add(superClasses[i].getName());
        }
        ClassFinder.findClassesInPaths(listPaths, listClasses);
        ArrayList subClassList = ClassFinder.findAllSubclasses(listSuperClasses, listClasses, innerClasses);
        return subClassList;
    }

    private static List getClasspathMatches(String[] strPathsOrJars) {
        ArrayList<String> listPaths = null;
        StringTokenizer stPaths = null;
        String strPath = null;
        listPaths = new ArrayList<String>();
        stPaths = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        if (strPathsOrJars != null) {
            strPathsOrJars = ClassFinder.fixDotDirs(strPathsOrJars);
            strPathsOrJars = ClassFinder.fixSlashes(strPathsOrJars);
            strPathsOrJars = ClassFinder.fixEndingSlashes(strPathsOrJars);
        }
        while (stPaths.hasMoreTokens()) {
            strPath = ClassFinder.fixDotDir(stPaths.nextToken());
            strPath = ClassFinder.fixSlashes(strPath);
            strPath = ClassFinder.fixEndingSlashes(strPath);
            if (strPathsOrJars == null) {
                listPaths.add(strPath);
                continue;
            }
            boolean found = false;
            for (int i = 0; i < strPathsOrJars.length; ++i) {
                if (!strPath.endsWith(strPathsOrJars[i])) continue;
                found = true;
                listPaths.add(strPath);
                break;
            }
            if (found) continue;
        }
        return listPaths;
    }

    private static String[] fixDotDirs(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ClassFinder.fixDotDir(paths[i]);
        }
        return paths;
    }

    private static String fixDotDir(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(".")) {
            return System.getProperty("user.dir");
        }
        return path.trim();
    }

    private static String[] fixEndingSlashes(String[] strings) {
        String[] strNew = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            strNew[i] = ClassFinder.fixEndingSlashes(strings[i]);
        }
        return strNew;
    }

    private static String fixEndingSlashes(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
            string = ClassFinder.fixEndingSlashes(string);
        }
        return string;
    }

    private static String[] fixSlashes(String[] strings) {
        String[] strNew = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            strNew[i] = ClassFinder.fixSlashes(strings[i]);
        }
        return strNew;
    }

    private static String fixSlashes(String str) {
        str = str.replace('\\', '/');
        str = ClassFinder.replaceString(str, "//", "_____");
        str = ClassFinder.replaceString(str, "_____", "/");
        return str;
    }

    private static String replaceString(String s, String strToFind, String strToReplace) {
        int index;
        StringBuffer buffer = null;
        if (s.indexOf(strToFind) == -1) {
            return s;
        }
        int currentPos = 0;
        buffer = new StringBuffer();
        while ((index = s.indexOf(strToFind, currentPos)) != -1) {
            buffer.append(s.substring(currentPos, index));
            buffer.append(strToReplace);
            currentPos = index + strToFind.length();
        }
        buffer.append(s.substring(currentPos));
        return buffer.toString();
    }

    private static ArrayList findAllSubclasses(List listSuperClasses, List listAllClasses, boolean innerClasses) {
        Iterator iterClasses = null;
        ArrayList listSubClasses = null;
        String strClassName2 = null;
        Class<?> tempClass = null;
        listSubClasses = new ArrayList();
        for (String strClassName2 : listSuperClasses) {
            if (strClassName2.indexOf("$") != -1 && !innerClasses) continue;
            try {
                tempClass = Class.forName(strClassName2, false, Thread.currentThread().getContextClassLoader());
                ClassFinder.findAllSubclassesOneClass(tempClass, listAllClasses, listSubClasses, innerClasses);
            }
            catch (Throwable ignored) {}
        }
        return listSubClasses;
    }

    private static void findAllSubclassesOneClass(Class theClass, List listAllClasses, List listSubClasses, boolean innerClasses) {
        Iterator iterClasses = null;
        String strClassName2 = null;
        Class<?> c = null;
        boolean bIsSubclass = false;
        for (String strClassName2 : listAllClasses) {
            if (strClassName2.indexOf("$") != -1 && !innerClasses) continue;
            try {
                c = Class.forName(strClassName2, false, Thread.currentThread().getContextClassLoader());
                bIsSubclass = !c.isInterface() && !Modifier.isAbstract(c.getModifiers()) ? theClass.isAssignableFrom(c) : false;
                if (!bIsSubclass) continue;
                listSubClasses.add(strClassName2);
            }
            catch (Throwable ignored) {}
        }
    }

    private static String fixClassName(String strClassName) {
        strClassName = strClassName.replace('\\', '.');
        strClassName = strClassName.replace('/', '.');
        strClassName = strClassName.substring(0, strClassName.length() - 6);
        return strClassName;
    }

    private static void findClassesInOnePath(String strPath, List listClasses) throws IOException {
        File file = null;
        ZipFile zipFile = null;
        Enumeration<? extends ZipEntry> entries = null;
        String strEntry = null;
        file = new File(strPath);
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(strPath, file, listClasses);
        } else if (file.exists()) {
            zipFile = new ZipFile(file);
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                strEntry = ((Object)entries.nextElement()).toString();
                if (!strEntry.endsWith(".class")) continue;
                listClasses.add(ClassFinder.fixClassName(strEntry));
            }
        }
    }

    private static void findClassesInPaths(List listPaths, List listClasses) throws IOException {
        Iterator iterPaths = listPaths.iterator();
        while (iterPaths.hasNext()) {
            ClassFinder.findClassesInOnePath((String)iterPaths.next(), listClasses);
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, List listClasses) throws IOException {
        File file = null;
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            file = new File(dir, list[i]);
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses);
                continue;
            }
            if (!file.exists() || file.length() == 0L || !list[i].endsWith(".class")) continue;
            listClasses.add(file.getPath().substring(strPathElement.length() + 1, file.getPath().lastIndexOf(".")).replace(File.separator.charAt(0), '.'));
        }
    }
}

