/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import org.getopt.luke.Luke;
import org.getopt.luke.ProgressNotification;

public class Progress
implements Observer {
    Object ui;
    Object bar;
    Object msg;
    boolean showing = false;
    Luke luke;

    public Progress(Luke luke) {
        try {
            this.ui = luke.parse("/xml/progress.xml", (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.luke = luke;
        this.bar = luke.find(this.ui, "bar");
        this.msg = luke.find(this.ui, "msg");
    }

    public void setMessage(String message) {
        this.luke.setString(this.msg, "text", message);
    }

    public void show() {
        this.luke.add(this.ui);
        this.luke.repaint();
        this.showing = true;
    }

    public void hide() {
        this.luke.remove(this.ui);
        this.showing = false;
    }

    public void cancel(Object dialog) {
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof ProgressNotification) {
            ProgressNotification pn = (ProgressNotification)arg;
            if (pn.message != null) {
                this.luke.setString(this.msg, "text", pn.message);
            }
            this.luke.setInteger(this.bar, "minimum", pn.minValue);
            this.luke.setInteger(this.bar, "maximum", pn.maxValue);
            this.luke.setInteger(this.bar, "value", pn.curValue);
        } else {
            this.luke.setString(this.msg, "text", arg.toString());
        }
        if (!this.showing) {
            this.show();
        }
        this.luke.doLayout(this.ui);
    }
}

