/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.decoders;

import org.apache.lucene.document.Field;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.getopt.luke.decoders.Decoder;

public class NumIntDecoder
implements Decoder {
    public String decodeTerm(String fieldName, Object value) {
        BytesRef ref = new BytesRef(value.toString());
        return Integer.toString(NumericUtils.prefixCodedToInt(ref));
    }

    public String decodeStored(String fieldName, Field value) {
        if (value.numericValue() != null) {
            return value.numericValue().toString();
        }
        return value.stringValue();
    }

    public String toString() {
        return "numeric-int";
    }
}

