/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.decoders;

import org.apache.lucene.document.Field;
import org.apache.lucene.util.BytesRef;
import org.getopt.luke.decoders.BinaryDecoder;
import org.getopt.luke.decoders.Decoder;

public class StringDecoder
implements Decoder {
    BinaryDecoder b = new BinaryDecoder();

    public String decodeTerm(String fieldName, Object value) {
        if (value == null) {
            return "(null)";
        }
        if (value instanceof BytesRef) {
            return ((BytesRef)value).utf8ToString();
        }
        return value.toString();
    }

    public String decodeStored(String fieldName, Field value) throws Exception {
        if (value.binaryValue() != null) {
            return this.b.decodeStored(fieldName, value);
        }
        String val = value.stringValue();
        if (val == null && value.numericValue() != null) {
            val = value.numericValue().toString();
        }
        return this.decodeTerm(fieldName, val);
    }

    public String toString() {
        return "string utf8";
    }
}

