/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.PrintStream;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class CustomSimilarity
extends DefaultSimilarity {
    private static final int M_A_COORD = 0;
    private static final int M_A_IDF = 1;
    private static final int M_A_LENGTHNORM = 2;
    private static final int M_A_QUERYNORM = 3;
    private static final int M_A_SLOPPYFREQ = 4;
    private static final int M_A_TF = 5;
    private static final int M_A_MAX = 6;
    private static final int M_IDF_CS = 0;
    private static final int M_IDF_TS = 1;
    private static final int M_TF_I = 2;
    private static final int M_MAX = 3;
    private String[] abstractIds = new String[]{"coord", "idf", "lengthNorm", "queryNorm", "sloppyFreq", "tf"};
    private String[] otherIds = new String[]{"idf_cs", "idf_ts", "tf_i"};
    private Function[] abstractMethods = new Function[6];
    private Function[] otherMethods = new Function[3];
    private ScriptableObject scope = null;
    private Context cx = null;

    public CustomSimilarity(Context cx, ScriptableObject scope, PrintStream printStream) throws Exception {
        Object m;
        int i;
        this.scope = scope;
        this.cx = cx;
        for (i = 0; i < this.abstractIds.length; ++i) {
            block8: {
                block7: {
                    m = scope.get(this.abstractIds[i], (Scriptable)scope);
                    if (m == null) break block7;
                    if (m != cx.getUndefinedValue() && m != Scriptable.NOT_FOUND) break block8;
                }
                throw new Exception("Required abstract method '" + this.abstractIds[i] + "' is missing.");
            }
            if (!(m instanceof Function)) {
                throw new Exception("Symbol '" + this.abstractIds[i] + "' is not a function.");
            }
            this.abstractMethods[i] = (Function)m;
        }
        for (i = 0; i < this.otherIds.length; ++i) {
            m = scope.get(this.otherIds[i], (Scriptable)scope);
            if (m == null) continue;
            if (m == cx.getUndefinedValue() || m == Scriptable.NOT_FOUND) continue;
            if (!(m instanceof Function)) {
                throw new Exception("Symbol '" + this.otherIds[i] + "' is not a function, but'" + m + "'");
            }
            this.otherMethods[i] = (Function)m;
        }
        scope.defineFunctionProperties(new String[]{"print"}, CustomSimilarity.class, 2);
        ScriptableObject.putProperty((Scriptable)scope, "stdout", (Object)printStream);
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object ps = thisObj.get("stdout", thisObj);
        if (ps == null || !(ps instanceof PrintStream)) {
            return;
        }
        PrintStream printStream = (PrintStream)ps;
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                printStream.print(" ");
            }
            String s = Context.toString(args[i]);
            printStream.print(s);
        }
        printStream.println();
    }

    public void destroy() {
        CustomSimilarity customSimilarity = this;
        customSimilarity.cx.exit();
    }

    public float idf(long docFreq, long numDocs) {
        Object[] args = new Object[]{new Long(docFreq), new Long(numDocs)};
        Object res = this.abstractMethods[1].call(this.cx, this.scope, this.scope, args);
        if (res instanceof Number) {
            return ((Number)res).floatValue();
        }
        return 0.0f;
    }

    public float computeNorm(String field, FieldInvertState state) {
        Object[] args = new Object[]{field, new Integer(state.getLength())};
        Object res = this.abstractMethods[2].call(this.cx, this.scope, this.scope, args);
        float f = 0.0f;
        try {
            f = Float.parseFloat(res.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f;
    }

    public float queryNorm(float arg0) {
        Object[] args = new Object[]{new Float(arg0)};
        Object res = this.abstractMethods[3].call(this.cx, this.scope, this.scope, args);
        float f = 0.0f;
        try {
            f = Float.parseFloat(res.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f;
    }

    public float sloppyFreq(int arg0) {
        Object[] args = new Object[]{new Integer(arg0)};
        Object res = this.abstractMethods[4].call(this.cx, this.scope, this.scope, args);
        float f = 0.0f;
        try {
            f = Float.parseFloat(res.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f;
    }

    public float tf(float arg0) {
        Object[] args = new Object[]{new Float(arg0)};
        Object res = this.abstractMethods[5].call(this.cx, this.scope, this.scope, args);
        float f = 0.0f;
        try {
            f = Float.parseFloat(res.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f;
    }

    public float tf(int arg0) {
        Function func = this.otherMethods[2];
        if (func == null) {
            return super.tf(arg0);
        }
        Object[] args = new Object[]{new Integer(arg0)};
        Object res = func.call(this.cx, this.scope, this.scope, args);
        float f = 0.0f;
        try {
            f = Float.parseFloat(res.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f;
    }
}

