/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.plugins.Shell;
import org.getopt.luke.plugins.TAWriter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptingPlugin
extends LukePlugin {
    private Shell shell = null;
    private StringBuffer scroll = new StringBuffer();

    public void reset() {
        if (this.shell != null) {
            this.shell.destroy();
        }
        Object ta = this.app.find(this.myUi, "console");
        this.app.setString(ta, "text", "");
        this.scroll.setLength(0);
        StringWriter writer = new StringWriter();
        TAWriter taw = new TAWriter(this.app, ta, this.scroll, writer);
        try {
            this.shell = new Shell(taw, taw, System.in);
            ScriptableObject.putProperty((Scriptable)this.shell, "app", (Object)this.app);
            ScriptableObject.putProperty((Scriptable)this.shell, "ir", (Object)this.ir);
            ScriptableObject.putProperty((Scriptable)this.shell, "dir", (Object)this.dir);
            ScriptableObject.putProperty((Scriptable)this.shell, "myUi", this.myUi);
            this.shell.prompt();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.app.errorMsg("Error initializing Shell:\n" + e.getMessage());
        }
    }

    public void clear() {
        this.scroll.setLength(0);
        this.scroll.append("js> ");
        Object console = this.app.find(this.myUi, "console");
        this.app.setString(console, "text", this.scroll.toString());
        this.app.requestFocus(console);
        this.app.setInteger(console, "start", this.scroll.length());
        this.app.setInteger(console, "end", this.scroll.length());
    }

    public String getXULName() {
        return "/xml/scr-plugin.xml";
    }

    public String getPluginName() {
        return "Scripting Luke";
    }

    public String getPluginInfo() {
        return "Luke Scripting Plugin; by Andrzej Bialecki";
    }

    public String getPluginHome() {
        return "mailto:ab@getopt.org";
    }

    public boolean init() throws Exception {
        if (this.shell == null) {
            this.reset();
        }
        ScriptableObject.putProperty((Scriptable)this.shell, "app", (Object)this.app);
        ScriptableObject.putProperty((Scriptable)this.shell, "ir", (Object)this.ir);
        ScriptableObject.putProperty((Scriptable)this.shell, "dir", (Object)this.dir);
        ScriptableObject.putProperty((Scriptable)this.shell, "myUi", this.myUi);
        return true;
    }

    public void setWrap(Object cbWrap, Object ta) {
        this.app.setBoolean(ta, "wrap", this.app.getBoolean(cbWrap, "selected"));
    }

    public void execute(String cmd) {
        this.scroll.append(cmd);
        if (!cmd.endsWith("\n")) {
            this.scroll.append("\n");
        }
        this.shell.processSource(this.shell.getContext(), cmd.trim());
        Object console = this.app.find(this.myUi, "console");
        this.app.requestFocus(console);
        this.app.setInteger(console, "start", this.scroll.length());
        this.app.setInteger(console, "end", this.scroll.length());
    }

    public void ins(Object ta) {
        String text = this.app.getString(ta, "text");
        if (!text.substring(0, this.scroll.length()).equals(this.scroll.toString())) {
            text = this.scroll.toString() + text.substring(this.scroll.length() + 1);
            this.app.setString(ta, "text", text);
            this.app.setInteger(ta, "start", text.length());
            this.app.setInteger(ta, "end", text.length());
        }
        String cmd = text.substring(this.scroll.length());
        int idx = cmd.indexOf(10);
        if (cmd.endsWith("\n") && this.shell.getContext().stringIsCompilableUnit(cmd)) {
            this.execute(cmd);
        }
    }

    public void rem(Object ta) {
        int start = this.app.getInteger(ta, "start");
        if (start < this.scroll.length()) {
            this.app.setString(ta, "text", this.scroll.toString());
            this.app.setInteger(ta, "start", this.scroll.length());
            this.app.setInteger(ta, "end", this.scroll.length());
        }
    }

    public void car(Object ta) {
        int start = this.app.getInteger(ta, "start");
        if (start < this.scroll.length()) {
            this.app.setInteger(ta, "start", this.scroll.length());
            this.app.setInteger(ta, "end", this.scroll.length());
        }
    }

    public void actionHelp(Object ta) {
        String cmd = "help()\n";
        this.execute(cmd);
    }

    public void actionSample() {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = this.getClass().getResourceAsStream("/xml/SampleScript.js");
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            this.execute(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.app.errorMsg("Loading failed: " + e.getMessage());
            return;
        }
    }
}

