/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.debug.DebuggableScript;

final class InterpretedFunction
extends NativeFunction
implements Script {
    InterpreterData idata;
    SecurityController securityController;
    Object securityDomain;
    Scriptable[] functionRegExps;

    private InterpretedFunction(InterpreterData interpreterData, Object object) {
        Object object2;
        this.idata = interpreterData;
        Context context = Context.getContext();
        SecurityController securityController = context.getSecurityController();
        if (securityController != null) {
            object2 = securityController.getDynamicSecurityDomain(object);
        } else {
            if (object != null) {
                throw new IllegalArgumentException();
            }
            object2 = null;
        }
        this.securityController = securityController;
        this.securityDomain = object2;
    }

    private InterpretedFunction(InterpretedFunction interpretedFunction, int n) {
        this.idata = interpretedFunction.idata.itsNestedFunctions[n];
        this.securityController = interpretedFunction.securityController;
        this.securityDomain = interpretedFunction.securityDomain;
    }

    static InterpretedFunction createScript(InterpreterData interpreterData, Object object) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData, object);
        interpretedFunction.initScriptObject();
        return interpretedFunction;
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpreterData interpreterData, Object object) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData, object);
        interpretedFunction.initInterpretedFunction(context, scriptable);
        return interpretedFunction;
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = new InterpretedFunction(interpretedFunction, n);
        interpretedFunction2.initInterpretedFunction(context, scriptable);
        return interpretedFunction2;
    }

    Scriptable[] createRegExpWraps(Context context, Scriptable scriptable) {
        if (this.idata.itsRegExpLiterals == null) {
            Kit.codeBug();
        }
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        int n = this.idata.itsRegExpLiterals.length;
        Scriptable[] scriptableArray = new Scriptable[n];
        for (int i = 0; i != n; ++i) {
            scriptableArray[i] = regExpProxy.wrapRegExp(context, scriptable, this.idata.itsRegExpLiterals[i]);
        }
        return scriptableArray;
    }

    private void initInterpretedFunction(Context context, Scriptable scriptable) {
        this.initScriptFunction(context, scriptable, this.idata.itsName);
        if (this.idata.itsRegExpLiterals != null) {
            this.functionRegExps = this.createRegExpWraps(context, scriptable);
        }
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return Interpreter.interpret(this, context, scriptable, scriptable2, objectArray);
    }

    public Object exec(Context context, Scriptable scriptable) {
        if (this.idata.itsFunctionType != 0) {
            throw new IllegalStateException();
        }
        return this.call(context, scriptable, scriptable, ScriptRuntime.emptyArgs);
    }

    public String getEncodedSource() {
        return Interpreter.getEncodedSource(this.idata);
    }

    public DebuggableScript getDebuggableView() {
        return this.idata;
    }

    protected int getLanguageVersion() {
        return this.idata.languageVersion;
    }

    protected int getParamCount() {
        return this.idata.argCount;
    }

    protected int getParamAndVarCount() {
        return this.idata.argNames.length;
    }

    protected String getParamOrVarName(int n) {
        return this.idata.argNames[n];
    }
}

