/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

class SpecialRef
extends Ref {
    private static final int SPECIAL_NONE = 0;
    private static final int SPECIAL_PROTO = 1;
    private static final int SPECIAL_PARENT = 2;
    private int type;
    private String name;

    private SpecialRef(int n, String string) {
        this.type = n;
        this.name = string;
    }

    static Ref createSpecial(Context context, Object object, String string) {
        int n;
        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object);
        if (scriptable == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        if (string.equals("__proto__")) {
            n = 1;
        } else if (string.equals("__parent__")) {
            n = 2;
        } else {
            throw new IllegalArgumentException(string);
        }
        if (!context.hasFeature(5)) {
            n = 0;
        }
        return Ref.pushTarget(context, new SpecialRef(n, string), scriptable);
    }

    public Object get(Context context, Scriptable scriptable) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.getObjectProp(scriptable, this.name, context);
            }
            case 1: {
                return scriptable.getPrototype();
            }
            case 2: {
                return scriptable.getParentScope();
            }
        }
        throw Kit.codeBug();
    }

    public Object set(Context context, Scriptable scriptable, Object object) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.setObjectProp(scriptable, this.name, object, context);
            }
            case 1: 
            case 2: {
                Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object);
                if (scriptable2 != null) {
                    Scriptable scriptable3 = scriptable2;
                    do {
                        if (scriptable3 != scriptable) continue;
                        throw Context.reportRuntimeError1("msg.cyclic.value", this.name);
                    } while ((scriptable3 = this.type == 1 ? scriptable3.getPrototype() : scriptable3.getParentScope()) != null);
                }
                if (this.type == 1) {
                    scriptable.setPrototype(scriptable2);
                } else {
                    scriptable.setParentScope(scriptable2);
                }
                return scriptable2;
            }
        }
        throw Kit.codeBug();
    }

    public boolean has(Context context, Scriptable scriptable) {
        if (this.type == 0) {
            return ScriptRuntime.hasObjectElem(scriptable, this.name, context);
        }
        return true;
    }

    public boolean delete(Context context, Scriptable scriptable) {
        if (this.type == 0) {
            return ScriptRuntime.deleteObjectElem(scriptable, this.name, context);
        }
        return false;
    }
}

