/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.EvalTextArea;
import org.mozilla.javascript.tools.debugger.Evaluator;
import org.mozilla.javascript.tools.debugger.MyTableModel;
import org.mozilla.javascript.tools.debugger.MyTreeTable;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.debugger.VariableModel;

class ContextWindow
extends JPanel
implements ActionListener {
    SwingGui debugGui;
    JComboBox context;
    Vector toolTips;
    JTabbedPane tabs;
    JTabbedPane tabs2;
    MyTreeTable thisTable;
    MyTreeTable localsTable;
    MyTableModel tableModel;
    Evaluator evaluator;
    EvalTextArea cmdLine;
    JSplitPane split;
    boolean enabled;
    static /* synthetic */ Class class$java$awt$event$WindowListener;

    ContextWindow(final SwingGui swingGui) {
        this.debugGui = swingGui;
        this.enabled = false;
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setName("Variables");
        jToolBar.setLayout(new GridLayout());
        jToolBar.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        jPanel2.add(jToolBar);
        JLabel jLabel = new JLabel("Context:");
        this.context = new JComboBox();
        this.context.setLightWeightPopupEnabled(false);
        this.toolTips = new Vector();
        jLabel.setBorder(this.context.getBorder());
        this.context.addActionListener(this);
        this.context.setActionCommand("ContextSwitch");
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 5;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagLayout.setConstraints(this.context, gridBagConstraints2);
        jPanel.add(this.context);
        this.tabs = new JTabbedPane(3);
        this.tabs.setPreferredSize(new Dimension(500, 300));
        this.thisTable = new MyTreeTable(new VariableModel());
        JScrollPane jScrollPane = new JScrollPane(this.thisTable);
        jScrollPane.getViewport().setViewSize(new Dimension(5, 2));
        this.tabs.add("this", jScrollPane);
        this.localsTable = new MyTreeTable(new VariableModel());
        this.localsTable.setAutoResizeMode(4);
        this.localsTable.setPreferredSize(null);
        jScrollPane = new JScrollPane(this.localsTable);
        this.tabs.add("Locals", jScrollPane);
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridheight = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 17;
        gridBagLayout.setConstraints(this.tabs, gridBagConstraints2);
        jPanel.add(this.tabs);
        this.evaluator = new Evaluator(swingGui);
        this.cmdLine = new EvalTextArea(swingGui);
        this.tableModel = this.evaluator.tableModel;
        jScrollPane = new JScrollPane(this.evaluator);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setName("Evaluate");
        this.tabs2 = new JTabbedPane(3);
        this.tabs2.add("Watch", jScrollPane);
        this.tabs2.add("Evaluate", new JScrollPane(this.cmdLine));
        this.tabs2.setPreferredSize(new Dimension(500, 300));
        jToolBar2.setLayout(new GridLayout());
        jToolBar2.add(this.tabs2);
        jPanel3.add(jToolBar2);
        this.evaluator.setAutoResizeMode(4);
        this.split = new JSplitPane(1, jPanel2, jPanel3);
        this.split.setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.split, 0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        final JToolBar jToolBar3 = jToolBar;
        final JToolBar jToolBar4 = jToolBar2;
        final JPanel jPanel4 = jPanel2;
        final JPanel jPanel5 = jPanel3;
        final JSplitPane jSplitPane = this.split;
        final ContextWindow contextWindow = this;
        ComponentListener componentListener = new ComponentListener(){
            boolean t1Docked = true;
            boolean t2Docked = true;

            void check(Component component) {
                Container container;
                Container container2 = contextWindow.getParent();
                if (container2 == null) {
                    return;
                }
                Container container3 = jToolBar3.getParent();
                boolean bl = true;
                boolean bl2 = true;
                boolean bl3 = false;
                if (container3 != null) {
                    if (container3 != jPanel4) {
                        while (!(container3 instanceof JFrame)) {
                            container3 = container3.getParent();
                        }
                        container = (JFrame)container3;
                        swingGui.addTopLevel("Variables", (JFrame)container);
                        if (!((Frame)container).isResizable()) {
                            ((Frame)container).setResizable(true);
                            ((JFrame)container).setDefaultCloseOperation(0);
                            EventListener[] eventListenerArray = container.getListeners(class$java$awt$event$WindowListener == null ? (class$java$awt$event$WindowListener = ContextWindow.class$("java.awt.event.WindowListener")) : class$java$awt$event$WindowListener);
                            ((Window)container).removeWindowListener((WindowListener)eventListenerArray[0]);
                            ((Window)container).addWindowListener(new WindowAdapter(this, eventListenerArray){
                                private final /* synthetic */ EventListener[] val$l;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$l = eventListenerArray;
                                }

                                public void windowClosing(WindowEvent windowEvent) {
                                    1.access$000(this.this$1).context.hidePopup();
                                    ((WindowListener)this.val$l[0]).windowClosing(windowEvent);
                                }
                            });
                        }
                        bl = false;
                    } else {
                        bl = true;
                    }
                }
                if ((container3 = jToolBar4.getParent()) != null) {
                    if (container3 != jPanel5) {
                        while (!(container3 instanceof JFrame)) {
                            container3 = container3.getParent();
                        }
                        container = (JFrame)container3;
                        swingGui.addTopLevel("Evaluate", (JFrame)container);
                        ((Frame)container).setResizable(true);
                        bl2 = false;
                    } else {
                        bl2 = true;
                    }
                }
                if (bl && this.t2Docked && bl2 && this.t2Docked) {
                    return;
                }
                this.t1Docked = bl;
                this.t2Docked = bl2;
                container = (JSplitPane)container2;
                if (bl) {
                    if (bl2) {
                        jSplitPane.setDividerLocation(0.5);
                    } else {
                        jSplitPane.setDividerLocation(1.0);
                    }
                    if (bl3) {
                        ((JSplitPane)container).setDividerLocation(0.66);
                    }
                } else if (bl2) {
                    jSplitPane.setDividerLocation(0.0);
                    ((JSplitPane)container).setDividerLocation(0.66);
                } else {
                    ((JSplitPane)container).setDividerLocation(1.0);
                }
            }

            public void componentHidden(ComponentEvent componentEvent) {
                this.check(componentEvent.getComponent());
            }

            public void componentMoved(ComponentEvent componentEvent) {
                this.check(componentEvent.getComponent());
            }

            public void componentResized(ComponentEvent componentEvent) {
                this.check(componentEvent.getComponent());
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.check(componentEvent.getComponent());
            }

            static /* synthetic */ ContextWindow access$000(1 var0) {
                return var0.ContextWindow.this;
            }
        };
        jPanel2.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                Container container = contextWindow.getParent();
                JSplitPane jSplitPane2 = (JSplitPane)container;
                if (containerEvent.getChild() == jToolBar3) {
                    if (jToolBar4.getParent() == jPanel5) {
                        jSplitPane.setDividerLocation(0.5);
                    } else {
                        jSplitPane.setDividerLocation(1.0);
                    }
                    jSplitPane2.setDividerLocation(0.66);
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Container container = contextWindow.getParent();
                JSplitPane jSplitPane2 = (JSplitPane)container;
                if (containerEvent.getChild() == jToolBar3) {
                    if (jToolBar4.getParent() == jPanel5) {
                        jSplitPane.setDividerLocation(0.0);
                        jSplitPane2.setDividerLocation(0.66);
                    } else {
                        jSplitPane2.setDividerLocation(1.0);
                    }
                }
            }
        });
        jToolBar.addComponentListener(componentListener);
        jToolBar2.addComponentListener(componentListener);
        this.disable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.enabled) {
            return;
        }
        if (actionEvent.getActionCommand().equals("ContextSwitch")) {
            Dim.ContextData contextData = this.debugGui.dim.currentContextData();
            if (contextData == null) {
                return;
            }
            int n = this.context.getSelectedIndex();
            this.context.setToolTipText(this.toolTips.elementAt(n).toString());
            int n2 = contextData.frameCount();
            if (n >= n2) {
                return;
            }
            Dim.StackFrame stackFrame = contextData.getFrame(n);
            Object object = stackFrame.scope();
            Object object2 = stackFrame.thisObj();
            this.thisTable.resetTree(new VariableModel(this.debugGui.dim, object2));
            VariableModel variableModel = object != object2 ? new VariableModel(this.debugGui.dim, object) : new VariableModel();
            this.localsTable.resetTree(variableModel);
            this.debugGui.dim.contextSwitch(n);
            this.debugGui.showStopLine(stackFrame);
            this.tableModel.updateModel();
        }
    }

    public void disable() {
        this.context.setEnabled(false);
        this.thisTable.setEnabled(false);
        this.localsTable.setEnabled(false);
        this.evaluator.setEnabled(false);
        this.cmdLine.setEnabled(false);
    }

    public void enable() {
        this.context.setEnabled(true);
        this.thisTable.setEnabled(true);
        this.localsTable.setEnabled(true);
        this.evaluator.setEnabled(true);
        this.cmdLine.setEnabled(true);
    }

    public void disableUpdate() {
        this.enabled = false;
    }

    public void enableUpdate() {
        this.enabled = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

