/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.PrintStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SwingGui;

public class Main
implements ContextListener {
    Dim dim = new Dim();
    SwingGui debugGui;

    public Main(String string) {
        this.debugGui = new SwingGui(this.dim, string);
        this.dim.callback = this.debugGui;
    }

    public void doBreak() {
        this.dim.breakFlag = true;
    }

    public void setBreakOnExceptions(boolean bl) {
        this.dim.breakOnExceptions = bl;
    }

    public void setBreakOnEnter(boolean bl) {
        this.dim.breakOnEnter = bl;
    }

    public void setBreakOnReturn(boolean bl) {
        this.dim.breakOnReturn = bl;
    }

    public void clearAllBreakpoints() {
        this.dim.clearAllBreakpoints();
    }

    public void go() {
        this.dim.go();
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.dim.scopeProvider = scopeProvider;
    }

    public void setExitAction(Runnable runnable) {
        this.debugGui.exitAction = runnable;
    }

    public InputStream getIn() {
        return this.debugGui.console.getIn();
    }

    public PrintStream getOut() {
        return this.debugGui.console.getOut();
    }

    public PrintStream getErr() {
        return this.debugGui.console.getErr();
    }

    public void pack() {
        this.debugGui.pack();
    }

    public void setSize(int n, int n2) {
        ((Component)this.debugGui).setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        ((Component)this.debugGui).setSize(dimension.width, dimension.height);
    }

    public void setVisible(boolean bl) {
        this.debugGui.setVisible(bl);
    }

    public boolean isVisible() {
        return this.debugGui.isVisible();
    }

    public void attachTo(ContextFactory contextFactory) {
        this.dim.attachTo(contextFactory);
    }

    public void setOptimizationLevel(int n) {
    }

    public void contextEntered(Context context) {
        throw new IllegalStateException();
    }

    public void contextExited(Context context) {
        throw new IllegalStateException();
    }

    public void contextCreated(Context context) {
        throw new IllegalStateException();
    }

    public void contextReleased(Context context) {
        throw new IllegalStateException();
    }

    public static void main(String[] stringArray) {
        Main main = new Main("Rhino JavaScript Debugger");
        main.doBreak();
        main.setExitAction(new IProxy(1));
        System.setIn(main.getIn());
        System.setOut(main.getOut());
        System.setErr(main.getErr());
        main.attachTo(org.mozilla.javascript.tools.shell.Main.shellContextFactory);
        main.setScopeProvider(new IProxy(2));
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
        org.mozilla.javascript.tools.shell.Main.exec(stringArray);
    }

    public static void mainEmbedded(String string) {
        IProxy iProxy = new IProxy(2);
        Main.mainEmbedded(ContextFactory.getGlobal(), iProxy, string);
    }

    public static void mainEmbedded(ContextFactory contextFactory, ScopeProvider scopeProvider, String string) {
        if (string == null) {
            string = "Rhino JavaScript Debugger (embedded usage)";
        }
        Main main = new Main(string);
        main.doBreak();
        main.setExitAction(new IProxy(1));
        main.attachTo(contextFactory);
        main.setScopeProvider(scopeProvider);
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
    }

    private static class IProxy
    implements Runnable,
    ScopeProvider {
        static final int EXIT_ACTION = 1;
        static final int SCOPE_PROVIDER = 2;
        private final int type;

        IProxy(int n) {
            this.type = n;
        }

        public void run() {
            if (this.type != 1) {
                Kit.codeBug();
            }
            System.exit(0);
        }

        public Scriptable getScope() {
            if (this.type != 2) {
                Kit.codeBug();
            }
            return org.mozilla.javascript.tools.shell.Main.getScope();
        }
    }
}

