﻿using ESBasic;
using Oraycn.MCapture;
using Oraycn.MFile;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
namespace ZlfApp.qian3
{
    public partial class wushengLP : Form
    {
        private ISoundcardCapturer soundcardCapturer;
        private IMicrophoneCapturer microphoneCapturer;
        private IDesktopCapturer desktopCapturer;
        private IAudioMixter audioMixter;
        private VideoFileMaker videoFileMaker;
        private SilenceVideoFileMaker silenceVideoFileMaker;
        private AudioFileMaker audioFileMaker;
        private int frameRate = 10;
        private bool sizeRevised = false;
        private bool isRecording = false;
        private bool isParsing = false;
        private Timer timer;
        private int seconds = 0;
        private bool justRecordVideo = false;
        private bool justRecordAudio = false;
        public wushengLP()
        {
            InitializeComponent();
            Oraycn.MCapture.GlobalUtil.SetAuthorizedUser("FreeUser", "");
            Oraycn.MFile.GlobalUtil.SetAuthorizedUser("FreeUser", "");
            this.timer = new Timer();
            this.timer.Interval = 1000;
            this.timer.Tick += new EventHandler(shijian);
        }
        void shijian(object sender, EventArgs e)
        {
            if (this.isRecording && !this.isParsing)
            {
                var ts = new TimeSpan(0, 0, ++seconds);
                this.label2.Text = ts.Hours.ToString("00") + ":" + ts.Minutes.ToString("00") + ":" + ts.Seconds.ToString("00");
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (this.isParsing)
            {
                this.isParsing = false;
            }
            else
            {
                this.isParsing = true;
            }
            this.zhanting.Text = (!this.isParsing ? "暂停" : "恢复");
        }
        private void button3_Click(object sender, EventArgs e)
        {
            if (textBox1.Text.Trim().Equals(string.Empty))
            {
                MessageBox.Show("结束失败，请填写视频名字！", "飞飞录制提醒您");
            }
            else
            {
                this.wbsy.Enabled = true;
                this.nbsy.Enabled = true;
                this.lzzm.Enabled = true;
                this.lzsy.Enabled = true;
                this.kaishiluzhi.Enabled = true;
                this.zhanting.Text = "暂停";
                if (this.wbsy.Checked)
                {
                    this.microphoneCapturer.Stop();
                }
                if (this.nbsy.Checked)
                {
                    this.soundcardCapturer.Stop();
                }
                if (this.lzzm.Checked)
                {
                    this.desktopCapturer.Stop();
                }
                if (this.justRecordAudio)
                {
                    this.audioFileMaker.Close(true);
                }
                else
                {
                    if (!this.justRecordVideo)
                    {
                        this.videoFileMaker.Close(true);
                    }
                    else
                    {
                        this.silenceVideoFileMaker.Close(true);
                    }
                }
                this.isRecording = false;
                MessageBox.Show("录制完成！");
            }
        }
        #region
        void Form1_ImageCaptured(Bitmap img)
        {
            if (this.isRecording && !this.isParsing)
            {
                Bitmap imgRecorded = img;
                if (this.sizeRevised)
                {
                    imgRecorded = ESBasic.Helpers.ImageHelper.RoundSizeByNumber(img, 4);
                    img.Dispose();
                }
                if (!this.justRecordVideo)
                {
                    this.videoFileMaker.AddVideoFrame(imgRecorded);
                }
                else
                {
                    this.silenceVideoFileMaker.AddVideoFrame(imgRecorded);
                }
            }
        }
        #endregion
        #region
        void audioMixter_AudioMixed(byte[] audioData)
        {
            if (this.isRecording && !this.isParsing)
            {
                if (this.justRecordAudio)
                {
                    this.audioFileMaker.AddAudioFrame(audioData);
                }
                else
                {
                    if (!this.justRecordVideo)
                    {
                        this.videoFileMaker.AddAudioFrame(audioData);
                    }
                }

            }
        }
        #region
        void CaptureError(Exception obj)
        {
            MessageBox.Show("录制失败，请关闭重新录制！", "飞飞录制提醒您");
        }
        #endregion
        private void kaishiluzhi_Click(object sender, EventArgs e)
        {
            if (textBox1.Text.Trim().Equals(string.Empty))
            {
                MessageBox.Show("录制之前请先给照片起个名字！", "飞飞录制提醒您");
            }
            else
            {
                int audioSampleRate = 16000;
                int channelCount = 1;
                seconds = 0;

                System.Drawing.Size videoSize = Screen.PrimaryScreen.Bounds.Size;
                this.justRecordAudio = this.lzsy.Checked;

                if (this.justRecordAudio && !this.wbsy.Checked && !this.nbsy.Checked)
                {
                    MessageBox.Show("一定要选择一个声音路径！");
                    return;
                }
                #region
                if (this.lzzm.Checked)
                {
                    this.desktopCapturer = CapturerFactory.CreateDesktopCapturer(frameRate, false);
                    this.desktopCapturer.ImageCaptured += this.Form1_ImageCaptured;
                    videoSize = this.desktopCapturer.VideoSize;
                }
                else if (this.wbsy.Checked)
                {
                    this.microphoneCapturer = CapturerFactory.CreateMicrophoneCapturer(0);
                    this.microphoneCapturer.CaptureError += new CbGeneric<Exception>(this.CaptureError);
                }
                if (this.nbsy.Checked)
                {
                    this.soundcardCapturer = CapturerFactory.CreateSoundcardCapturer();
                    this.soundcardCapturer.CaptureError += this.CaptureError;
                    audioSampleRate = this.soundcardCapturer.SampleRate;
                    channelCount = this.soundcardCapturer.ChannelCount;
                }
                if (this.wbsy.Checked && this.nbsy.Checked)
                {
                    MessageBox.Show("您将录制混合音量", "飞飞录制提醒您");
                    this.audioMixter = CapturerFactory.CreateAudioMixter(this.microphoneCapturer, this.soundcardCapturer,
                    SoundcardMode4Mix.DoubleChannel, true);
                    this.audioMixter.AudioMixed += audioMixter_AudioMixed;
                    audioSampleRate = this.audioMixter.SampleRate;
                    channelCount = this.audioMixter.ChannelCount;
                }
                else if (this.wbsy.Checked)
                {
                    this.microphoneCapturer.AudioCaptured += audioMixter_AudioMixed;
                }
                else if (this.nbsy.Checked)
                {
                    this.soundcardCapturer.AudioCaptured += audioMixter_AudioMixed;
                }
                #endregion
                #region
                if (this.wbsy.Checked)
                {
                    this.microphoneCapturer.Start();
                }
                if (this.nbsy.Checked)
                {
                    this.soundcardCapturer.Start();
                }

                else if (this.lzzm.Checked)
                {
                    this.desktopCapturer.Start();
                }
                #endregion
                #region
                if (this.justRecordAudio)
                {
                    this.audioFileMaker = new AudioFileMaker();
                    this.audioFileMaker.Initialize("" + textBox1.Text + ".mp3", audioSampleRate, channelCount);
                    MessageBox.Show("您录制了一段音频！", "飞飞录制提醒您");
                }
                else
                {
                    this.sizeRevised = (videoSize.Width % 4 != 0) || (videoSize.Height % 4 != 0);
                    if (this.sizeRevised)
                    {
                        videoSize = new System.Drawing.Size(videoSize.Width / 4 * 4, videoSize.Height / 4 * 4);
                    }

                    if (!this.wbsy.Checked && !this.nbsy.Checked)
                    {
                        MessageBox.Show("您将只录制图像而没有声音！", "飞飞录制提醒您");
                        this.justRecordVideo = true;
                        this.silenceVideoFileMaker = new SilenceVideoFileMaker();
                        this.silenceVideoFileMaker.Initialize("" + textBox1.Text + ".mp4", VideoCodecType.H264, videoSize.Width, videoSize.Height, frameRate, VideoQuality.Middle);
                    }
                    else
                    {
                        MessageBox.Show("您将录制图像并录制声音！", "飞飞录制提醒您");
                        this.justRecordVideo = false;
                        this.videoFileMaker = new VideoFileMaker();
                        this.videoFileMaker.Initialize("" + textBox1.Text + ".mp4", VideoCodecType.H264, videoSize.Width, videoSize.Height, frameRate, VideoQuality.High, AudioCodecType.AAC, audioSampleRate, channelCount, true);
                    }
                }
                #endregion
                this.isRecording = true;
                this.isParsing = false;
                this.timer.Start();
                this.wbsy.Enabled = false;
                this.nbsy.Enabled = false;
                this.lzzm.Enabled = false;
                this.lzsy.Enabled = false;
                this.kaishiluzhi.Enabled = false;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string open = Application.StartupPath.ToString();
            System.Diagnostics.Process.Start(open);
        }
    }
}
#endregion