﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Collections;
using System.Text.RegularExpressions;

using System.Threading;

namespace BatchFiles
{
    public delegate void DelegateSetLog(string text);
    public delegate void DelegateClearList();

    public partial class Form1 : Form
    {
        public DelegateSetLog delegateSetLog;
        public DelegateClearList delegateClearList;

        ArrayList alFiles = new ArrayList();
        public Form1()
        {
            InitializeComponent();
            delegateSetLog = new DelegateSetLog(SetLog);
            delegateClearList = new DelegateClearList(ClearList);
        }

        private void SetLog(string text)
        {
            lstLog.Items.Add(text);
        }

        private void ClearList()
        {
            alFiles.Clear();
            EnableButtons();
        }

        private void EnableButtons()
        {
            if (alFiles.Count > 0)
            {
                btnCopy.Enabled = true;
                btnCut.Enabled = true;
                btnDelete.Enabled = true;
            }
            else
            {
                btnCopy.Enabled = false;
                btnCut.Enabled = false;
                btnDelete.Enabled = false;
            }
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            // Preview Step1 : Check data
            alFiles.Clear();
            lstLog.Items.Clear();
            lstLog.Items.Add("开始预览!");

            string strWorkDir = txtWork.Text;
            DirectoryInfo diWork = new DirectoryInfo(strWorkDir);
            if (!diWork.Exists)
            {
                lstLog.Items.Add("待处理文件夹不存在");
                lstLog.Items.Add("结束预览!");
                return;
            }

            string strDestDir = txtDest.Text;
            DirectoryInfo diDestDir = new DirectoryInfo(strDestDir);
            if (!diDestDir.Exists)
            {
                lstLog.Items.Add("目的文件夹不存在");
                lstLog.Items.Add("结束预览!");
                return;
            }

            string strExpress = txtExpr.Text;
            if (strExpress.Length == 0)
            {
                lstLog.Items.Add("您没有输入正则表达式，无意义");
                lstLog.Items.Add("结束预览!");
                return;
            }

            bool bSub = true;
            if (chkSubFolder.CheckState == CheckState.Unchecked)
            {
                bSub = false;
            }
            bool bIgnoreCase = false;
            if (chkCaseSensitive.CheckState == CheckState.Checked)
            {
                bIgnoreCase = true;
            }

            // Preview Step2 : Collect Data
            PreviewFiles(diWork, bSub, strExpress, bIgnoreCase);

            EnableButtons();

            lstLog.Items.Add("结束预览!");
    
        }
        private void PreviewFiles(DirectoryInfo di, bool includeSubDir, string strExpress, bool bIgnoreCase)
        {
            RegexOptions ro;
            if (bIgnoreCase)
            {
                ro = RegexOptions.IgnoreCase;
            }
            else
            {
                ro = RegexOptions.None;
            }
            FileInfo[] files = di.GetFiles();
            foreach (FileInfo file in files)
            {
                try
                {
                    // Regex Here
                    if (Regex.IsMatch(file.Name, strExpress, ro))
                    {
                        alFiles.Add(file.FullName);
                        lstLog.Items.Add(file.FullName);
                    }
                }
                catch
                {
                    lstLog.Items.Add("正则表达式错误...");
                    break;
                }
            }

            // Sub dir
            if (includeSubDir)
            {
                DirectoryInfo[] dirs = di.GetDirectories();
                foreach (DirectoryInfo dir in dirs)
                {
                    PreviewFiles(dir, includeSubDir, strExpress, bIgnoreCase);
                }
            }
        }

        private void btnCopy_Click(object sender, EventArgs e)
        {
            lstLog.Items.Clear();
            lstLog.Items.Add("开始复制!");

            if (alFiles.Count == 0)
            {
                lstLog.Items.Add("您还没有预览，或者没有需要复制的文件!");
                lstLog.Items.Add("End");
                return;
            }

            // Create the thread object. This does not start the thread.
            Worker workerObject = new Worker(this, alFiles, WorkFunc.COPY, txtDest.Text);
            Thread workerThread = new Thread(workerObject.DoWork);

            // Start the worker thread.
            workerThread.Start();
        }

        private void btnCut_Click(object sender, EventArgs e)
        {
            lstLog.Items.Clear();
            lstLog.Items.Add("开始移动!");

            if (alFiles.Count == 0)
            {
                lstLog.Items.Add("您还没有预览，或者没有需要移动的文件!");
                lstLog.Items.Add("End");
                return;
            }

            // Create the thread object. This does not start the thread.
            Worker workerObject = new Worker(this, alFiles, WorkFunc.CUT, txtDest.Text);
            Thread workerThread = new Thread(workerObject.DoWork);

            // Start the worker thread.
            workerThread.Start();
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            lstLog.Items.Clear();
            lstLog.Items.Add("开始删除!");

            if (alFiles.Count == 0)
            {
                lstLog.Items.Add("您还没有预览，或者没有需要删除的文件!");
                lstLog.Items.Add("End");
                return;
            }

            // Create the thread object. This does not start the thread.
            Worker workerObject = new Worker(this, alFiles, WorkFunc.DELETE, txtDest.Text);
            Thread workerThread = new Thread(workerObject.DoWork);

            // Start the worker thread.
            workerThread.Start();
        }

        private void SearchFolders(DirectoryInfo di, bool includeSubDir, bool bIgnoreCase)
        {
            RegexOptions ro;
            if (bIgnoreCase)
            {
                ro = RegexOptions.IgnoreCase;
            }
            else
            {
                ro = RegexOptions.None;
            }
            //FileInfo[] files = di.GetFiles();
            //foreach (FileInfo file in files)
            //{
            //    try
            //    {
            //        // Regex Here
            //        if (Regex.IsMatch(file.Name, strExpress, ro))
            //        {
            //            alFiles.Add(file.FullName);
            //            lstLog.Items.Add(file.FullName);
            //        }
            //    }
            //    catch
            //    {
            //        lstLog.Items.Add("正则表达式错误...");
            //        break;
            //    }
            //}

            string strExpress = @"^Load.*$";

            // Sub dir
            if (includeSubDir)
            {
                DirectoryInfo[] dirs = di.GetDirectories();
                foreach (DirectoryInfo dir in dirs)
                {
                    
                    string destFolderPath = Path.GetDirectoryName( dir.FullName);
                    string folderName = Path.GetFileName(dir.FullName);

                    if (!Regex.IsMatch(folderName, strExpress, ro))
                    {
                        destFolderPath = destFolderPath + "\\Load." + folderName;
                        dir.MoveTo(destFolderPath);
                    }

                    
                    SearchFolders(dir, includeSubDir, bIgnoreCase);
                }
            }
        }

        private void ChangeFolderNamebtn_Click(object sender, EventArgs e)
        {
            string strWorkDir = txtWork.Text;
            DirectoryInfo diWork = new DirectoryInfo(strWorkDir);
            if (!diWork.Exists)
            {
                lstLog.Items.Add("待处理文件夹不存在");
                lstLog.Items.Add("结束预览!");
                return;
            }

            bool bSub = true;
            bool bIgnoreCase = true;

            // Preview Step2 : Collect Data
            SearchFolders(diWork, bSub, bIgnoreCase);
        }
    }
}
