﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Windows.Forms;
using System.Collections;
using System.IO;

namespace BatchFiles
{
    public enum WorkFunc 
    { 
        COPY=0,
        CUT=1,
        DELETE=2,
    } 
    class Worker
    {
        ArrayList m_alFiles;
        Form1 m_form;
        string m_destDir;
        WorkFunc m_wf;

        public Worker(Form1 mainForm, ArrayList al, WorkFunc wf, string destDir)
        {
            m_form = mainForm;
            m_alFiles = al;
            m_wf = wf;
            m_destDir = destDir;
        }
        
        // This method will be called when the thread is started.
        public void DoWork()
        {
            foreach (string file in m_alFiles)
            {
                if (m_wf == WorkFunc.COPY)
                {
                    string strDestFileName = m_destDir+"\\"+ Path.GetFileName(file);
                    File.Copy(file, strDestFileName, true);

                    string strStatus = file +"==>" + strDestFileName + @" Successed";
                    m_form.Invoke(m_form.delegateSetLog, new Object[] { strStatus });
                }
                if (m_wf == WorkFunc.CUT)
                {
                    string strDestFileName = m_destDir + "\\" + Path.GetFileName(file);
                    FileInfo fiDest = new FileInfo(strDestFileName);
                    if (fiDest.Exists)
                    {
                        // The file have already exist, we should dele this file before Move.
                        File.Delete(strDestFileName);
                    }
                    File.Move(file, strDestFileName);

                    string strStatus = file + "==>" + strDestFileName + @" Successed";
                    m_form.Invoke(m_form.delegateSetLog, new Object[] { strStatus });
                }
                if (m_wf == WorkFunc.DELETE)
                {
                    string strDestFileName = m_destDir + "\\" + Path.GetFileName(file);
                    FileInfo fiDelFile = new FileInfo(file);

                    if(fiDelFile.IsReadOnly)
                    {
                        fiDelFile.Attributes = FileAttributes.Normal;
                    } 

                    File.Delete(file);

                    string strStatus = file + " Deleted";
                    m_form.Invoke(m_form.delegateSetLog, new Object[] { strStatus });
                }
            }

            string str = "End";
            m_form.Invoke(m_form.delegateSetLog, new Object[] { str });

            m_form.Invoke(m_form.delegateClearList, new Object[] { });
        }
    }
}
