/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.CharacterEncoding;
import com.jniwrapper.DataBufferFactory;
import com.jniwrapper.MemoryBuffer;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.Pointer;
import java.io.UnsupportedEncodingException;

public class ExternalStringPointer
extends Pointer.Void {
    private CharacterEncoding c;

    public ExternalStringPointer() {
        this.setEncoding(CharacterEncoding.Unicode);
    }

    public ExternalStringPointer(boolean bl2) {
        this(bl2 ? CharacterEncoding.Unicode : CharacterEncoding.ANSI);
    }

    public ExternalStringPointer(CharacterEncoding characterEncoding) {
        this.setEncoding(characterEncoding);
    }

    public ExternalStringPointer(long l2) {
        this();
        this.setValue(l2);
    }

    public ExternalStringPointer(long l2, boolean bl2) {
        this(l2, bl2 ? CharacterEncoding.Unicode : CharacterEncoding.ANSI);
    }

    public ExternalStringPointer(long l2, CharacterEncoding characterEncoding) {
        super(l2);
        this.setEncoding(characterEncoding);
    }

    public ExternalStringPointer(Pointer.Void void_, CharacterEncoding characterEncoding) {
        super(void_);
        this.setEncoding(characterEncoding);
    }

    public ExternalStringPointer(Pointer.Void void_) {
        this(void_, CharacterEncoding.ANSI);
    }

    public String readString() {
        if (this.isNull()) {
            throw new IllegalStateException("Handle to external string is null");
        }
        long l2 = this.getValue();
        CharacterEncoding characterEncoding = this.getEncoding();
        int n2 = ExternalStringPointer.a(l2, characterEncoding);
        MemoryBuffer memoryBuffer = DataBufferFactory.getInstance().createExternMemoryBuffer(l2, n2);
        byte[] byArray = memoryBuffer.readByteArray(0, n2);
        if (characterEncoding.equals(CharacterEncoding.Unicode)) {
            try {
                return new String(byArray, characterEncoding.getCharsetName());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return new String(byArray);
    }

    private static int a(long l2, CharacterEncoding characterEncoding) {
        return characterEncoding.equals(CharacterEncoding.Unicode) ? ExternalStringPointer.a(l2) : ExternalStringPointer.b(l2);
    }

    private static int a(long l2) {
        return PlatformContext.wcslen(l2) * PlatformContext.getWideCharLength();
    }

    private static int b(long l2) {
        return PlatformContext.strlen(l2);
    }

    public boolean isUnicodeString() {
        CharacterEncoding characterEncoding = this.getEncoding();
        return characterEncoding.equals(CharacterEncoding.Unicode);
    }

    public final void setEncoding(CharacterEncoding characterEncoding) {
        this.c = characterEncoding;
    }

    public final CharacterEncoding getEncoding() {
        return this.c;
    }
}

