/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.samples.shell;

import com.jniwrapper.samples.shell.AboutPanel;
import com.jniwrapper.samples.shell.Category;
import com.jniwrapper.samples.shell.CategoryPanel;
import com.jniwrapper.samples.shell.DemoModelHelper;
import com.jniwrapper.samples.shell.Sample;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DemoTreeModel
extends DefaultTreeModel {
    private static final Logger LOG = LoggerFactory.getLogger((Class)(class$com$jniwrapper$samples$shell$DemoTreeModel == null ? (class$com$jniwrapper$samples$shell$DemoTreeModel = DemoTreeModel.class$("com.jniwrapper.samples.shell.DemoTreeModel")) : class$com$jniwrapper$samples$shell$DemoTreeModel));
    static final ImageIcon _newIcon = new ImageIcon((class$com$jniwrapper$samples$shell$DemoTreeModel == null ? (class$com$jniwrapper$samples$shell$DemoTreeModel = DemoTreeModel.class$("com.jniwrapper.samples.shell.DemoTreeModel")) : class$com$jniwrapper$samples$shell$DemoTreeModel).getResource("res/LeafNew.gif"));
    static final ImageIcon _updateIcon = new ImageIcon((class$com$jniwrapper$samples$shell$DemoTreeModel == null ? (class$com$jniwrapper$samples$shell$DemoTreeModel = DemoTreeModel.class$("com.jniwrapper.samples.shell.DemoTreeModel")) : class$com$jniwrapper$samples$shell$DemoTreeModel).getResource("res/LeafUpdate.gif"));
    private final DemoModelHelper _DemoModelHelper = DemoModelHelper.getInstance();
    private Window _parent;
    private Class _sourcePanel;
    static /* synthetic */ Class class$com$jniwrapper$samples$shell$DemoTreeModel;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;

    public DemoTreeModel(Window parent, Class sourcePanel) {
        super(new DefaultMutableTreeNode(new AboutPanel()));
        this._parent = parent;
        this._sourcePanel = sourcePanel;
        this.initModel();
    }

    private void initModel() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        Category[] categories = this._DemoModelHelper.getRoot().getCategories();
        for (int i = 0; i < categories.length; ++i) {
            this.addCategory(root, categories[i]);
        }
        this.nodeStructureChanged(root);
    }

    private void addCategory(DefaultMutableTreeNode root, Category category) {
        CategoryNode categoryNode = new CategoryNode(category.getName(), category.getDescription());
        this.appendNode(root, categoryNode);
        Category[] subCategories = category.getCategories();
        for (int i = 0; i < subCategories.length; ++i) {
            this.addCategory(categoryNode, subCategories[i]);
        }
        Sample[] samples = category.getSamples();
        for (int i = 0; i < samples.length; ++i) {
            String sampleTitle = samples[i].getName();
            if (sampleTitle == null) {
                sampleTitle = "";
            }
            boolean showSources = samples[i].getShowSources();
            Class sampleClass = null;
            try {
                sampleClass = samples[i].getSampleClass();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
            Class initParamClass = samples[i].getInitParameterClass();
            Object initParam = null;
            if (initParamClass != null) {
                try {
                    Constructor constructor = initParamClass.getConstructor(new Class[0]);
                    initParam = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    initParam = null;
                }
            }
            ImageIcon sampleIcon = null;
            if (samples[i].isNewIcon()) {
                sampleIcon = _newIcon;
            } else if (samples[i].isUpdateIcon()) {
                sampleIcon = _updateIcon;
            } else if (samples[i].isCustomIcon()) {
                try {
                    sampleIcon = new ImageIcon(sampleClass.getResource(samples[i].getIconPath()));
                }
                catch (Exception e) {
                    sampleIcon = null;
                }
            }
            if (initParam != null) {
                this.addDemo((DefaultMutableTreeNode)categoryNode, sampleClass, sampleTitle, showSources, (Object)initParam);
                continue;
            }
            if (sampleIcon != null) {
                this.addDemo((DefaultMutableTreeNode)categoryNode, sampleClass, sampleTitle, showSources, sampleIcon);
                continue;
            }
            this.addDemo(categoryNode, sampleClass, sampleTitle, showSources);
        }
    }

    private int getAppendIndex(DefaultMutableTreeNode node) {
        if (node.isLeaf()) {
            return 0;
        }
        TreeNode lastChild = node.getLastChild();
        return node.getIndex(lastChild) + 1;
    }

    private void appendNode(DefaultMutableTreeNode node, DefaultMutableTreeNode nodeToAppend) {
        node.insert(nodeToAppend, this.getAppendIndex(node));
    }

    private void addDemo(DefaultMutableTreeNode parentNode, Class demoClass, String title, boolean showSources) {
        this.appendNode(parentNode, new DemoNode(demoClass, title, showSources));
    }

    private void addDemo(DefaultMutableTreeNode parentNode, Class demoClass, String title, boolean showSources, Object initParameter) {
        this.appendNode(parentNode, new DemoNode(demoClass, title, showSources, initParameter));
    }

    private void addDemo(DefaultMutableTreeNode parentNode, Class demoClass, String title, boolean showSources, ImageIcon icon) {
        this.appendNode(parentNode, new DemoNode(demoClass, title, showSources, icon));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CategoryNode
    extends DefaultMutableTreeNode {
        private String _description;
        private String _name;
        private Object _demo;

        public CategoryNode(String name, String description) {
            this._description = description;
            this._name = name;
        }

        public ImageIcon getIcon() {
            return null;
        }

        public Object getUserObject() {
            if (this._demo == null) {
                try {
                    this.createDemoInstance();
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            }
            return this._demo;
        }

        private void createDemoInstance() {
            this._demo = new CategoryPanel(this._description);
        }

        public String toString() {
            return this._name;
        }
    }

    class DemoNode
    extends DefaultMutableTreeNode {
        private Class _demoClass;
        private Object _demo;
        private String _name;
        private Object _initParameter;
        private ImageIcon _customIcon;
        private boolean _showSources;
        private Object _sourcePanel;

        public DemoNode(Class demoClass, String name, boolean showSources) {
            this._demoClass = demoClass;
            this._name = name;
            this._showSources = showSources;
        }

        public DemoNode(Class demoClass, String name, boolean showSources, ImageIcon icon) {
            this(demoClass, name, showSources);
            this._customIcon = icon;
        }

        public DemoNode(Class demoClass, String name, boolean showSources, Object initParameter) {
            this(demoClass, name, showSources);
            this._initParameter = initParameter;
        }

        public boolean getShowSources() {
            return this._showSources;
        }

        public ImageIcon getIcon() {
            ImageIcon result = null;
            if (this._customIcon != null) {
                result = this._customIcon;
            } else if (this._initParameter != null) {
                try {
                    Method getIconMethod = this._initParameter.getClass().getDeclaredMethod("getIcon", null);
                    getIconMethod.setAccessible(true);
                    result = (ImageIcon)getIconMethod.invoke(this._initParameter, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }

        Object getSourcesPanel() {
            if (this._sourcePanel == null) {
                try {
                    if (this._initParameter != null) {
                        Constructor constructor = DemoTreeModel.this._sourcePanel.getConstructor(class$java$awt$Window == null ? (class$java$awt$Window = DemoTreeModel.class$("java.awt.Window")) : class$java$awt$Window, class$java$lang$Class == null ? (class$java$lang$Class = DemoTreeModel.class$("java.lang.Class")) : class$java$lang$Class);
                        this._sourcePanel = constructor.newInstance(DemoTreeModel.this._parent, this._initParameter.getClass());
                    } else {
                        Constructor constructor = DemoTreeModel.this._sourcePanel.getConstructor(class$java$awt$Window == null ? (class$java$awt$Window = DemoTreeModel.class$("java.awt.Window")) : class$java$awt$Window, class$java$lang$Class == null ? (class$java$lang$Class = DemoTreeModel.class$("java.lang.Class")) : class$java$lang$Class);
                        this._sourcePanel = constructor.newInstance(DemoTreeModel.this._parent, this._demoClass);
                    }
                }
                catch (Exception e) {
                    LOG.error("Invalid SourcePanel class", (Throwable)e);
                }
            }
            return this._sourcePanel;
        }

        public Object getUserObject() {
            if (this._demo == null) {
                try {
                    this.createDemoInstance();
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            }
            return this._demo;
        }

        private void createDemoInstance() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            if (this._initParameter == null) {
                Constructor constructor = this._demoClass.getConstructor(class$java$awt$Window == null ? (class$java$awt$Window = DemoTreeModel.class$("java.awt.Window")) : class$java$awt$Window);
                this._demo = constructor.newInstance(DemoTreeModel.this._parent);
            } else {
                Constructor constructor = this._demoClass.getConstructor(class$java$awt$Window == null ? (class$java$awt$Window = DemoTreeModel.class$("java.awt.Window")) : class$java$awt$Window, class$java$lang$Object == null ? (class$java$lang$Object = DemoTreeModel.class$("java.lang.Object")) : class$java$lang$Object);
                this._demo = constructor.newInstance(DemoTreeModel.this._parent, this._initParameter);
            }
        }

        public String toString() {
            return this._name;
        }
    }
}

