/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.win32.com.types.ClsCtx;
import com.jniwrapper.win32.ole.OleFunctions;
import com.jniwrapper.win32.samples.demo.ComfyJSample;
import com.jniwrapper.win32.shell.ApplicationBar;
import com.jniwrapper.win32.shell.ApplyChangesOptions;
import com.jniwrapper.win32.shell.impl.IActiveDesktopImpl;
import com.jniwrapper.win32.ui.controls.SelectFileField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ActiveDesktopSample
extends ComfyJSample {
    private JLabel lblAdvisoryText;
    private JLabel lblFileNameCaption;
    private SelectFileField _selectFileField;
    private JButton btnSetWallpaper;
    private JLabel lblTaskbarAdvisoryText;
    private JLabel lblCurrentTaskbarStateCaption;
    private JLabel lblCurrentTaskbarState;
    private JLabel lblSetupTaskbarState;
    private JCheckBox cbAutohide;
    private JCheckBox cbAlwaysOnTop;
    private JButton btnSetupState;
    private JLabel lblNotSupported;

    public ActiveDesktopSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new HTMLText("The page demonstrates WinPack ability to manage desktop using ActiveDesktop interface.", false);
        boolean comfyjAvailable = this.isComfyJAvailable();
        this.lblNotSupported = comfyjAvailable ? new JLabel() : new HTMLText("<b><FONT color = red>NOTE:</FONT> The ActiveDesktop functionality requires the ComfyJ library and ComfyJ license file.");
        this.lblFileNameCaption = new JLabel("Select File:");
        this._selectFileField = new SelectFileField();
        this.btnSetWallpaper = new JButton("Set as Wallpaper");
        if (comfyjAvailable) {
            this.btnSetWallpaper.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OleFunctions.oleInitialize();
                    IActiveDesktopImpl iActiveDesktop = new IActiveDesktopImpl(ClsCtx.INPROC_SERVER);
                    File value = new File(ActiveDesktopSample.this._selectFileField.getFileName());
                    iActiveDesktop.setWallpaper(value);
                    iActiveDesktop.applyChanges(new ApplyChangesOptions(7L));
                }
            });
        } else {
            this._selectFileField.setEnabled(false);
            this.btnSetWallpaper.setEnabled(false);
        }
        this.lblTaskbarAdvisoryText = new HTMLText("Also WinPack provides the ability to manage taskbar state using ApplicationBar class.");
        this.lblCurrentTaskbarStateCaption = new JLabel("Current Taskbar State: ");
        this.lblCurrentTaskbarState = new HTMLText("<b>" + this.getTaskbarState() + "</b>");
        this.lblSetupTaskbarState = new JLabel("Setup Taskbar State: ");
        this.cbAutohide = new JCheckBox("Auto-hide the taskbar");
        this.cbAlwaysOnTop = new JCheckBox("Keep the taskbar on top of other windows");
        this.btnSetupState = new JButton("Apply");
        this.btnSetupState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ActiveDesktopSample.this.cbAlwaysOnTop.isSelected() && ActiveDesktopSample.this.cbAutohide.isSelected()) {
                    ApplicationBar.setAppBarState((ApplicationBar.BarState)ApplicationBar.BarState.AUTOHIDE_ALWAYSONTOP);
                } else if (ActiveDesktopSample.this.cbAlwaysOnTop.isSelected()) {
                    ApplicationBar.setAppBarState((ApplicationBar.BarState)ApplicationBar.BarState.ALWAYSONTOP);
                } else if (ActiveDesktopSample.this.cbAutohide.isSelected()) {
                    ApplicationBar.setAppBarState((ApplicationBar.BarState)ApplicationBar.BarState.AUTOHIDE);
                } else {
                    ApplicationBar.setAppBarState((ApplicationBar.BarState)ApplicationBar.BarState.NONE);
                }
                ActiveDesktopSample.this.lblCurrentTaskbarState.setText("<b>" + ActiveDesktopSample.this.getTaskbarState() + "</b>");
            }
        });
        ApplicationBar.BarState barState = ApplicationBar.getAppBarState();
        if (barState == ApplicationBar.BarState.AUTOHIDE_ALWAYSONTOP) {
            this.cbAutohide.setSelected(true);
            this.cbAlwaysOnTop.setSelected(true);
        } else if (barState == ApplicationBar.BarState.AUTOHIDE) {
            this.cbAutohide.setSelected(true);
            this.cbAlwaysOnTop.setSelected(false);
        } else if (barState == ApplicationBar.BarState.ALWAYSONTOP) {
            this.cbAutohide.setSelected(false);
            this.cbAlwaysOnTop.setSelected(true);
        } else if (barState == ApplicationBar.BarState.NONE) {
            this.cbAutohide.setSelected(false);
            this.cbAlwaysOnTop.setSelected(false);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblFileNameCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this._selectFileField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.btnSetWallpaper, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblNotSupported, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.lblTaskbarAdvisoryText, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(30, 10, 10, 10), 0, 0));
        this.add((Component)this.lblCurrentTaskbarStateCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblCurrentTaskbarState, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblSetupTaskbarState, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.cbAutohide, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.cbAlwaysOnTop, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.add((Component)this.btnSetupState, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 8, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._selectFileField.getDialog().getOptions().setMultiselectionAllowed(false);
        this._selectFileField.getDialog().setFilter("All Files (*.*)|*.*");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ApplicationBar.BarState barState = ApplicationBar.getAppBarState();
                if (barState == ApplicationBar.BarState.AUTOHIDE_ALWAYSONTOP) {
                    ActiveDesktopSample.this.cbAutohide.setSelected(true);
                    ActiveDesktopSample.this.cbAlwaysOnTop.setSelected(true);
                } else if (barState == ApplicationBar.BarState.AUTOHIDE) {
                    ActiveDesktopSample.this.cbAutohide.setSelected(true);
                    ActiveDesktopSample.this.cbAlwaysOnTop.setSelected(false);
                } else if (barState == ApplicationBar.BarState.ALWAYSONTOP) {
                    ActiveDesktopSample.this.cbAutohide.setSelected(false);
                    ActiveDesktopSample.this.cbAlwaysOnTop.setSelected(true);
                } else if (barState == ApplicationBar.BarState.NONE) {
                    ActiveDesktopSample.this.cbAutohide.setSelected(false);
                    ActiveDesktopSample.this.cbAlwaysOnTop.setSelected(false);
                }
            }
        });
        super.initialize();
    }

    private String getTaskbarState() {
        ApplicationBar.BarState aBarState = ApplicationBar.getAppBarState();
        if (aBarState.equals((Object)ApplicationBar.BarState.ALWAYSONTOP)) {
            return "Taskbar is always on top";
        }
        if (aBarState.equals((Object)ApplicationBar.BarState.AUTOHIDE)) {
            return "Taskbar auto-hides when inactive";
        }
        if (aBarState.equals((Object)ApplicationBar.BarState.AUTOHIDE_ALWAYSONTOP)) {
            return "Taskbar is always on top and auto-hides when inactive";
        }
        return "Taskbar is not always on top";
    }
}

