/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.win32.system.VersionInfo;
import com.jniwrapper.win32.system.eventlog.EventLog;
import com.jniwrapper.win32.system.eventlog.EventLogMessage;
import com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.plaf.TabbedPaneUI;

public class EventLogSample
extends LazyPanel {
    private JLabel lblAdvisoryText;
    private JLabel lblNotSupported;
    private JTabbedPane _eventLogPane;
    private JPanel _applicationLog;
    private JPanel _systemLog;
    private JPanel _securityLog;
    private JButton btnUpdate;
    private boolean _isWinNT;

    public EventLogSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        VersionInfo versionInfo = new VersionInfo();
        this._isWinNT = false;
        boolean _isSecurityProblem = false;
        if (versionInfo.isNT()) {
            this._isWinNT = true;
        }
        this.lblAdvisoryText = new HTMLText("The page demonstrates the WinPack ability to manage NT event logs, using the Event Logging API.<br>Press the \"Update\" button to update the list.");
        this.lblAdvisoryText.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (!this._isWinNT) {
            this.lblNotSupported = new HTMLText("<b><FONT color = red>NOTE:</FONT> Event logging functionality is not supported by the current version of operation system.");
            this.lblNotSupported.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        } else {
            this.lblNotSupported = new JLabel();
        }
        try {
            this._applicationLog = new EventLogPanel("Application");
            this._systemLog = new EventLogPanel("System");
            this._securityLog = new EventLogPanel("Security");
        }
        catch (Exception ex) {
            this.lblAdvisoryText.setText("The page demonstrates the WinPack ability to manage NT event logs, using the Event Logging API.<br>Press the \"Update\" button to update the list.<br><br>&nbsp;<b><FONT color = red>NOTE:</FONT> You should have Administrator rights to have the events displayed.</b>");
            _isSecurityProblem = true;
        }
        this._eventLogPane = new JTabbedPane();
        this._eventLogPane.setUI((TabbedPaneUI)new WindowsTabbedPaneUI());
        this._eventLogPane.addTab("Application", this._applicationLog);
        this._eventLogPane.addTab("System", this._systemLog);
        this._eventLogPane.addTab("Security", this._securityLog);
        this._eventLogPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.btnUpdate = new JButton("Update");
        this.btnUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EventLogPanel logPanel = (EventLogPanel)EventLogSample.this._eventLogPane.getSelectedComponent();
                if (logPanel != null) {
                    logPanel.update();
                }
            }
        });
        JPanel updatePanel = new JPanel();
        updatePanel.add(this.btnUpdate);
        updatePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblAdvisoryText, "North");
        if (this._isWinNT) {
            this.add((Component)this._eventLogPane, "Center");
            this.add((Component)updatePanel, "South");
        } else {
            this.add((Component)this.lblNotSupported, "Center");
        }
        if (_isSecurityProblem) {
            this.add((Component)this.lblNotSupported, "Center");
        }
        super.initialize();
    }

    private static class EventLogPanel
    extends JPanel {
        private JTable _table;
        private List _messages;
        private String _logName;

        public EventLogPanel(String logName) {
            super(new BorderLayout());
            this._logName = logName;
            this.prepareMessageList(logName);
            this.fillTable();
            this.add((Component)new JScrollPane(this._table), "Center");
        }

        private void prepareMessageList(String logName) {
            EventLog eventLog = new EventLog(logName);
            this._messages = eventLog.getMessages();
            eventLog.close();
        }

        private void fillTable() {
            Object[] columnNames = new String[]{"Computer", "User", "Source", "Date", "Type", "Message"};
            Object[][] values = new String[this._messages.size()][6];
            for (int i = 0; i < this._messages.size(); ++i) {
                EventLogMessage message = (EventLogMessage)this._messages.get(i);
                values[i][0] = message.getComputer();
                values[i][1] = message.getUser() == null ? "N/A" : message.getUser();
                values[i][2] = message.getSource();
                values[i][3] = message.getDate().toString();
                values[i][4] = message.getEventType().toString();
                values[i][5] = message.getMessage();
            }
            this._table = new JTable(values, columnNames);
            this._table.setEnabled(false);
        }

        public void update() {
            this.prepareMessageList(this._logName);
            this.fillTable();
        }
    }
}

